/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.api.Transformer;
import org.gradle.internal.Actions;
import org.gradle.internal.Transformers;
import org.gradle.model.InvalidModelRuleException;
import org.gradle.model.ModelRuleBindingException;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelBinding;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelElement;
import org.gradle.model.internal.core.ModelMutator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRuleExecutionException;
import org.gradle.model.internal.core.ModelRuleInput;
import org.gradle.model.internal.core.ModelState;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.BoundModelCreator;
import org.gradle.model.internal.registry.BoundModelMutator;
import org.gradle.model.internal.registry.DefaultInputs;
import org.gradle.model.internal.registry.DuplicateModelException;
import org.gradle.model.internal.registry.ModelCreationListener;
import org.gradle.model.internal.registry.ModelPathSuggestionProvider;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.registry.RuleBinder;
import org.gradle.model.internal.registry.UnboundModelRulesException;
import org.gradle.model.internal.registry.UnboundRulesProcessor;
import org.gradle.model.internal.report.AmbiguousBindingReporter;
import org.gradle.model.internal.report.IncompatibleTypeReferenceReporter;
import org.gradle.model.internal.report.unbound.UnboundRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelRegistry
implements ModelRegistry {
    private final Map<ModelPath, ModelElement> store = new HashMap<ModelPath, ModelElement>();
    private final Map<ModelPath, BoundModelCreator> creations = new HashMap<ModelPath, BoundModelCreator>();
    private final Multimap<ModelPath, BoundModelMutator<?>> mutators = ArrayListMultimap.create();
    private final Multimap<ModelPath, List<ModelPath>> usedMutators = ArrayListMultimap.create();
    private final Multimap<ModelPath, BoundModelMutator<?>> finalizers = ArrayListMultimap.create();
    private final Multimap<ModelPath, List<ModelPath>> usedFinalizers = ArrayListMultimap.create();
    private final List<ModelCreationListener> modelCreationListeners = new LinkedList<ModelCreationListener>();
    private final List<RuleBinder<?>> binders = Lists.newLinkedList();
    private BoundModelCreator inCreation;

    private static String toString(ModelRuleDescriptor descriptor) {
        StringBuilder stringBuilder = new StringBuilder();
        descriptor.describeTo(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void create(ModelCreator creator) {
        ModelPath path = creator.getPath();
        BoundModelCreator existingCreation = this.creations.get(path);
        if (existingCreation != null) {
            throw new DuplicateModelException(String.format("Cannot register model creation rule '%s' for path '%s' as the rule '%s' is already registered to create a model element at this path", DefaultModelRegistry.toString(creator.getDescriptor()), path, DefaultModelRegistry.toString(existingCreation.getCreator().getDescriptor())));
        }
        ModelElement existing = this.store.get(path);
        if (existing != null) {
            throw new DuplicateModelException(String.format("Cannot register model creation rule '%s' for path '%s' as the rule '%s' is already registered (and the model element has been created)", DefaultModelRegistry.toString(creator.getDescriptor()), path, DefaultModelRegistry.toString(existing.getCreatorDescriptor())));
        }
        this.notifyCreationListeners(creator);
        this.bind(creator);
    }

    @Override
    public <T> void mutate(ModelMutator<T> mutator) {
        this.bind(mutator, this.mutators);
    }

    @Override
    public <T> void finalize(ModelMutator<T> mutator) {
        this.bind(mutator, this.finalizers);
    }

    private void bind(final ModelCreator creator) {
        RuleBinder<Void> binder = this.bind(null, creator.getInputs(), creator.getDescriptor(), new Action<RuleBinder<Void>>(){

            public void execute(RuleBinder<Void> ruleBinding) {
                BoundModelCreator boundCreator = new BoundModelCreator(creator, ruleBinding.getInputBindings());
                DefaultModelRegistry.this.creations.put(creator.getPath(), boundCreator);
            }
        });
        this.bindInputs(binder);
    }

    private <T> RuleBinder<T> bind(ModelReference<T> subject, List<ModelReference<?>> inputs, ModelRuleDescriptor descriptor, Action<? super RuleBinder<T>> onBind) {
        RuleBinder<T> binder = new RuleBinder<T>(subject, inputs, descriptor, Actions.composite((Action[])new Action[]{new Action<RuleBinder<T>>(){

            public void execute(RuleBinder<T> binder) {
                DefaultModelRegistry.this.binders.remove(binder);
            }
        }, onBind}));
        if (!binder.isBound()) {
            this.binders.add(binder);
        }
        return binder;
    }

    private <T> void bind(final ModelMutator<T> mutator, final Multimap<ModelPath, BoundModelMutator<?>> mutators) {
        final RuleBinder<T> binder = this.bind(mutator.getSubject(), mutator.getInputs(), mutator.getDescriptor(), new Action<RuleBinder<T>>(){

            public void execute(RuleBinder<T> ruleBinder) {
                BoundModelMutator boundMutator = new BoundModelMutator(mutator, ruleBinder.getSubjectBinding(), ruleBinder.getInputBindings());
                ModelPath path = boundMutator.getSubject().getPath();
                DefaultModelRegistry.this.assertNotFinalized(path);
                mutators.put((Object)path, boundMutator);
            }
        });
        this.registerListener(new BinderCreationListener(binder.getDescriptor(), binder.getSubjectReference(), true, (Action<? super ModelPath>)new Action<ModelPath>(){

            public void execute(ModelPath modelPath) {
                binder.bindSubject(modelPath);
            }
        }));
        this.bindInputs(binder);
    }

    private void bindInputs(final RuleBinder<?> binder) {
        List<ModelReference<?>> inputReferences = binder.getInputReferences();
        for (int i = 0; i < inputReferences.size(); ++i) {
            final int finalI = i;
            this.registerListener(new BinderCreationListener(binder.getDescriptor(), inputReferences.get(i), false, (Action<? super ModelPath>)new Action<ModelPath>(){

                public void execute(ModelPath modelPath) {
                    binder.bindInput(finalI, modelPath);
                }
            }));
        }
    }

    private void assertNotFinalized(ModelPath path) {
        if (this.store.containsKey(path)) {
            throw new IllegalStateException("model '" + path + "' is finalized");
        }
    }

    @Override
    public <T> T get(ModelPath path, ModelType<T> type) {
        ModelElement element = this.get(path);
        ModelView<T> typed = this.assertView(element, type, "get(ModelPath, ModelType)", new Object[0]);
        return typed.getInstance();
    }

    @Override
    public ModelElement element(ModelPath path) {
        return this.get(path);
    }

    @Override
    public ModelState state(ModelPath path) {
        ModelElement closed = this.store.get(path);
        if (closed != null) {
            return this.toState(closed.getPath(), ModelState.Status.FINALIZED);
        }
        BoundModelCreator creator = this.creations.get(path);
        if (creator != null) {
            return this.toState(creator.getCreator().getPath(), ModelState.Status.PENDING);
        }
        if (this.inCreation != null && this.inCreation.getCreator().getPath().equals(path)) {
            return this.toState(this.inCreation.getCreator().getPath(), ModelState.Status.IN_CREATION);
        }
        return null;
    }

    private ModelState toState(ModelPath path, ModelState.Status status) {
        return new ModelState(path, status);
    }

    public void registerListener(ModelCreationListener listener) {
        boolean remove;
        ArrayList<ModelPath> creationKeys = new ArrayList<ModelPath>(this.creations.keySet());
        for (ModelPath key : creationKeys) {
            BoundModelCreator boundCreator = this.creations.get(key);
            ModelCreator creator = boundCreator.getCreator();
            remove = listener.onCreate(creator.getDescriptor(), creator.getPath(), creator.getPromise());
            if (!remove) continue;
            return;
        }
        for (ModelElement element : this.store.values()) {
            remove = listener.onCreate(element.getCreatorDescriptor(), element.getPath(), element.getPromise());
            if (!remove) continue;
            return;
        }
        this.modelCreationListeners.add(listener);
    }

    @Override
    public void remove(ModelPath path) {
        if (this.creations.remove(path) == null && this.store.remove(path) == null) {
            throw new RuntimeException("Tried to remove model " + path + " but it is not registered");
        }
        if (this.isDependedOn(path)) {
            throw new RuntimeException("Tried to remove model " + path + " but it is depended on by other model elements");
        }
    }

    @Override
    public void validate() throws UnboundModelRulesException {
        if (!this.binders.isEmpty()) {
            ModelPathSuggestionProvider suggestionsProvider = new ModelPathSuggestionProvider(Iterables.concat(this.store.keySet(), this.creations.keySet()));
            List<? extends UnboundRule> unboundRules = new UnboundRulesProcessor(this.binders, suggestionsProvider).process();
            throw new UnboundModelRulesException(unboundRules);
        }
    }

    private boolean isDependedOn(ModelPath candidate) {
        Transformer extractInputPaths = new Transformer<Iterable<ModelPath>, BoundModelMutator<?>>(){

            public Iterable<ModelPath> transform(BoundModelMutator<?> original) {
                return Iterables.transform(original.getInputs(), (Function)new Function<ModelBinding<?>, ModelPath>(){

                    @Nullable
                    public ModelPath apply(ModelBinding<?> input) {
                        return input.getPath();
                    }
                });
            }
        };
        Transformer passThrough = Transformers.noOpTransformer();
        return this.hasModelPath(candidate, this.mutators.values(), extractInputPaths) || this.hasModelPath(candidate, this.usedMutators.values(), passThrough) || this.hasModelPath(candidate, this.finalizers.values(), extractInputPaths) || this.hasModelPath(candidate, this.usedFinalizers.values(), passThrough);
    }

    private <T> boolean hasModelPath(ModelPath candidate, Iterable<T> things, Transformer<? extends Iterable<ModelPath>, T> transformer) {
        for (T thing : things) {
            for (ModelPath path : (Iterable)transformer.transform(thing)) {
                if (!path.equals(candidate)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<ModelPath> getPromisedPaths() {
        return ImmutableSet.builder().addAll(this.creations.keySet()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelElement get(ModelPath path) {
        if (this.store.containsKey(path)) {
            return this.store.get(path);
        }
        this.inCreation = this.removeCreator(path);
        try {
            ModelElement modelElement = this.createAndClose(this.inCreation);
            return modelElement;
        }
        finally {
            this.inCreation = null;
        }
    }

    private ModelElement createAndClose(BoundModelCreator creation) {
        ModelElement element = this.doCreate(creation);
        this.close(element);
        return element;
    }

    private void close(ModelElement model) {
        ModelPath path = model.getPath();
        this.fireMutations(model, this.mutators.removeAll((Object)path), this.usedMutators);
        this.fireMutations(model, this.finalizers.removeAll((Object)path), this.usedFinalizers);
        Set<ModelPath> promisedPaths = this.getPromisedPaths();
        for (ModelPath modelPath : promisedPaths) {
            if (!path.isDirectChild(modelPath)) continue;
            this.get(modelPath);
        }
    }

    private void fireMutations(ModelElement element, Iterable<BoundModelMutator<?>> mutators, Multimap<ModelPath, List<ModelPath>> used) {
        for (BoundModelMutator<?> mutator : mutators) {
            this.fireMutation(element, mutator);
            List inputPaths = Lists.transform(mutator.getInputs(), (Function)new Function<ModelBinding<?>, ModelPath>(){

                @Nullable
                public ModelPath apply(ModelBinding<?> input) {
                    return input.getPath();
                }
            });
            used.put((Object)element.getPath(), (Object)inputPaths);
        }
    }

    private <T> ModelView<? extends T> assertView(ModelElement element, ModelType<T> targetType, String msg, Object ... msgArgs) {
        ModelAdapter adapter = element.getAdapter();
        ModelView<T> view = adapter.asReadOnly(targetType);
        if (view == null) {
            throw new IllegalArgumentException("Model element " + element.getPath() + " is not compatible with requested " + targetType + " (operation: " + String.format(msg, msgArgs) + ")");
        }
        return view;
    }

    private <T> ModelView<? extends T> assertView(ModelElement element, ModelBinding<T> binding, ModelRuleDescriptor sourceDescriptor, Inputs inputs) {
        ModelAdapter adapter = element.getAdapter();
        ModelView<T> view = adapter.asWritable(binding, sourceDescriptor, inputs, this);
        if (view == null) {
            throw new IllegalArgumentException("Cannot project model element " + binding.getPath() + " to writable type '" + binding.getReference().getType() + "' for rule " + sourceDescriptor);
        }
        return view;
    }

    private BoundModelCreator removeCreator(ModelPath path) {
        BoundModelCreator creator = this.creations.remove(path);
        if (creator == null) {
            throw new IllegalStateException("No creator for '" + path + "'");
        }
        return creator;
    }

    private ModelElement doCreate(BoundModelCreator boundCreator) {
        ModelAdapter adapter;
        ModelCreator creator = boundCreator.getCreator();
        ModelPath path = creator.getPath();
        Inputs inputs = this.toInputs(boundCreator.getInputs());
        try {
            adapter = creator.create(inputs);
        }
        catch (Exception e) {
            throw new ModelRuleExecutionException(creator.getDescriptor(), e);
        }
        ModelElement element = this.toElement(adapter, creator);
        this.store.put(path, element);
        return element;
    }

    private ModelElement toElement(ModelAdapter adapter, ModelCreator creator) {
        return new ModelElement(creator.getPath(), creator.getPromise(), adapter, creator.getDescriptor());
    }

    private <T> void fireMutation(ModelElement element, BoundModelMutator<T> boundMutator) {
        Inputs inputs = this.toInputs(boundMutator.getInputs());
        ModelMutator<T> mutator = boundMutator.getMutator();
        ModelRuleDescriptor descriptor = mutator.getDescriptor();
        ModelView<T> view = this.assertView(element, boundMutator.getSubject(), descriptor, inputs);
        try {
            mutator.mutate(view.getInstance(), inputs);
        }
        catch (Exception e) {
            throw new ModelRuleExecutionException(descriptor, e);
        }
        finally {
            view.close();
        }
    }

    private Inputs toInputs(Iterable<? extends ModelBinding<?>> bindings) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ModelBinding<?> binding : bindings) {
            ModelRuleInput<?> input = this.toInput(binding);
            builder.add(input);
        }
        return new DefaultInputs((List<ModelRuleInput<?>>)builder.build());
    }

    private <T> ModelRuleInput<T> toInput(ModelBinding<T> binding) {
        ModelPath path = binding.getPath();
        ModelElement element = this.element(path);
        ModelView<T> view = this.assertView(element, binding.getReference().getType(), "toInputs", new Object[0]);
        return ModelRuleInput.of(binding, view);
    }

    private void notifyCreationListeners(ModelCreator creator) {
        ListIterator<ModelCreationListener> modelCreationListenerListIterator = this.modelCreationListeners.listIterator();
        while (modelCreationListenerListIterator.hasNext()) {
            ModelCreationListener next = modelCreationListenerListIterator.next();
            boolean remove = next.onCreate(creator.getDescriptor(), creator.getPath(), creator.getPromise());
            if (!remove) continue;
            modelCreationListenerListIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BinderCreationListener
    implements ModelCreationListener {
        private final ModelRuleDescriptor descriptor;
        private final ModelReference<?> reference;
        private final boolean writable;
        private final Action<? super ModelPath> bindAction;
        private ModelPath boundTo;
        private ModelRuleDescriptor boundToCreator;

        public BinderCreationListener(ModelRuleDescriptor descriptor, ModelReference<?> reference, boolean writable, Action<? super ModelPath> bindAction) {
            this.descriptor = descriptor;
            this.reference = reference;
            this.writable = writable;
            this.bindAction = bindAction;
        }

        @Override
        public boolean onCreate(ModelRuleDescriptor creatorDescriptor, ModelPath path, ModelPromise promise) {
            if (this.boundTo != null && this.isTypeCompatible(promise)) {
                throw new InvalidModelRuleException(this.descriptor, (Throwable)((Object)new ModelRuleBindingException(new AmbiguousBindingReporter(this.reference, this.boundTo, this.boundToCreator, path, creatorDescriptor).asString())));
            }
            if (this.reference.getPath() == null) {
                boolean typeCompatible = this.isTypeCompatible(promise);
                if (typeCompatible) {
                    this.bindAction.execute((Object)path);
                    this.boundTo = path;
                    this.boundToCreator = creatorDescriptor;
                    return false;
                }
            } else if (path.equals(this.reference.getPath())) {
                boolean typeCompatible = this.isTypeCompatible(promise);
                if (typeCompatible) {
                    this.bindAction.execute((Object)path);
                    return true;
                }
                throw new InvalidModelRuleException(this.descriptor, (Throwable)((Object)new ModelRuleBindingException(IncompatibleTypeReferenceReporter.of(creatorDescriptor, promise, this.reference, this.writable).asString())));
            }
            return false;
        }

        private boolean isTypeCompatible(ModelPromise promise) {
            return this.writable ? promise.asWritable(this.reference.getType()) : promise.asReadOnly(this.reference.getType());
        }
    }
}

