/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.rule.describe.MethodModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.DefaultMethodRuleDefinition;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.MethodRuleDefinitionHandler;
import org.gradle.model.internal.inspect.RuleSourceDependencies;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelRuleInspector {
    private final Iterable<MethodRuleDefinitionHandler> handlers;

    public ModelRuleInspector(Iterable<MethodRuleDefinitionHandler> handlers) {
        this.handlers = handlers;
    }

    private String describeHandlers() {
        String desc = Joiner.on((String)", ").join((Iterable)CollectionUtils.collect(this.handlers, (Transformer)new Transformer<String, MethodRuleDefinitionHandler>(){

            public String transform(MethodRuleDefinitionHandler original) {
                return original.getDescription();
            }
        }));
        return "[" + desc + "]";
    }

    private static RuntimeException invalid(Class<?> source, String reason) {
        return new InvalidModelRuleDeclarationException("Type " + source.getName() + " is not a valid model rule source: " + reason);
    }

    private static RuntimeException invalid(Method method, String reason) {
        return ModelRuleInspector.invalid("model rule method", new MethodModelRuleDescriptor(method), reason);
    }

    private static RuntimeException invalid(String description, ModelRuleDescriptor rule, String reason) {
        StringBuilder sb = new StringBuilder();
        rule.describeTo(sb);
        sb.append(" is not a valid ").append(description).append(": ").append(reason);
        return new InvalidModelRuleDeclarationException(sb.toString());
    }

    public Set<Class<?>> getDeclaredSources(Class<?> container) {
        Class<?>[] declaredClasses = container.getDeclaredClasses();
        if (declaredClasses.length == 0) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder found = ImmutableSet.builder();
        for (Class<?> declaredClass : declaredClasses) {
            if (!declaredClass.isAnnotationPresent(RuleSource.class)) continue;
            found.add(declaredClass);
        }
        return found.build();
    }

    public <T> void inspect(Class<T> source, ModelRegistry modelRegistry, RuleSourceDependencies dependencies) {
        this.validate(source);
        Method[] methods = source.getDeclaredMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (Method method : methods) {
            this.validate(method);
            MethodRuleDefinition ruleDefinition = DefaultMethodRuleDefinition.create(source, method);
            MethodRuleDefinitionHandler handler = this.getMethodHandler(ruleDefinition);
            if (handler == null) continue;
            handler.register(ruleDefinition, modelRegistry, dependencies);
        }
    }

    private MethodRuleDefinitionHandler getMethodHandler(MethodRuleDefinition<?> ruleDefinition) {
        MethodRuleDefinitionHandler handler = null;
        for (MethodRuleDefinitionHandler candidateHandler : this.handlers) {
            if (!candidateHandler.getSpec().isSatisfiedBy(ruleDefinition)) continue;
            if (handler == null) {
                handler = candidateHandler;
                continue;
            }
            throw ModelRuleInspector.invalid("model rule method", ruleDefinition.getDescriptor(), "can only be one of " + this.describeHandlers());
        }
        return handler;
    }

    public void validate(Class<?> source) throws InvalidModelRuleDeclarationException {
        Field[] fields;
        Class<?> superclass;
        int modifiers = source.getModifiers();
        if (Modifier.isInterface(modifiers)) {
            throw ModelRuleInspector.invalid(source, "must be a class, not an interface");
        }
        if (Modifier.isAbstract(modifiers)) {
            throw ModelRuleInspector.invalid(source, "class cannot be abstract");
        }
        if (source.getEnclosingClass() != null) {
            if (Modifier.isStatic(modifiers)) {
                if (Modifier.isPrivate(modifiers)) {
                    throw ModelRuleInspector.invalid(source, "class cannot be private");
                }
            } else {
                throw ModelRuleInspector.invalid(source, "enclosed classes must be static and non private");
            }
        }
        if (!(superclass = source.getSuperclass()).equals(Object.class)) {
            throw ModelRuleInspector.invalid(source, "cannot have superclass");
        }
        Constructor<?>[] constructors = source.getDeclaredConstructors();
        if (constructors.length > 1) {
            throw ModelRuleInspector.invalid(source, "cannot have more than one constructor");
        }
        Constructor<?> constructor = constructors[0];
        if (constructor.getParameterTypes().length > 0) {
            throw ModelRuleInspector.invalid(source, "constructor cannot take any arguments");
        }
        for (Field field : fields = source.getDeclaredFields()) {
            int fieldModifiers = field.getModifiers();
            if (field.isSynthetic() || Modifier.isStatic(fieldModifiers) && Modifier.isFinal(fieldModifiers)) continue;
            throw ModelRuleInspector.invalid(source, "field " + field.getName() + " is not static final");
        }
    }

    private void validate(Method ruleMethod) {
        if (ruleMethod.getTypeParameters().length > 0) {
            throw ModelRuleInspector.invalid(ruleMethod, "cannot have type variables (i.e. cannot be a generic method)");
        }
    }
}

