/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.lang.annotation.Annotation;
import java.util.List;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.ModelMutator;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.AbstractAnnotationDrivenMethodRuleDefinitionHandler;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.ModelRuleInvoker;
import org.gradle.model.internal.inspect.RuleSourceDependencies;
import org.gradle.model.internal.registry.ModelRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutationRuleDefinitionHandler<T extends Annotation>
extends AbstractAnnotationDrivenMethodRuleDefinitionHandler<T> {
    public <R> void register(MethodRuleDefinition<R> ruleDefinition, ModelRegistry modelRegistry, RuleSourceDependencies dependencies) {
        List<ModelReference<?>> bindings = ruleDefinition.getReferences();
        ModelReference<?> subject = bindings.get(0);
        List<ModelReference<?>> inputs = bindings.subList(1, bindings.size());
        MethodModelMutator<?> mutator = AbstractMutationRuleDefinitionHandler.toMutator(ruleDefinition, subject, inputs);
        if (this.isFinalize()) {
            modelRegistry.finalize(mutator);
        } else {
            modelRegistry.mutate(mutator);
        }
    }

    protected abstract boolean isFinalize();

    private static <T> MethodModelMutator<T> toMutator(MethodRuleDefinition<?> ruleDefinition, ModelReference<T> first, List<ModelReference<?>> tail) {
        return new MethodModelMutator<T>(ruleDefinition.getRuleInvoker(), ruleDefinition.getDescriptor(), first, tail);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodModelMutator<T>
    implements ModelMutator<T> {
        private final ModelRuleDescriptor descriptor;
        private final ModelReference<T> subject;
        private final List<ModelReference<?>> inputs;
        private final ModelRuleInvoker<?> ruleInvoker;

        public MethodModelMutator(ModelRuleInvoker<?> ruleInvoker, ModelRuleDescriptor descriptor, ModelReference<T> subject, List<ModelReference<?>> inputs) {
            this.ruleInvoker = ruleInvoker;
            this.subject = subject;
            this.inputs = inputs;
            this.descriptor = descriptor;
        }

        @Override
        public ModelRuleDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public ModelReference<T> getSubject() {
            return this.subject;
        }

        @Override
        public List<ModelReference<?>> getInputs() {
            return this.inputs;
        }

        @Override
        public void mutate(T object, Inputs inputs) {
            Object[] args = new Object[1 + this.inputs.size()];
            args[0] = object;
            for (int i = 0; i < inputs.size(); ++i) {
                args[i + 1] = inputs.get(i, this.inputs.get(i).getType()).getInstance();
            }
            this.ruleInvoker.invoke(args);
        }
    }
}

