/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import org.gradle.api.Nullable;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelReference<T> {
    private final ModelPath path;
    private final ModelType<T> type;
    private final String description;

    private ModelReference(@Nullable ModelPath path, ModelType<T> type, String description) {
        this.path = path;
        this.type = type;
        this.description = description;
    }

    public static <T> ModelReference<T> of(ModelPath path, ModelType<T> type, String description) {
        return new ModelReference<T>(path, type, description);
    }

    public static <T> ModelReference<T> of(ModelPath path, ModelType<T> type) {
        return new ModelReference<T>(path, type, null);
    }

    public static <T> ModelReference<T> of(String path, Class<T> type) {
        return ModelReference.of(ModelPath.path(path), ModelType.of(type));
    }

    public static <T> ModelReference<T> of(Class<T> type) {
        return ModelReference.of(null, ModelType.of(type));
    }

    public static <T> ModelReference<T> of(ModelType<T> type) {
        return ModelReference.of(null, type);
    }

    public static ModelReference<?> of(String path) {
        return ModelReference.of(ModelPath.path(path), ModelType.UNTYPED);
    }

    public static ModelReference<Object> untyped(ModelPath path) {
        return ModelReference.untyped(path, null);
    }

    public static ModelReference<Object> untyped(ModelPath path, String description) {
        return ModelReference.of(path, ModelType.UNTYPED, description);
    }

    @Nullable
    public ModelPath getPath() {
        return this.path;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public ModelType<T> getType() {
        return this.type;
    }

    public boolean isUntyped() {
        return this.type.equals(ModelType.UNTYPED);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelReference that = (ModelReference)o;
        if (this.path == null) {
            if (that.path == null) {
                return this.type.equals(that.type);
            }
            return false;
        }
        return this.path.equals(that.path) && this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return "ModelReference{path=" + this.path + ", type=" + this.type + '}';
    }
}

