/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.remote;

import com.icl.saxon.TransformerFactoryImpl;
import java.io.File;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.List;
import javax.rmi.PortableRemoteObject;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.Value;
import org.intellij.plugins.xsltDebugger.rt.engine.local.LocalDebugger;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteBreakpointManager;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteBreakpointManagerImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteDebugger;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteEventQueueImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteFrameImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteVariableImpl;

public class DebuggerServer
extends PortableRemoteObject
implements RemoteDebugger {
    private static final String XSLT_DEBUGGER = "XsltDebugger";
    public static final int PORT = 34275;
    private final Debugger myDebugger;
    private final RemoteBreakpointManagerImpl myBreakpointManager;
    private final RemoteEventQueueImpl myEventQueue;
    private final int myPort;

    private DebuggerServer(Transformer transformer, Source xml, Result out, int port) throws TransformerConfigurationException, RemoteException {
        this.myPort = port;
        this.myDebugger = new LocalDebugger(transformer, xml, out){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stop(boolean b) {
                try {
                    super.stop(b);
                }
                finally {
                    if (b) {
                        System.exit(0);
                    }
                }
            }
        };
        this.myBreakpointManager = new RemoteBreakpointManagerImpl(this.myDebugger.getBreakpointManager());
        this.myEventQueue = new RemoteEventQueueImpl(this.myDebugger.getEventQueue());
    }

    public static DebuggerServer create(Transformer xsl, Source xml, Result out, int port) throws TransformerConfigurationException, RemoteException {
        DebuggerServer server = new DebuggerServer(xsl, xml, out, port);
        Registry registry = LocateRegistry.createRegistry(port);
        registry.rebind(XSLT_DEBUGGER, (Remote)((Object)server));
        return server;
    }

    public static DebuggerServer create(File f, File x) throws TransformerConfigurationException, RemoteException {
        return DebuggerServer.create(new TransformerFactoryImpl().newTransformer((Source)new StreamSource(f)), new StreamSource(x), new StreamResult(), 34275);
    }

    public void stop(boolean force) throws RemoteException {
        this.myDebugger.stop(force);
        try {
            LocateRegistry.getRegistry(this.myPort).unbind(XSLT_DEBUGGER);
        }
        catch (NotBoundException notBoundException) {
            // empty catch block
        }
    }

    public boolean ping() throws RemoteException {
        return this.myDebugger.ping();
    }

    public Debugger.State waitForStateChange(Debugger.State state) throws RemoteException {
        return this.myDebugger.waitForStateChange(state);
    }

    public boolean waitForDebuggee() throws RemoteException {
        return this.myDebugger.waitForDebuggee();
    }

    public boolean start() throws RemoteException {
        return this.myDebugger.start();
    }

    public void step() throws RemoteException {
        this.myDebugger.step();
    }

    public void stepInto() throws RemoteException {
        this.myDebugger.stepInto();
    }

    public void resume() throws RemoteException {
        this.myDebugger.resume();
    }

    public boolean isStopped() throws RemoteException {
        return this.myDebugger.isStopped();
    }

    public RemoteDebugger.Frame getCurrentFrame() throws RemoteException {
        return RemoteFrameImpl.create((Debugger.Frame)this.myDebugger.getCurrentFrame());
    }

    public RemoteDebugger.Frame getSourceFrame() throws RemoteException {
        return RemoteFrameImpl.create((Debugger.Frame)this.myDebugger.getSourceFrame());
    }

    public Value eval(String expr) throws RemoteException, Debugger.EvaluationException {
        return this.getCurrentFrame().eval(expr);
    }

    public List<RemoteDebugger.Variable> getGlobalVariables() throws RemoteException {
        return RemoteVariableImpl.convert((List)this.myDebugger.getGlobalVariables());
    }

    public RemoteBreakpointManager getBreakpointManager() throws RemoteException {
        return this.myBreakpointManager;
    }

    public Debugger.State getState() throws RemoteException {
        return this.myDebugger.getState();
    }

    public void pause() throws RemoteException {
        this.myDebugger.pause();
    }

    public RemoteDebugger.EventQueue getEventQueue() throws RemoteException {
        return this.myEventQueue;
    }
}

