/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.i18n.I18nQuickFixHandler;
import com.intellij.codeInspection.i18n.I18nizeHandlerProvider;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class I18nizeJspHandlerProvider
extends I18nizeHandlerProvider {
    private static final I18nQuickFixHandler HADLER = new I18nQuickFixHandler(){

        @Override
        public void checkApplicability(PsiFile psiFile, Editor editor) throws IncorrectOperationException {
            final JspFile jspFile = (JspFile)psiFile;
            final TextRange selectedRange = JavaI18nUtil.getSelectedRange(editor, (PsiFile)jspFile);
            PsiFile root = jspFile.getBaseLanguageRoot();
            root.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement element) {
                    TextRange elementRange = element.getTextRange();
                    if (elementRange.intersectsStrict(selectedRange) && (jspFile.getLanguage() != StdLanguages.JSPX && element instanceof OuterLanguageElement || element instanceof XmlTag && !selectedRange.contains(elementRange) && (!elementRange.contains(selectedRange) || !((XmlTag)element).getValue().getTextRange().contains(selectedRange)))) {
                        throw new IncorrectOperationException(CodeInsightBundle.message((String)"i18nize.jsp.error", (Object[])new Object[0]));
                    }
                    super.visitElement(element);
                }
            });
        }

        @Override
        public void performI18nization(PsiFile psiFile, Editor editor, PsiLiteralExpression literalExpression, Collection<PropertiesFile> propertiesFiles, String key, String value, String i18nizedText, PsiExpression[] parameters, PropertyCreationHandler propertyCreationHandler) throws IncorrectOperationException {
            Project project = psiFile.getProject();
            TextRange selectedText = JavaI18nUtil.getSelectedRange(editor, psiFile);
            if (selectedText == null) {
                return;
            }
            propertyCreationHandler.createProperty(project, propertiesFiles, key, value, parameters);
            editor.getDocument().replaceString(selectedText.getStartOffset(), selectedText.getEndOffset(), (CharSequence)i18nizedText);
        }

        @Override
        public JavaI18nizeQuickFixDialog createDialog(Project project, Editor editor, PsiFile psiFile) {
            JspFile jspFile = (JspFile)psiFile;
            TextRange selectedRange = JavaI18nUtil.getSelectedRange(editor, psiFile);
            if (selectedRange == null) {
                return null;
            }
            String text = editor.getDocument().getText(selectedRange);
            return new JavaI18nizeQuickFixDialog(project, (PsiFile)jspFile, null, text, null, false, true){

                @Override
                protected String getTemplateName() {
                    return "I18nized JSP Expression.jsp";
                }
            };
        }
    };

    @Override
    public I18nQuickFixHandler getHandler(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull TextRange range) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInspection/i18n/I18nizeJspHandlerProvider", "getHandler"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInspection/i18n/I18nizeJspHandlerProvider", "getHandler"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInspection/i18n/I18nizeJspHandlerProvider", "getHandler"));
        }
        return psiFile instanceof JspFile ? HADLER : null;
    }
}

