/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import java.io.File;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.impl.html.GeneratorPaths;
import jetbrains.coverage.report.impl.html.LocalGeneratorPaths;
import jetbrains.coverage.report.impl.html.ModuleInfo;
import jetbrains.coverage.report.impl.html.SortOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratorPathsImpl
implements GeneratorPaths {
    private final LocalGeneratorPaths myPaths;
    private final File myGeneratingFile;
    private final File myGeneratingDir;

    public GeneratorPathsImpl(@NotNull LocalGeneratorPaths paths, @NotNull File generatingFile) {
        if (paths == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/GeneratorPathsImpl.<init> must not be null");
        }
        if (generatingFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/html/GeneratorPathsImpl.<init> must not be null");
        }
        this.myGeneratingFile = generatingFile;
        this.myPaths = paths;
        this.myGeneratingDir = this.myGeneratingFile.getParentFile();
    }

    @NotNull
    private String makeRelative(@NotNull GeneratorPaths file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/GeneratorPathsImpl.makeRelative must not be null");
        }
        String string = this.makeRelative(file.getReportFileName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/GeneratorPathsImpl.makeRelative must not return null");
        }
        return string;
    }

    @NotNull
    private String makeRelative(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/GeneratorPathsImpl.makeRelative must not be null");
        }
        String mapped = GeneratorPathsImpl.makeRelative(this.myGeneratingDir.getAbsoluteFile(), file.getAbsoluteFile());
        if (mapped == null) {
            throw new IllegalArgumentException("Failed to map path: " + file + " as relative to " + this.myGeneratingDir);
        }
        String string = mapped.replace('\\', '/');
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/GeneratorPathsImpl.makeRelative must not return null");
        }
        return string;
    }

    private static String makeRelative(File base, File path) {
        if (base.equals(path)) {
            return ".";
        }
        String sFind = path.getPath();
        String sBasePath = base.getPath();
        if (!path.getPath().startsWith(sBasePath + File.separatorChar)) {
            String next = GeneratorPathsImpl.makeRelative(base.getParentFile(), path);
            if (".".equals(next)) {
                return "..";
            }
            return "../" + next;
        }
        return sFind.substring(sBasePath.length() + 1);
    }

    @NotNull
    public File getReportFileName() {
        File file = this.myGeneratingFile;
        if (file == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/GeneratorPathsImpl.getReportFileName must not return null");
        }
        return file;
    }

    @NotNull
    public String getOrder(@NotNull SortOption order) {
        if (order == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/GeneratorPathsImpl.getOrder must not be null");
        }
        String string = order.getIndexFileName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/GeneratorPathsImpl.getOrder must not return null");
        }
        return string;
    }

    @NotNull
    public String getResourcesPath() {
        String string = this.makeRelative(this.myPaths.getResourcesPath());
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/GeneratorPathsImpl.getResourcesPath must not return null");
        }
        return string;
    }

    @NotNull
    public String getModulesIndexPath(@NotNull SortOption order) {
        if (order == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/GeneratorPathsImpl.getModulesIndexPath must not be null");
        }
        String string = this.makeRelative(this.myPaths.getModulesIndexPath(order));
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/GeneratorPathsImpl.getModulesIndexPath must not return null");
        }
        return string;
    }

    @NotNull
    public String getNamespacesIndexPath(@NotNull ModuleInfo module, @NotNull SortOption order) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/GeneratorPathsImpl.getNamespacesIndexPath must not be null");
        }
        if (order == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/html/GeneratorPathsImpl.getNamespacesIndexPath must not be null");
        }
        String string = this.makeRelative(this.myPaths.getNamespacesIndexPath(module, order));
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/GeneratorPathsImpl.getNamespacesIndexPath must not return null");
        }
        return string;
    }

    @NotNull
    public String getClassesIndexPath(@NotNull ModuleInfo module, @Nullable String namespace, @NotNull SortOption order) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/GeneratorPathsImpl.getClassesIndexPath must not be null");
        }
        if (order == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/coverage/report/impl/html/GeneratorPathsImpl.getClassesIndexPath must not be null");
        }
        String string = this.makeRelative(this.myPaths.getClassesIndexPath(module, namespace, order));
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/GeneratorPathsImpl.getClassesIndexPath must not return null");
        }
        return string;
    }

    @NotNull
    public String getClassCoveragePath(@NotNull ModuleInfo module, @Nullable String namespace, @NotNull ClassInfo clazz) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/GeneratorPathsImpl.getClassCoveragePath must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/coverage/report/impl/html/GeneratorPathsImpl.getClassCoveragePath must not be null");
        }
        String string = this.makeRelative(this.myPaths.getClassCoveragePath(module, namespace, clazz));
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/GeneratorPathsImpl.getClassCoveragePath must not return null");
        }
        return string;
    }
}

