/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;

class EclipseOutputParser {
    private final String myBuilderName;
    private final ModuleChunk myChunk;
    private static final String PROB_SEPARATOR = "----------\n";

    public EclipseOutputParser(String builderName, ModuleChunk chunk) {
        this.myBuilderName = builderName;
        this.myChunk = chunk;
    }

    List<CompilerMessage> parseMessages(String input) throws IOException {
        String[] msgs;
        if (input.contains("The type groovy.lang.GroovyObject cannot be resolved. It is indirectly referenced from required .class files")) {
            return Collections.singletonList(new CompilerMessage(this.myBuilderName, BuildMessage.Kind.ERROR, "Cannot compile Groovy files: no Groovy library is defined for module '" + this.myChunk.representativeTarget().getModule().getName() + "'"));
        }
        ArrayList<CompilerMessage> parsedMessages = new ArrayList<CompilerMessage>();
        for (String msg : msgs = StringUtil.convertLineSeparators((String)input).split(PROB_SEPARATOR)) {
            if (msg.length() <= 1) continue;
            CompilerMessage message = this.parseMessage(msg);
            if (message != null) {
                parsedMessages.add(message);
                continue;
            }
            String[] extraMsgs = msg.split("\n");
            StringBuilder sb = new StringBuilder();
            for (String extraMsg : extraMsgs) {
                if (extraMsg.indexOf(". WARNING") > 0 || extraMsg.indexOf(". ERROR") > 0) {
                    this.handleCurrentMessage(parsedMessages, sb);
                    sb = new StringBuilder("\n").append(extraMsg).append("\n");
                    continue;
                }
                if (PROB_SEPARATOR.equals(extraMsg)) continue;
                sb.append(extraMsg).append("\n");
            }
            this.handleCurrentMessage(parsedMessages, sb);
        }
        return parsedMessages;
    }

    private void handleCurrentMessage(List<CompilerMessage> parsedMessages, StringBuilder sb) {
        if (sb.length() > 0) {
            ContainerUtil.addIfNotNull(parsedMessages, (Object)this.parseMessage(sb.toString()));
        }
    }

    @Nullable
    private CompilerMessage parseMessage(String msgText) {
        String rest;
        BuildMessage.Kind kind;
        int dotIndex = msgText.indexOf(46);
        boolean isNormal = false;
        if (dotIndex > 0) {
            if (msgText.substring(dotIndex, dotIndex + ". WARNING".length()).equals(". WARNING")) {
                kind = BuildMessage.Kind.WARNING;
                isNormal = true;
                dotIndex += ". WARNING in ".length();
            } else if (msgText.substring(dotIndex, dotIndex + ". ERROR".length()).equals(". ERROR")) {
                kind = BuildMessage.Kind.ERROR;
                isNormal = true;
                dotIndex += ". ERROR in ".length();
            } else {
                kind = BuildMessage.Kind.INFO;
            }
        } else {
            kind = BuildMessage.Kind.INFO;
        }
        int firstNewline = msgText.indexOf(10);
        String firstLine = firstNewline > 0 ? msgText.substring(0, firstNewline) : msgText;
        String string = rest = firstNewline > 0 ? msgText.substring(firstNewline + 1).trim() : "";
        if (isNormal) {
            try {
                int parenIndex = firstLine.indexOf(" (");
                String file = firstLine.substring(dotIndex, parenIndex);
                int line = Integer.parseInt(firstLine.substring(parenIndex + " (at line ".length(), firstLine.indexOf(41)));
                int lastLineIndex = rest.lastIndexOf("\n");
                return new CompilerMessage(this.myBuilderName, kind, rest.substring(lastLineIndex + 1), file, -1L, -1L, -1L, (long)line, -1L);
            }
            catch (RuntimeException ignore) {
                // empty catch block
            }
        }
        if (msgText.trim().matches("(\\d)+ problem(s)? \\((\\d)+ (error|warning)(s)?\\)")) {
            return null;
        }
        return new CompilerMessage(this.myBuilderName, kind, msgText);
    }
}

