/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.FileDescriptor;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.Native;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public abstract class AbstractEpollServerChannel
extends AbstractEpollChannel
implements ServerChannel {
    protected AbstractEpollServerChannel(int fd) {
        super(fd, Native.EPOLLIN);
    }

    protected AbstractEpollServerChannel(FileDescriptor fd) {
        super(null, fd, Native.EPOLLIN, Native.getSoError(fd.intValue()) == 0);
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof EpollEventLoop;
    }

    @Override
    protected InetSocketAddress remoteAddress0() {
        return null;
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollServerSocketUnsafe();
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object filterOutboundMessage(Object msg) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected abstract Channel newChildChannel(int var1) throws Exception;

    final class EpollServerSocketUnsafe
    extends AbstractEpollChannel.AbstractEpollUnsafe {
        EpollServerSocketUnsafe() {
        }

        @Override
        public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            channelPromise.setFailure(new UnsupportedOperationException());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void epollInReady() {
            assert (AbstractEpollServerChannel.this.eventLoop().inEventLoop());
            ChannelPipeline pipeline = AbstractEpollServerChannel.this.pipeline();
            Throwable exception = null;
            try {
                try {
                    int socketFd;
                    boolean edgeTriggered = AbstractEpollServerChannel.this.isFlagSet(Native.EPOLLET);
                    int maxMessagesPerRead = edgeTriggered ? Integer.MAX_VALUE : AbstractEpollServerChannel.this.config().getMaxMessagesPerRead();
                    int messages = 0;
                    while ((socketFd = Native.accept(AbstractEpollServerChannel.this.fd().intValue())) != -1) {
                        this.readPending = false;
                        try {
                            pipeline.fireChannelRead(AbstractEpollServerChannel.this.newChildChannel(socketFd));
                        }
                        catch (Throwable t) {
                            pipeline.fireChannelReadComplete();
                            pipeline.fireExceptionCaught(t);
                        }
                        finally {
                            if (edgeTriggered || AbstractEpollServerChannel.this.config().isAutoRead()) {
                            }
                            break;
                        }
                        if (++messages < maxMessagesPerRead) continue;
                        break;
                    }
                }
                catch (Throwable t) {
                    exception = t;
                }
                pipeline.fireChannelReadComplete();
                if (exception != null) {
                    pipeline.fireExceptionCaught(exception);
                }
            }
            finally {
                if (!AbstractEpollServerChannel.this.config().isAutoRead() && !this.readPending) {
                    this.clearEpollIn0();
                }
            }
        }
    }
}

