/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.application;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.ServerSocket;
import java.net.Socket;

public class AppMain {
    private static final String PROPERTY_PORT_NUMBER = "idea.launcher.port";
    private static final String PROPERTY_BINPATH = "idea.launcher.bin.path";
    private static final String JAVAFX_LAUNCHER = "com.sun.javafx.application.LauncherImpl";
    private static final String LAUNCH_APPLICATION_METHOD_NAME = "launchApplication";
    private static boolean ourHasSecurityProblem = false;

    private static native void triggerControlBreak();

    public static void main(String[] args) throws Throwable {
        Method m;
        if (!ourHasSecurityProblem) {
            final int portNumber = Integer.getInteger(PROPERTY_PORT_NUMBER);
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        ServerSocket socket = new ServerSocket(portNumber);
                        Socket client = socket.accept();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(client.getInputStream()));
                        while (true) {
                            String msg;
                            if ("TERM".equals(msg = reader.readLine())) {
                                return;
                            }
                            if ("BREAK".equals(msg)) {
                                AppMain.triggerControlBreak();
                                continue;
                            }
                            if (!"STOP".equals(msg)) continue;
                            System.exit(1);
                        }
                    }
                    catch (IOException ignored) {
                    }
                    catch (IllegalArgumentException ignored) {
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
            }, "Monitor Ctrl-Break");
            try {
                t.setDaemon(true);
                t.start();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        String mainClass = args[0];
        String[] parms = new String[args.length - 1];
        for (int j = 1; j < args.length; ++j) {
            parms[j - 1] = args[j];
        }
        Class<?> appClass = Class.forName(mainClass);
        try {
            m = appClass.getMethod("main", parms.getClass());
        }
        catch (NoSuchMethodException e) {
            if (!AppMain.startJavaFXApplication(parms, appClass)) {
                throw e;
            }
            return;
        }
        if (!Modifier.isStatic(m.getModifiers())) {
            System.err.println("main method should be static");
            return;
        }
        try {
            AppMain.ensureAccess(m);
            m.invoke(null, new Object[]{parms});
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private static boolean startJavaFXApplication(String[] parms, Class appClass) throws NoSuchMethodException {
        try {
            Method launchApplication = Class.forName(JAVAFX_LAUNCHER).getMethod(LAUNCH_APPLICATION_METHOD_NAME, appClass.getClass(), parms.getClass());
            launchApplication.invoke(null, appClass, parms);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static void ensureAccess(Object reflectionObject) {
        Class<?> aClass = reflectionObject.getClass();
        try {
            Method setAccessibleMethod = aClass.getMethod("setAccessible", Boolean.TYPE);
            setAccessibleMethod.invoke(reflectionObject, Boolean.TRUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            String binPath = System.getProperty(PROPERTY_BINPATH) + File.separator;
            String osName = System.getProperty("os.name").toLowerCase();
            String arch = System.getProperty("os.arch").toLowerCase();
            String libPath = null;
            if (osName.startsWith("windows")) {
                libPath = arch.equals("amd64") ? binPath + "breakgen64.dll" : binPath + "breakgen.dll";
            } else if (osName.startsWith("linux")) {
                libPath = arch.equals("amd64") ? binPath + "libbreakgen64.so" : binPath + "libbreakgen.so";
            } else if (osName.startsWith("mac")) {
                libPath = arch.endsWith("64") ? binPath + "libbreakgen64.jnilib" : binPath + "libbreakgen.jnilib";
            }
            if (libPath != null) {
                System.load(libPath);
            }
        }
        catch (UnsatisfiedLinkError e) {
        }
        catch (SecurityException e) {
            ourHasSecurityProblem = true;
            System.out.println("break in console is not supported due to security permissions: " + e.getMessage());
        }
    }
}

