/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidDependencyProcessor;
import org.jetbrains.jps.android.AndroidDependencyType;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.AndroidPreDexBuilder;
import org.jetbrains.jps.android.builder.AndroidAarDepsBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTargetType;
import org.jetbrains.jps.android.builder.AndroidClassesDirBuildRootDescriptor;
import org.jetbrains.jps.android.builder.AndroidFileBasedBuildRootDescriptor;
import org.jetbrains.jps.android.builder.AndroidPreDexBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidDexCompilerConfiguration;
import org.jetbrains.jps.android.model.JpsAndroidExtensionService;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidDexBuildTarget
extends AndroidBuildTarget {
    public AndroidDexBuildTarget(@NotNull JpsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget", "<init>"));
        }
        super(MyTargetType.INSTANCE, module);
    }

    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
        super.writeConfiguration(pd, out);
        JpsAndroidDexCompilerConfiguration c = JpsAndroidExtensionService.getInstance().getDexCompilerConfiguration(this.getModule().getProject());
        if (c != null) {
            out.println(c.getVmOptions());
            out.println(c.getMaxHeapSize());
            out.println(c.isOptimize());
            out.println(c.isForceJumbo());
            out.println(c.isCoreLibrary());
            out.println(c.getProguardVmOptions());
        }
    }

    @Override
    @NotNull
    protected List<BuildRootDescriptor> doComputeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        File testModuleClassesDir;
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        assert (extension != null);
        if (extension.isLibrary()) {
            List<BuildRootDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget", "doComputeRootDescriptors"));
            }
            return list;
        }
        THashMap libPackage2ModuleName = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
        THashSet appClassesDirs = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        THashSet javaClassesDirs = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        THashSet libClassesDirs = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        File moduleClassesDir = new ModuleBuildTarget(this.myModule, JavaModuleBuildTargetType.PRODUCTION).getOutputDir();
        if (moduleClassesDir != null) {
            appClassesDirs.add(moduleClassesDir.getPath());
        }
        AndroidJpsUtil.processClasspath(dataPaths, this.myModule, new AndroidDependencyProcessor((Map)libPackage2ModuleName, (Set)libClassesDirs, (Set)javaClassesDirs){
            final /* synthetic */ Map val$libPackage2ModuleName;
            final /* synthetic */ Set val$libClassesDirs;
            final /* synthetic */ Set val$javaClassesDirs;
            {
                this.val$libPackage2ModuleName = map;
                this.val$libClassesDirs = set;
                this.val$javaClassesDirs = set2;
            }

            @Override
            public void processAndroidLibraryPackage(@NotNull File file, @NotNull JpsModule depModule) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$1", "processAndroidLibraryPackage"));
                }
                if (depModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depModule", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$1", "processAndroidLibraryPackage"));
                }
                this.val$libPackage2ModuleName.put(file.getPath(), depModule.getName());
            }

            @Override
            public void processAndroidLibraryOutputDirectory(@NotNull File dir) {
                if (dir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$1", "processAndroidLibraryOutputDirectory"));
                }
                this.val$libClassesDirs.add(dir.getPath());
            }

            @Override
            public void processJavaModuleOutputDirectory(@NotNull File dir) {
                if (dir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$1", "processJavaModuleOutputDirectory"));
                }
                this.val$javaClassesDirs.add(dir.getPath());
            }

            @Override
            public boolean isToProcess(@NotNull AndroidDependencyType type) {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$1", "isToProcess"));
                }
                return type == AndroidDependencyType.ANDROID_LIBRARY_PACKAGE || type == AndroidDependencyType.ANDROID_LIBRARY_OUTPUT_DIRECTORY || type == AndroidDependencyType.JAVA_MODULE_OUTPUT_DIR;
            }
        }, false, false);
        if (extension.isPackTestCode() && (testModuleClassesDir = new ModuleBuildTarget(this.myModule, JavaModuleBuildTargetType.TEST).getOutputDir()) != null) {
            appClassesDirs.add(testModuleClassesDir.getPath());
        }
        ArrayList<BuildRootDescriptor> result = new ArrayList<BuildRootDescriptor>();
        for (String classesDir : appClassesDirs) {
            result.add((BuildRootDescriptor)new MyClassesDirBuildRootDescriptor(this, new File(classesDir), ClassesDirType.ANDROID_APP));
        }
        for (String classesDir : libClassesDirs) {
            result.add((BuildRootDescriptor)new MyClassesDirBuildRootDescriptor(this, new File(classesDir), ClassesDirType.ANDROID_LIB));
        }
        for (String classesDir : javaClassesDirs) {
            result.add((BuildRootDescriptor)new MyClassesDirBuildRootDescriptor(this, new File(classesDir), ClassesDirType.JAVA));
        }
        File preDexOutputDir = AndroidPreDexBuildTarget.getOutputDir(dataPaths);
        for (Map.Entry entry : libPackage2ModuleName.entrySet()) {
            String libPackage = (String)entry.getKey();
            String moduleName = (String)entry.getValue();
            File libPackageJarFile = new File(libPackage);
            assert (AndroidPreDexBuilder.canBePreDexed(libPackageJarFile));
            result.add((BuildRootDescriptor)new MyJarBuildRootDescriptor(this, libPackageJarFile, true, false));
            result.add((BuildRootDescriptor)new MyJarBuildRootDescriptor(this, new File(new File(preDexOutputDir, moduleName), libPackageJarFile.getName()), true, true));
        }
        AndroidPlatform platform = AndroidJpsUtil.getAndroidPlatform(this.myModule, null, null);
        if (platform != null) {
            for (String jarOrLibDir : AndroidJpsUtil.getExternalLibraries(dataPaths, this.myModule, platform, false, false, true)) {
                String preDexedFileName;
                File file;
                File preDexedFile = file = new File(jarOrLibDir);
                if (AndroidPreDexBuilder.canBePreDexed(file) && (preDexedFileName = AndroidPreDexBuilder.getOutputFileNameForExternalJar(file)) != null) {
                    preDexedFile = new File(preDexOutputDir, preDexedFileName);
                }
                result.add((BuildRootDescriptor)new MyJarBuildRootDescriptor(this, file, false, false));
                result.add((BuildRootDescriptor)new MyJarBuildRootDescriptor(this, preDexedFile, false, true));
            }
        }
        for (String path : AndroidJpsUtil.getProvidedLibraries(dataPaths, this.myModule)) {
            result.add((BuildRootDescriptor)new MyProvidedJarBuildRootDescriptor(this, new File(path)));
        }
        ArrayList<BuildRootDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget", "doComputeRootDescriptors"));
        }
        return arrayList;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        List<File> list = Collections.singletonList(this.getOutputFile(context));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget", "getOutputRoots"));
        }
        return list;
    }

    @NotNull
    public File getOutputFile(CompileContext context) {
        File file = AndroidDexBuildTarget.getOutputFile(context.getProjectDescriptor().dataManager.getDataPaths(), this.myModule);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget", "getOutputFile"));
        }
        return file;
    }

    @NotNull
    public static File getOutputFile(@NotNull BuildDataPaths dataPaths, @NotNull JpsModule module) {
        if (dataPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPaths", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget", "getOutputFile"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget", "getOutputFile"));
        }
        File dir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths, module);
        File file = new File(dir, "classes.dex");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget", "getOutputFile"));
        }
        return file;
    }

    @Override
    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry registry, TargetOutputIndex outputIndex) {
        ArrayList result = new ArrayList(super.computeDependencies(registry, outputIndex));
        result.add(new AndroidAarDepsBuildTarget(this.myModule));
        result.add(new AndroidPreDexBuildTarget(this.myModule.getProject()));
        return result;
    }

    public static class MyJarBuildRootDescriptor
    extends AndroidFileBasedBuildRootDescriptor {
        private final boolean myLibPackage;
        private final boolean myPreDexed;

        public MyJarBuildRootDescriptor(@NotNull BuildTarget target, @NotNull File file, boolean libPackage, boolean preDexed) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$MyJarBuildRootDescriptor", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$MyJarBuildRootDescriptor", "<init>"));
            }
            super(target, file);
            this.myLibPackage = libPackage;
            this.myPreDexed = preDexed;
        }

        public boolean isLibPackage() {
            return this.myLibPackage;
        }

        public boolean isPreDexed() {
            return this.myPreDexed;
        }
    }

    public static class MyProvidedJarBuildRootDescriptor
    extends AndroidFileBasedBuildRootDescriptor {
        public MyProvidedJarBuildRootDescriptor(@NotNull BuildTarget target, @NotNull File file) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$MyProvidedJarBuildRootDescriptor", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$MyProvidedJarBuildRootDescriptor", "<init>"));
            }
            super(target, file);
        }
    }

    public static class MyClassesDirBuildRootDescriptor
    extends AndroidClassesDirBuildRootDescriptor {
        private final ClassesDirType myClassesDirType;

        public MyClassesDirBuildRootDescriptor(@NotNull BuildTarget target, @NotNull File root, @NotNull ClassesDirType classesDirType) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$MyClassesDirBuildRootDescriptor", "<init>"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$MyClassesDirBuildRootDescriptor", "<init>"));
            }
            if (classesDirType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesDirType", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$MyClassesDirBuildRootDescriptor", "<init>"));
            }
            super(target, root);
            this.myClassesDirType = classesDirType;
        }

        @NotNull
        public ClassesDirType getClassesDirType() {
            ClassesDirType classesDirType = this.myClassesDirType;
            if (classesDirType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$MyClassesDirBuildRootDescriptor", "getClassesDirType"));
            }
            return classesDirType;
        }
    }

    public static enum ClassesDirType {
        ANDROID_APP,
        ANDROID_LIB,
        JAVA;

    }

    public static class MyTargetType
    extends AndroidBuildTargetType<AndroidDexBuildTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-dex", "DEX");
        }

        @Override
        public AndroidDexBuildTarget createBuildTarget(@NotNull JpsAndroidModuleExtension extension) {
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$MyTargetType", "createBuildTarget"));
            }
            return !extension.isLibrary() ? new AndroidDexBuildTarget(extension.getModule()) : null;
        }
    }
}

