/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.TObjectLongHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public class AndroidManifestMergerStateStorage
implements StorageOwner {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.android.AndroidPackagingStateStorage");
    public static final StorageProvider<AndroidManifestMergerStateStorage> PROVIDER = new StorageProvider<AndroidManifestMergerStateStorage>(){

        @NotNull
        public AndroidManifestMergerStateStorage createStorage(File targetDataDir) throws IOException {
            AndroidManifestMergerStateStorage androidManifestMergerStateStorage = new AndroidManifestMergerStateStorage(AndroidJpsUtil.getStorageFile(targetDataDir, "manifest_merger"));
            if (androidManifestMergerStateStorage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidManifestMergerStateStorage$1", "createStorage"));
            }
            return androidManifestMergerStateStorage;
        }
    };
    private final File myFile;

    private AndroidManifestMergerStateStorage(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/android/AndroidManifestMergerStateStorage", "<init>"));
        }
        this.myFile = file;
    }

    public void flush(boolean memoryCachesOnly) {
    }

    public void clean() throws IOException {
        FileUtil.delete((File)this.myFile);
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public MyState read() {
        block6: {
            MyState myState;
            DataInputStream input = new DataInputStream(new FileInputStream(this.myFile));
            try {
                myState = new MyState(input);
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                    throw throwable;
                }
                catch (FileNotFoundException ignored) {
                    break block6;
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            input.close();
            return myState;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(@NotNull MyState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jps/android/AndroidManifestMergerStateStorage", "saveState"));
        }
        FileUtil.createParentDirs((File)this.myFile);
        try {
            DataOutputStream output = new DataOutputStream(new FileOutputStream(this.myFile));
            try {
                output.writeLong(state.myManifestFileTimestamp);
                output.writeInt(state.myLibManifestsTimestamps.size());
                for (Object key : state.myLibManifestsTimestamps.keys()) {
                    String strKey = (String)key;
                    output.writeUTF(strKey);
                    output.writeLong(state.myLibManifestsTimestamps.get((Object)strKey));
                }
                output.writeBoolean(state.myToMerge);
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public static class MyState {
        private final long myManifestFileTimestamp;
        private final TObjectLongHashMap<String> myLibManifestsTimestamps;
        private final boolean myToMerge;

        public MyState(@NotNull File manifestFile, @NotNull Collection<File> libManifestFiles, boolean toMerge) {
            if (manifestFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestFile", "org/jetbrains/jps/android/AndroidManifestMergerStateStorage$MyState", "<init>"));
            }
            if (libManifestFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libManifestFiles", "org/jetbrains/jps/android/AndroidManifestMergerStateStorage$MyState", "<init>"));
            }
            this.myManifestFileTimestamp = manifestFile.lastModified();
            this.myLibManifestsTimestamps = new TObjectLongHashMap(libManifestFiles.size());
            for (File libManifestFile : libManifestFiles) {
                this.myLibManifestsTimestamps.put((Object)FileUtil.toCanonicalPath((String)libManifestFile.getPath()), libManifestFile.lastModified());
            }
            this.myToMerge = toMerge;
        }

        private MyState(DataInput input) throws IOException {
            this.myManifestFileTimestamp = input.readLong();
            int libManifestsCount = input.readInt();
            this.myLibManifestsTimestamps = new TObjectLongHashMap(libManifestsCount);
            for (int i = 0; i < libManifestsCount; ++i) {
                String path = input.readUTF();
                long timestamp = input.readLong();
                this.myLibManifestsTimestamps.put((Object)path, timestamp);
            }
            this.myToMerge = input.readBoolean();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyState state = (MyState)o;
            if (this.myManifestFileTimestamp != state.myManifestFileTimestamp) {
                return false;
            }
            if (this.myToMerge != state.myToMerge) {
                return false;
            }
            return this.myLibManifestsTimestamps.equals(state.myLibManifestsTimestamps);
        }

        public int hashCode() {
            int result = (int)(this.myManifestFileTimestamp ^ this.myManifestFileTimestamp >>> 32);
            result = 31 * result + this.myLibManifestsTimestamps.hashCode();
            result = 31 * result + (this.myToMerge ? 1 : 0);
            return result;
        }
    }
}

