/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.trello.TrelloIconBuilder;
import com.intellij.tasks.trello.model.TrelloCard;
import com.intellij.tasks.trello.model.TrelloCommentAction;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrelloTask
extends Task {
    private static final TrelloIconBuilder ourIconBuilder = new TrelloIconBuilder(16);
    private TrelloCard myCard;
    private TaskRepository myRepository;

    public TrelloTask(TrelloCard card, TaskRepository repository) {
        this.myCard = card;
        this.myRepository = repository;
    }

    @NotNull
    public String getId() {
        String string = this.myCard.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloTask", "getId"));
        }
        return string;
    }

    @NotNull
    public String getSummary() {
        String string = this.myCard.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloTask", "getSummary"));
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return this.myCard.getDescription();
    }

    @NotNull
    public Comment[] getComments() {
        List<TrelloCommentAction> comments = this.myCard.getComments();
        Comment[] commentArray = comments.toArray(new Comment[comments.size()]);
        if (commentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloTask", "getComments"));
        }
        return commentArray;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = ourIconBuilder.buildIcon(this.myCard.getColors());
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloTask", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public TaskType getType() {
        TaskType taskType = TaskType.OTHER;
        if (taskType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloTask", "getType"));
        }
        return taskType;
    }

    @Nullable
    public Date getUpdated() {
        return this.myCard.getDateLastActivity();
    }

    @Nullable
    public Date getCreated() {
        return null;
    }

    public boolean isClosed() {
        return this.myCard.isClosed() || !this.myCard.isVisible();
    }

    public boolean isIssue() {
        return true;
    }

    @Nullable
    public String getIssueUrl() {
        return this.myCard.getUrl();
    }

    public String getPresentableName() {
        return this.myCard.getName();
    }

    @Nullable
    public TaskRepository getRepository() {
        return this.myRepository;
    }
}

