/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract.closure;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.introduceParameter.ExternalUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.closure.ExtractClosureProcessorBase;
import org.jetbrains.plugins.groovy.refactoring.extract.closure.OtherLanguageUsageInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceClosureParameterProcessor;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GroovyIntroduceParameterUtil;

public class ExtractClosureFromClosureProcessor
extends ExtractClosureProcessorBase {
    public ExtractClosureFromClosureProcessor(@NotNull GrIntroduceParameterSettings helper) {
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureFromClosureProcessor", "<init>"));
        }
        super(helper);
    }

    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        if (!this.myHelper.generateDelegate()) {
            for (GrStatement statement : this.myHelper.getStatements()) {
                GroovyIntroduceParameterUtil.detectAccessibilityConflicts(statement, usagesIn, (MultiMap<PsiElement, String>)conflicts, this.myHelper.replaceFieldsWithGetters() != 0, this.myProject);
            }
        }
        return this.showConflicts(conflicts, usagesIn);
    }

    protected void performRefactoring(UsageInfo[] usages) {
        GrIntroduceClosureParameterProcessor.processExternalUsages(usages, this.myHelper, ExtractClosureFromClosureProcessor.generateClosure(this.myHelper));
        GrIntroduceClosureParameterProcessor.processClosure(usages, this.myHelper);
        GrStatementOwner declarationOwner = GroovyRefactoringUtil.getDeclarationOwner(this.myHelper.getStatements()[0]);
        ExtractUtil.replaceStatement(declarationOwner, this.myHelper);
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        GrVariable var = (GrVariable)this.myHelper.getToSearchFor();
        if (var != null) {
            ArrayList<OtherLanguageUsageInfo> result = new ArrayList<OtherLanguageUsageInfo>();
            for (PsiReference ref : ReferencesSearch.search((PsiElement)var)) {
                PsiElement element = ref.getElement();
                if (element.getLanguage() != GroovyLanguage.INSTANCE) {
                    result.add(new OtherLanguageUsageInfo(ref));
                    continue;
                }
                GrCall call = GroovyRefactoringUtil.getCallExpressionByMethodReference(element);
                if (call == null) continue;
                result.add((OtherLanguageUsageInfo)new ExternalUsageInfo(element));
            }
            UsageInfo[] usageInfoArray = result.toArray(new UsageInfo[result.size()]);
            if (usageInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureFromClosureProcessor", "findUsages"));
            }
            return usageInfoArray;
        }
        if (UsageInfo.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureFromClosureProcessor", "findUsages"));
        }
        return UsageInfo.EMPTY_ARRAY;
    }
}

