/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.codeInsight.JavaCodeInsightSettingsFacade;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrStaticChecker {
    public static boolean isStaticsOK(@NotNull PsiModifierListOwner member, @NotNull PsiElement place, @Nullable PsiElement resolveContext, boolean filterStaticAfterInstanceQualifier) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/groovy/lang/psi/util/GrStaticChecker", "isStaticsOK"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/util/GrStaticChecker", "isStaticsOK"));
        }
        if (!(member instanceof PsiMember)) {
            return true;
        }
        if (!(place instanceof GrReferenceExpression)) {
            return true;
        }
        if (member instanceof PsiClass && PsiTreeUtil.isAncestor((PsiElement)member, (PsiElement)place, (boolean)false)) {
            return true;
        }
        GrExpression qualifier = ((GrReferenceExpression)place).getQualifierExpression();
        PsiClass containingClass = GrStaticChecker.getContainingClass((PsiMember)member);
        if (qualifier != null) {
            return GrStaticChecker.checkQualified(member, place, filterStaticAfterInstanceQualifier, qualifier, containingClass);
        }
        return GrStaticChecker.checkNonQualified(member, place, resolveContext, containingClass);
    }

    private static boolean checkNonQualified(PsiModifierListOwner member, PsiElement place, PsiElement resolveContext, PsiClass containingClass) {
        if (containingClass == null) {
            return true;
        }
        if (member instanceof GrVariable && !(member instanceof GrField)) {
            return true;
        }
        if (member.hasModifierProperty("static")) {
            return true;
        }
        if ("java.lang.Object".equals(containingClass.getQualifiedName())) {
            return true;
        }
        if (resolveContext != null) {
            PsiElement stopAt = PsiTreeUtil.findCommonParent((PsiElement)place, (PsiElement)resolveContext);
            while (place != null && place != stopAt && !(place instanceof GrMember) && !(place instanceof PsiFile)) {
                if (place instanceof GrClosableBlock) {
                    return true;
                }
                place = place.getParent();
            }
            if (place == null || place instanceof PsiFile || place == stopAt) {
                return true;
            }
            if (place instanceof GrTypeDefinition) {
                return !((GrTypeDefinition)place).hasModifierProperty("static") && ((GrTypeDefinition)place).getContainingClass() != null;
            }
            return !((GrMember)place).hasModifierProperty("static");
        }
        while (place != null) {
            if ((place = place.getParent()) instanceof PsiClass && InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)place), (PsiClass)containingClass, (boolean)true)) {
                return true;
            }
            if (place instanceof GrClosableBlock) {
                return true;
            }
            if (!(place instanceof PsiMember) || !((PsiMember)place).hasModifierProperty("static")) continue;
            return false;
        }
        return true;
    }

    private static boolean checkQualified(@NotNull PsiModifierListOwner member, PsiElement place, boolean filterStaticAfterInstanceQualifier, GrExpression qualifier, PsiClass containingClass) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/groovy/lang/psi/util/GrStaticChecker", "checkQualified"));
        }
        boolean isStatic = member.hasModifierProperty("static");
        if (qualifier instanceof GrReferenceExpression) {
            PsiElement qualifierResolved;
            if ("class".equals(((GrReferenceExpression)qualifier).getReferenceName())) {
                PsiType[] params;
                PsiClass psiClass;
                PsiType type = qualifier.getType();
                if (type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null && "java.lang.Class".equals(psiClass.getQualifiedName()) && (params = ((PsiClassType)type).getParameters()).length == 1 && params[0] instanceof PsiClassType && place.getManager().areElementsEquivalent((PsiElement)containingClass, (PsiElement)((PsiClassType)params[0]).resolve())) {
                    return member.hasModifierProperty("static");
                }
            } else if (PsiUtil.isThisOrSuperRef(qualifier)) {
                boolean isInStatic = GrStaticChecker.isInStaticContext(qualifier);
                if (PsiUtil.isThisReference(qualifier) && isInStatic) {
                    return GrStaticChecker.checkJavaLangClassMember(place, containingClass, member) || member.hasModifierProperty("static");
                }
                return !isStatic || !filterStaticAfterInstanceQualifier || JavaCodeInsightSettingsFacade.getInstance((Project)member.getProject()).isShowStaticAfterInstance();
            }
            if ((qualifierResolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass || qualifierResolved instanceof PsiPackage) {
                if (member instanceof PsiClass) {
                    return true;
                }
                if (isStatic) {
                    return true;
                }
                return containingClass != null && GrStaticChecker.checkJavaLangClassMember(place, containingClass, member);
            }
        }
        if (member instanceof PsiClass) {
            return false;
        }
        return !isStatic || !filterStaticAfterInstanceQualifier || JavaCodeInsightSettingsFacade.getInstance((Project)member.getProject()).isShowStaticAfterInstance();
    }

    private static boolean checkJavaLangClassMember(PsiElement place, PsiClass containingClass, PsiModifierListOwner member) {
        if (containingClass == null) {
            return false;
        }
        String qname = containingClass.getQualifiedName();
        if (qname != null && qname.startsWith("java.")) {
            PsiClass javaLangClass;
            if ("java.lang.Object".equals(qname)) {
                return !(member instanceof PsiMethod) || !"toString".equals(((PsiMethod)member).getName());
            }
            if ("java.lang.Class".equals(qname)) {
                return true;
            }
            if (containingClass.isInterface() && (javaLangClass = JavaPsiFacade.getInstance((Project)place.getProject()).findClass("java.lang.Class", place.getResolveScope())) != null && javaLangClass.isInheritor(containingClass, true)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiClass getContainingClass(PsiMember member) {
        PsiType type;
        PsiMethod method;
        PsiParameter[] parameters;
        PsiClass aClass = member.getContainingClass();
        if (aClass != null) {
            return aClass;
        }
        if (member instanceof GrGdkMethod && !member.hasModifierProperty("static") && (parameters = (method = ((GrGdkMethod)member).getStaticMethod()).getParameterList().getParameters()).length > 0 && (type = parameters[0].getType()) instanceof PsiClassType) {
            return ((PsiClassType)type).resolve();
        }
        return null;
    }

    public static boolean isInStaticContext(@NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/util/GrStaticChecker", "isInStaticContext"));
        }
        PsiClass targetClass = null;
        if (place instanceof GrReferenceExpression) {
            Object qualifier = ((GrQualifiedReference)place).getQualifier();
            if (PsiUtil.isThisReference(place) && qualifier instanceof GrQualifiedReference) {
                targetClass = (PsiClass)((GrQualifiedReference)qualifier).resolve();
            }
        }
        return GrStaticChecker.isInStaticContext(place, targetClass);
    }

    public static boolean isInStaticContext(@NotNull PsiElement place, @Nullable PsiClass targetClass) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/util/GrStaticChecker", "isInStaticContext"));
        }
        if (place instanceof GrReferenceExpression) {
            GrQualifiedReference reference = (GrQualifiedReference)place;
            Object qualifier = reference.getQualifier();
            if (qualifier != null && !PsiUtil.isThisOrSuperRef((PsiElement)reference)) {
                if (PsiUtil.isInstanceThisRef(qualifier) || PsiUtil.isSuperReference(qualifier)) {
                    return false;
                }
                if (PsiUtil.isThisReference(qualifier)) {
                    return true;
                }
                return qualifier instanceof GrQualifiedReference && ((GrQualifiedReference)qualifier).resolve() instanceof PsiClass;
            }
            if (PsiUtil.isSuperReference((PsiElement)reference)) {
                return false;
            }
        }
        for (PsiElement run = place; run != null && run != targetClass; run = run.getParent()) {
            if (targetClass == null && run instanceof PsiClass) {
                return false;
            }
            if (run instanceof GrClosableBlock) {
                return false;
            }
            if (!(run instanceof PsiModifierListOwner) || !((PsiModifierListOwner)run).hasModifierProperty("static")) continue;
            return true;
        }
        return false;
    }

    public static boolean isPropertyAccessInStaticMethod(@NotNull GrReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/plugins/groovy/lang/psi/util/GrStaticChecker", "isPropertyAccessInStaticMethod"));
        }
        return GrStaticChecker.isInStaticContext(referenceExpression) && !(referenceExpression.getParent() instanceof GrMethodCall) && referenceExpression.getQualifier() == null;
    }
}

