/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

public class GrTraitType
extends PsiClassType {
    private static final Logger LOG = Logger.getInstance(GrTraitType.class);
    private final GrExpression myOriginal;
    private final PsiClassType myExprType;
    private final List<PsiClassType> myTraitTypes;
    private final GlobalSearchScope myResolveScope;
    private final VolatileNotNullLazyValue<PsiType[]> myParameters;

    public GrTraitType(@NotNull GrExpression original, @NotNull PsiClassType exprType, @NotNull List<PsiClassType> traitTypes, @NotNull GlobalSearchScope resolveScope, LanguageLevel languageLevel) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "<init>"));
        }
        if (exprType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exprType", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "<init>"));
        }
        if (traitTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traitTypes", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "<init>"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "<init>"));
        }
        super(languageLevel);
        this.myParameters = new VolatileNotNullLazyValue<PsiType[]>(){

            @NotNull
            protected PsiType[] compute() {
                ArrayList result = ContainerUtil.newArrayList();
                ContainerUtil.addAll((Collection)result, (Object[])GrTraitType.this.myExprType.getParameters());
                for (PsiClassType type : GrTraitType.this.myTraitTypes) {
                    ContainerUtil.addAll((Collection)result, (Object[])type.getParameters());
                }
                PsiType[] psiTypeArray = result.toArray(new PsiType[result.size()]);
                if (psiTypeArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType$1", "compute"));
                }
                return psiTypeArray;
            }
        };
        this.myOriginal = original;
        this.myResolveScope = resolveScope;
        this.myExprType = exprType;
        this.myTraitTypes = ContainerUtil.newArrayList(traitTypes);
    }

    @NotNull
    public String getPresentableText() {
        String string = this.myExprType.getPresentableText() + " as " + StringUtil.join((Collection)ContainerUtil.map(this.myTraitTypes, (Function)new Function<PsiClassType, String>(){

            public String fun(PsiClassType type) {
                return type.getPresentableText();
            }
        }), (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "getPresentableText"));
        }
        return string;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myExprType.getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "getCanonicalText"));
        }
        return string;
    }

    @NotNull
    public String getInternalCanonicalText() {
        String string = this.myExprType.getCanonicalText() + " as " + StringUtil.join((Collection)ContainerUtil.map(this.myTraitTypes, (Function)new Function<PsiClassType, String>(){

            public String fun(PsiClassType type) {
                return type.getCanonicalText();
            }
        }), (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "getInternalCanonicalText"));
        }
        return string;
    }

    public boolean isValid() {
        return this.myExprType.isValid() && ContainerUtil.find(this.myTraitTypes, (Condition)new Condition<PsiClassType>(){

            public boolean value(PsiClassType type) {
                return !type.isValid();
            }
        }) == null;
    }

    public boolean equalsToText(@NotNull @NonNls String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "equalsToText"));
        }
        return false;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "setLanguageLevel"));
        }
        GrTraitType grTraitType = new GrTraitType(this.myOriginal, this.myExprType, this.myTraitTypes, this.myResolveScope, languageLevel);
        if (grTraitType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "setLanguageLevel"));
        }
        return grTraitType;
    }

    @Nullable
    public PsiClass resolve() {
        return this.getMockTypeDefinition();
    }

    public String getClassName() {
        return null;
    }

    @NotNull
    public PsiType[] getParameters() {
        PsiType[] psiTypeArray = (PsiType[])this.myParameters.getValue();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "getParameters"));
        }
        return psiTypeArray;
    }

    @NotNull
    public PsiType[] getSuperTypes() {
        Object[] result = new PsiType[this.myTraitTypes.size() + 1];
        result[0] = this.myExprType;
        ArrayUtil.copy(this.myTraitTypes, (Object[])result, (int)1);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "getSuperTypes"));
        }
        return result;
    }

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiClassType.ClassResolveResult classResolveResult = (PsiClassType.ClassResolveResult)CachedValuesManager.getCachedValue((PsiElement)this.myOriginal, (CachedValueProvider)new CachedValueProvider<PsiClassType.ClassResolveResult>(){

            @Nullable
            public CachedValueProvider.Result<PsiClassType.ClassResolveResult> compute() {
                GrTypeDefinition definition = new MockTypeBuilder().buildMockTypeDefinition();
                PsiSubstitutor substitutor = new SubstitutorBuilder(definition).buildSubstitutor();
                return CachedValueProvider.Result.create((Object)new TraitResolveResult(definition, substitutor), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
        if (classResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "resolveGenerics"));
        }
        return classResolveResult;
    }

    @NotNull
    public PsiClassType rawType() {
        GrTraitType grTraitType = new GrTraitType(this.myOriginal, this.myExprType.rawType(), ContainerUtil.map(this.myTraitTypes, (Function)new Function<PsiClassType, PsiClassType>(){

            public PsiClassType fun(PsiClassType type) {
                return type.rawType();
            }
        }), this.myResolveScope, this.myLanguageLevel);
        if (grTraitType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "rawType"));
        }
        return grTraitType;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myResolveScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Nullable
    public GrTypeDefinition getMockTypeDefinition() {
        return (GrTypeDefinition)CachedValuesManager.getCachedValue((PsiElement)this.myOriginal, (CachedValueProvider)new CachedValueProvider<GrTypeDefinition>(){

            @Nullable
            public CachedValueProvider.Result<GrTypeDefinition> compute() {
                return CachedValueProvider.Result.create((Object)new MockTypeBuilder().buildMockTypeDefinition(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
    }

    public PsiClassType getExprType() {
        return this.myExprType;
    }

    public List<PsiClassType> getTraitTypes() {
        return Collections.unmodifiableList(this.myTraitTypes);
    }

    public GrTraitType erasure() {
        PsiClassType exprType = (PsiClassType)TypeConversionUtil.erasure((PsiType)this.myExprType);
        List traitTypes = ContainerUtil.map(this.myTraitTypes, (Function)new Function<PsiClassType, PsiClassType>(){

            public PsiClassType fun(PsiClassType type) {
                return (PsiClassType)TypeConversionUtil.erasure((PsiType)type);
            }
        });
        return new GrTraitType(this.myOriginal, exprType, traitTypes, this.myResolveScope, LanguageLevel.JDK_1_5);
    }

    @Nullable
    public static GrTraitType createTraitClassType(@NotNull GrSafeCastExpression safeCastExpression) {
        if (safeCastExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "safeCastExpression", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "createTraitClassType"));
        }
        GrExpression operand = safeCastExpression.getOperand();
        PsiType exprType = operand.getType();
        if (!(exprType instanceof PsiClassType)) {
            return null;
        }
        GrTypeElement typeElement = safeCastExpression.getCastTypeElement();
        if (typeElement == null) {
            return null;
        }
        PsiType type = typeElement.getType();
        if (!GrTraitUtil.isTrait(PsiTypesUtil.getPsiClass((PsiType)type))) {
            return null;
        }
        return new GrTraitType(safeCastExpression, (PsiClassType)exprType, Collections.singletonList((PsiClassType)type), safeCastExpression.getResolveScope(), LanguageLevel.JDK_1_5);
    }

    @NotNull
    public static GrTraitType createTraitClassType(@NotNull GrExpression context, @NotNull PsiClassType exprType, @NotNull List<PsiClassType> traitTypes, @NotNull GlobalSearchScope resolveScope) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "createTraitClassType"));
        }
        if (exprType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exprType", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "createTraitClassType"));
        }
        if (traitTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traitTypes", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "createTraitClassType"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "createTraitClassType"));
        }
        GrTraitType grTraitType = new GrTraitType(context, exprType, traitTypes, resolveScope, LanguageLevel.JDK_1_5);
        if (grTraitType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "createTraitClassType"));
        }
        return grTraitType;
    }

    private class SubstitutorBuilder {
        private final GrTypeParameter[] myParameters;
        private int myOffset;

        public SubstitutorBuilder(GrTypeDefinition definition) {
            if (definition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType$SubstitutorBuilder", "<init>"));
            }
            this.myOffset = 0;
            GrTypeParameterList typeParameterList = definition.getTypeParameterList();
            this.myParameters = typeParameterList != null ? typeParameterList.getTypeParameters() : GrTypeParameter.EMPTY_ARRAY;
        }

        @NotNull
        public PsiSubstitutor buildSubstitutor() {
            if (this.myParameters.length == 0) {
                PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
                if (psiSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType$SubstitutorBuilder", "buildSubstitutor"));
                }
                return psiSubstitutor;
            }
            LinkedHashMap map = ContainerUtil.newLinkedHashMap();
            this.putMappingAndReturnOffset(map, GrTraitType.this.myExprType);
            for (PsiClassType type : GrTraitType.this.myTraitTypes) {
                this.putMappingAndReturnOffset(map, type);
            }
            PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory((Project)GrTraitType.this.myOriginal.getProject()).createSubstitutor((Map)map);
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType$SubstitutorBuilder", "buildSubstitutor"));
            }
            return psiSubstitutor;
        }

        private void putMappingAndReturnOffset(@NotNull Map<PsiTypeParameter, PsiType> map, @NotNull PsiClassType type) {
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType$SubstitutorBuilder", "putMappingAndReturnOffset"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType$SubstitutorBuilder", "putMappingAndReturnOffset"));
            }
            PsiType[] args = type.getParameters();
            for (int i = 0; i < args.length; ++i) {
                map.put(this.myParameters[this.myOffset + i], args[i]);
            }
            this.myOffset += args.length;
        }
    }

    private class MockTypeBuilder {
        GroovyPsiElementFactory factory;

        private MockTypeBuilder() {
            this.factory = GroovyPsiElementFactory.getInstance(GrTraitType.this.myOriginal.getProject());
        }

        @Nullable
        public GrTypeDefinition buildMockTypeDefinition() {
            try {
                StringBuilder buffer = new StringBuilder("class _____________Temp___________ ");
                this.prepareGenerics(buffer);
                buffer.append(" extends Super implements Trait {}");
                GrTypeDefinition definition = this.factory.createTypeDefinition(buffer.toString());
                this.replaceReferenceWith(definition.getExtendsClause(), GrTraitType.this.myExprType);
                this.addReferencesWith(definition.getImplementsClause(), GrTraitType.this.myTraitTypes, GrTraitType.this.myExprType.getParameterCount());
                return definition;
            }
            catch (IncorrectOperationException e) {
                return null;
            }
        }

        private void prepareGenerics(StringBuilder buffer) {
            int count = GrTraitType.this.myExprType.getParameterCount();
            for (PsiClassType trait : GrTraitType.this.myTraitTypes) {
                count += trait.getParameterCount();
            }
            if (count == 0) {
                return;
            }
            buffer.append('<');
            for (int i = 0; i < count; ++i) {
                buffer.append("T").append(i).append(",");
            }
            buffer.replace(buffer.length() - 1, buffer.length(), ">");
        }

        private void addReferencesWith(@Nullable GrImplementsClause clause, @NotNull List<PsiClassType> traitTypes, int parameterOffset) {
            if (traitTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traitTypes", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType$MockTypeBuilder", "addReferencesWith"));
            }
            LOG.assertTrue(clause != null);
            clause.getReferenceElementsGroovy()[0].delete();
            for (PsiClassType type : traitTypes) {
                this.processType(clause, type, parameterOffset);
                parameterOffset += type.getParameterCount();
            }
        }

        private void replaceReferenceWith(@Nullable GrReferenceList clause, @NotNull PsiClassType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType$MockTypeBuilder", "replaceReferenceWith"));
            }
            LOG.assertTrue(clause != null);
            clause.getReferenceElementsGroovy()[0].delete();
            this.processType(clause, type, 0);
        }

        private void processType(@NotNull GrReferenceList clause, @NotNull PsiClassType type, int parameterOffset) {
            if (clause == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clause", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType$MockTypeBuilder", "processType"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType$MockTypeBuilder", "processType"));
            }
            PsiClass resolved = type.resolve();
            if (resolved != null) {
                String qname = resolved.getQualifiedName();
                StringBuilder buffer = new StringBuilder();
                buffer.append(qname);
                int parameterCount = type.getParameterCount();
                if (parameterCount > 0) {
                    buffer.append('<');
                    for (int i = 0; i < parameterCount; ++i) {
                        buffer.append("T").append(parameterOffset + i).append(',');
                    }
                    buffer.replace(buffer.length() - 1, buffer.length(), ">");
                }
                GrCodeReferenceElement ref = this.factory.createCodeReferenceElementFromText(buffer.toString());
                clause.add(ref);
            }
        }
    }

    private static class TraitResolveResult
    implements PsiClassType.ClassResolveResult {
        private final GrTypeDefinition myDefinition;
        private final PsiSubstitutor mySubstitutor;

        public TraitResolveResult(GrTypeDefinition definition, PsiSubstitutor substitutor) {
            this.myDefinition = definition;
            this.mySubstitutor = substitutor;
        }

        public GrTypeDefinition getElement() {
            return this.myDefinition;
        }

        @NotNull
        public PsiSubstitutor getSubstitutor() {
            PsiSubstitutor psiSubstitutor = this.mySubstitutor;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType$TraitResolveResult", "getSubstitutor"));
            }
            return psiSubstitutor;
        }

        public boolean isPackagePrefixPackageReference() {
            return false;
        }

        public boolean isAccessible() {
            return true;
        }

        public boolean isStaticsScopeCorrect() {
            return true;
        }

        public PsiElement getCurrentFileResolveScope() {
            return null;
        }

        public boolean isValidResult() {
            return true;
        }
    }
}

