/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.completion.CompleteReferenceExpression;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.completion.GroovyMembersGetter;
import org.jetbrains.plugins.groovy.lang.completion.handlers.AfterNewClassInsertHandler;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;

public class GroovySmartCompletionContributor
extends CompletionContributor {
    private static final ElementPattern<PsiElement> INSIDE_EXPRESSION = PlatformPatterns.psiElement().withParent(GrExpression.class);
    private static final ElementPattern<PsiElement> IN_CAST_PARENTHESES = PlatformPatterns.psiElement().withSuperParent(3, (ElementPattern)PlatformPatterns.psiElement(GrTypeCastExpression.class).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(GrAssignmentExpression.class), PlatformPatterns.psiElement(GrVariable.class)})));
    static final ElementPattern<PsiElement> AFTER_NEW = PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)GroovyTokenTypes.kNEW));
    private static final ElementPattern<PsiElement> IN_ANNOTATION = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(GrReferenceExpression.class).withParent(GrAnnotationNameValuePair.class));
    private static final TObjectHashingStrategy<TypeConstraint> EXPECTED_TYPE_INFO_STRATEGY = new TObjectHashingStrategy<TypeConstraint>(){

        public int computeHashCode(TypeConstraint object) {
            return object.getType().hashCode();
        }

        public boolean equals(TypeConstraint o1, TypeConstraint o2) {
            return o1.getClass().equals(o2.getClass()) && o1.getType().equals(o2.getType());
        }
    };

    public GroovySmartCompletionContributor() {
        this.extend(CompletionType.SMART, INSIDE_EXPRESSION, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters params, ProcessingContext context, final @NotNull CompletionResultSet result) {
                if (params == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor$2", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor$2", "addCompletions"));
                }
                final PsiElement position = params.getPosition();
                if (position.getParent() instanceof GrLiteral) {
                    return;
                }
                if (GroovySmartCompletionContributor.isInDefaultAnnotationNameValuePair(position)) {
                    return;
                }
                final Set infos = GroovySmartCompletionContributor.getExpectedTypeInfos(params);
                PsiElement reference = position.getParent();
                if (reference == null) {
                    return;
                }
                if (reference instanceof GrReferenceElement) {
                    GroovyCompletionUtil.processVariants((GrReferenceElement)reference, result.getPrefixMatcher(), params, new Consumer<LookupElement>(){

                        public void consume(LookupElement variant) {
                            PsiType type = null;
                            Object o = variant.getObject();
                            if (o instanceof GroovyResolveResult) {
                                if (!((GroovyResolveResult)o).isAccessible()) {
                                    return;
                                }
                                o = ((GroovyResolveResult)o).getElement();
                            }
                            if (o instanceof PsiElement) {
                                type = GroovySmartCompletionContributor.getTypeByElement((PsiElement)o, position);
                            } else if (o instanceof String && ("true".equals(o) || "false".equals(o))) {
                                type = PsiType.BOOLEAN;
                            }
                            if (type == null) {
                                return;
                            }
                            for (TypeConstraint info : infos) {
                                if (!info.satisfied(type, position)) continue;
                                result.addElement(variant);
                                break;
                            }
                        }
                    });
                }
                GroovySmartCompletionContributor.addExpectedClassMembers(params, result);
            }
        });
        this.extend(CompletionType.SMART, IN_CAST_PARENTHESES, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor$3", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor$3", "addCompletions"));
                }
                PsiElement position = parameters.getPosition();
                GrTypeCastExpression parenthesizedExpression = (GrTypeCastExpression)position.getParent().getParent().getParent();
                PsiElement assignment = parenthesizedExpression.getParent();
                if (assignment instanceof GrAssignmentExpression && ((GrAssignmentExpression)assignment).getLValue() == parenthesizedExpression) {
                    return;
                }
                final boolean overwrite = ((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("(")).withParent(GrTypeCastExpression.class))).accepts((Object)parameters.getOriginalPosition());
                Set typeConstraints = GroovySmartCompletionContributor.getExpectedTypeInfos(parameters);
                for (TypeConstraint typeConstraint : typeConstraints) {
                    PsiType type = typeConstraint.getType();
                    PsiTypeLookupItem item = PsiTypeLookupItem.createLookupItem((PsiType)type, (PsiElement)position, (boolean)PsiTypeLookupItem.isDiamond((PsiType)type), ChooseTypeExpression.IMPORT_FIXER);
                    if (item.getObject() instanceof PsiClass) {
                        JavaCompletionUtil.setShowFQN((LookupItem)item);
                    }
                    item.setInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                        public void handleInsert(InsertionContext context, LookupElement item) {
                            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.smarttype.casting");
                            Editor editor = context.getEditor();
                            Document document = editor.getDocument();
                            if (overwrite) {
                                document.deleteString(context.getSelectionEndOffset(), context.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET));
                            }
                            CodeStyleSettings csSettings = CodeStyleSettingsManager.getSettings((Project)context.getProject());
                            int oldTail = context.getTailOffset();
                            context.setTailOffset(GroovyCompletionUtil.addRParenth(editor, oldTail, csSettings.SPACE_WITHIN_CAST_PARENTHESES));
                            if (csSettings.SPACE_AFTER_TYPE_CAST) {
                                context.setTailOffset(TailType.insertChar((Editor)editor, (int)context.getTailOffset(), (char)' '));
                            }
                            editor.getCaretModel().moveToOffset(context.getTailOffset());
                            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                            GroovyCompletionUtil.addImportForItem(context.getFile(), context.getStartOffset(), (LookupItem)item);
                        }
                    });
                    result.addElement((LookupElement)item);
                }
            }
        });
        this.extend(CompletionType.SMART, AFTER_NEW, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext matchingContext, final @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor$4", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor$4", "addCompletions"));
                }
                GroovySmartCompletionContributor.generateInheritorVariants(parameters, result.getPrefixMatcher(), new Consumer<LookupElement>(){

                    public void consume(LookupElement lookupElement) {
                        result.addElement(lookupElement);
                    }
                });
            }
        });
        this.extend(CompletionType.SMART, IN_ANNOTATION, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters params, ProcessingContext context, final @NotNull CompletionResultSet result) {
                if (params == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor$5", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor$5", "addCompletions"));
                }
                PsiElement position = params.getPosition();
                if (!GroovySmartCompletionContributor.isInDefaultAnnotationNameValuePair(position)) {
                    return;
                }
                GrReferenceExpression reference = (GrReferenceExpression)position.getParent();
                if (reference == null) {
                    return;
                }
                CompleteReferenceExpression.processRefInAnnotation(reference, result.getPrefixMatcher(), new Consumer<LookupElement>(){

                    public void consume(@Nullable LookupElement element) {
                        if (element != null) {
                            result.addElement(element);
                        }
                    }
                }, params);
            }
        });
    }

    private static boolean isInDefaultAnnotationNameValuePair(PsiElement position) {
        PsiElement resolved;
        PsiElement ppparent;
        PsiElement identifier;
        PsiElement pparent;
        PsiElement parent = position.getParent();
        if (parent instanceof GrReferenceExpression && (pparent = parent.getParent()) instanceof GrAnnotationNameValuePair && (identifier = ((GrAnnotationNameValuePair)pparent).getNameIdentifierGroovy()) == null && (ppparent = pparent.getParent().getParent()) instanceof GrAnnotation && (resolved = ((GrAnnotation)ppparent).getClassReference().resolve()) instanceof PsiClass && ((PsiClass)resolved).isAnnotationType()) {
            PsiMethod[] values = ((PsiClass)resolved).findMethodsByName("value", false);
            return values.length == 0;
        }
        return false;
    }

    static void addExpectedClassMembers(CompletionParameters params, final CompletionResultSet result) {
        for (TypeConstraint info : GroovySmartCompletionContributor.getExpectedTypeInfos(params)) {
            boolean searchInheritors;
            Consumer<LookupElement> consumer = new Consumer<LookupElement>(){

                public void consume(LookupElement element) {
                    result.addElement(element);
                }
            };
            PsiType type = info.getType();
            PsiType defType = info.getDefaultType();
            boolean bl = searchInheritors = params.getInvocationCount() > 1;
            if (type instanceof PsiClassType) {
                new GroovyMembersGetter((PsiClassType)type, params).processMembers(searchInheritors, consumer);
            }
            if (defType.equals(type) || !(defType instanceof PsiClassType)) continue;
            new GroovyMembersGetter((PsiClassType)defType, params).processMembers(searchInheritors, consumer);
        }
    }

    static void generateInheritorVariants(final CompletionParameters parameters, PrefixMatcher matcher, final Consumer<LookupElement> consumer) {
        final PsiElement place = parameters.getPosition();
        GrExpression expression = (GrExpression)PsiTreeUtil.getParentOfType((PsiElement)place, GrExpression.class);
        if (expression == null) {
            return;
        }
        GrExpression placeToInferType = expression;
        if (expression.getParent() instanceof GrApplicationStatement && expression.getParent().getParent() instanceof GrAssignmentExpression) {
            placeToInferType = (GrExpression)expression.getParent();
        }
        for (PsiType type : GroovyExpectedTypesProvider.getDefaultExpectedTypes(placeToInferType)) {
            if (!(type instanceof PsiArrayType)) continue;
            PsiType _type = GenericsUtil.eliminateWildcards((PsiType)type);
            PsiTypeLookupItem item = PsiTypeLookupItem.createLookupItem((PsiType)_type, (PsiElement)place, (boolean)PsiTypeLookupItem.isDiamond((PsiType)_type), ChooseTypeExpression.IMPORT_FIXER);
            if (item.getObject() instanceof PsiClass) {
                JavaCompletionUtil.setShowFQN((LookupItem)item);
                item.setInsertHandler((InsertHandler)new InsertHandler<LookupItem>(){

                    public void handleInsert(InsertionContext context, LookupItem item) {
                        GroovyCompletionUtil.addImportForItem(context.getFile(), context.getStartOffset(), item);
                    }
                });
            }
            consumer.consume((Object)item);
        }
        SmartList expectedClassTypes = new SmartList();
        for (PsiType psiType : GroovyExpectedTypesProvider.getDefaultExpectedTypes(placeToInferType)) {
            PsiType type;
            PsiClassType classType;
            if (!(psiType instanceof PsiClassType) || (classType = (PsiClassType)(type = GenericsUtil.eliminateWildcards((PsiType)JavaCompletionUtil.originalize((PsiType)psiType)))).resolve() == null) continue;
            expectedClassTypes.add(classType);
        }
        final PsiType diamond = GroovySmartCompletionContributor.inferDiamond(place);
        JavaInheritorsGetter.processInheritors((CompletionParameters)parameters, (Collection)expectedClassTypes, (PrefixMatcher)matcher, (Consumer)new Consumer<PsiType>(){

            public void consume(PsiType type) {
                LookupElement element = GroovySmartCompletionContributor.addExpectedType(type, place, parameters, diamond);
                if (element != null) {
                    consumer.consume((Object)element);
                }
            }
        });
    }

    @Nullable
    private static PsiType inferDiamond(PsiElement place) {
        PsiElement ppparent;
        if (!GroovyConfigUtils.getInstance().isVersionAtLeast(place, "1.8")) {
            return null;
        }
        PsiElement parent = place.getParent().getParent();
        if (!(parent instanceof GrNewExpression)) {
            return null;
        }
        PsiElement pparent = parent.getParent();
        if (pparent instanceof GrVariable) {
            return ((GrVariable)pparent).getDeclaredType();
        }
        if (pparent instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignment = (GrAssignmentExpression)pparent;
            IElementType optoken = assignment.getOperationTokenType();
            GrExpression lvalue = assignment.getLValue();
            GrExpression rvalue = assignment.getRValue();
            if (parent == rvalue && optoken == GroovyTokenTypes.mASSIGN) {
                return lvalue.getNominalType();
            }
        } else if (pparent instanceof GrApplicationStatement && (ppparent = pparent.getParent()) instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignment = (GrAssignmentExpression)ppparent;
            IElementType optoken = assignment.getOperationTokenType();
            GrExpression lvalue = assignment.getLValue();
            GrExpression rvalue = assignment.getRValue();
            if (pparent == rvalue && optoken == GroovyTokenTypes.mASSIGN) {
                return lvalue.getNominalType();
            }
        }
        return null;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor", "fillCompletionVariants"));
        }
        super.fillCompletionVariants(parameters, result);
    }

    @Nullable
    private static LookupElement addExpectedType(PsiType type, PsiElement place, CompletionParameters parameters, @Nullable PsiType diamond) {
        PsiTypeLookupItem item;
        Object object;
        if (!JavaCompletionUtil.hasAccessibleConstructor((PsiType)type)) {
            return null;
        }
        PsiClass psiClass = com.intellij.psi.util.PsiUtil.resolveClassInType((PsiType)type);
        if (psiClass == null) {
            return null;
        }
        if (!GroovySmartCompletionContributor.checkForInnerClass(psiClass, place)) {
            return null;
        }
        boolean isDiamond = false;
        if (diamond != null && psiClass.hasTypeParameters() && !((PsiClassType)type).isRaw() && !psiClass.hasModifierProperty("abstract")) {
            String canonicalText = TypeConversionUtil.erasure((PsiType)type).getCanonicalText();
            GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(place.getProject());
            String text = diamond.getCanonicalText() + " v = new " + canonicalText + "<>()";
            GrStatement statement = elementFactory.createStatementFromText(text, (PsiElement)parameters.getOriginalFile());
            GrVariable declaredVar = ((GrVariableDeclaration)statement).getVariables()[0];
            GrNewExpression initializer = (GrNewExpression)declaredVar.getInitializerGroovy();
            assert (initializer != null);
            boolean hasDefaultConstructorOrNoGenericsOne = PsiDiamondTypeImpl.hasDefaultConstructor((PsiClass)psiClass) || !PsiDiamondTypeImpl.haveConstructorsGenericsParameters((PsiClass)psiClass);
            PsiType initializerType = initializer.getType();
            if (hasDefaultConstructorOrNoGenericsOne && initializerType != null && initializerType instanceof PsiClassType && ((PsiClassType)initializerType).getParameters().length > 0) {
                type = initializerType;
                isDiamond = true;
            }
        }
        if ((object = (item = PsiTypeLookupItem.createLookupItem((PsiType)GenericsUtil.eliminateWildcards((PsiType)type), (PsiElement)place, (boolean)isDiamond, ChooseTypeExpression.IMPORT_FIXER)).getObject()) instanceof PsiClass) {
            JavaCompletionUtil.setShowFQN((LookupItem)item);
            if (((PsiClass)object).hasModifierProperty("abstract")) {
                item.setIndicateAnonymous(true);
            }
        }
        item.setInsertHandler((InsertHandler)new AfterNewClassInsertHandler((PsiClassType)type, true));
        return item;
    }

    private static boolean checkForInnerClass(PsiClass psiClass, PsiElement identifierCopy) {
        return !com.intellij.psi.util.PsiUtil.isInnerClass((PsiClass)psiClass) || PsiUtil.hasEnclosingInstanceInScope(psiClass.getContainingClass(), identifierCopy, true);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor", "beforeCompletion"));
        }
        if (context.getCompletionType() != CompletionType.SMART) {
            return;
        }
        PsiElement lastElement = context.getFile().findElementAt(context.getStartOffset() - 1);
        if (lastElement != null && lastElement.getText().equals("(")) {
            PsiElement parent = lastElement.getParent();
            if (parent instanceof GrTypeCastExpression) {
                context.setDummyIdentifier("");
            } else if (parent instanceof GrParenthesizedExpression) {
                context.setDummyIdentifier("xxx)yyy ");
            }
        }
    }

    private static Set<TypeConstraint> getExpectedTypeInfos(CompletionParameters params) {
        return new THashSet(Arrays.asList(GroovySmartCompletionContributor.getExpectedTypes(params)), EXPECTED_TYPE_INFO_STRATEGY);
    }

    @NotNull
    public static TypeConstraint[] getExpectedTypes(CompletionParameters params) {
        PsiElement position = params.getPosition();
        GrExpression expression = (GrExpression)PsiTreeUtil.getParentOfType((PsiElement)position, GrExpression.class);
        if (expression != null) {
            TypeConstraint[] typeConstraintArray = GroovyExpectedTypesProvider.calculateTypeConstraints(expression);
            if (typeConstraintArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor", "getExpectedTypes"));
            }
            return typeConstraintArray;
        }
        if (TypeConstraint.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor", "getExpectedTypes"));
        }
        return TypeConstraint.EMPTY_ARRAY;
    }

    @Nullable
    public static PsiType getTypeByElement(PsiElement element, PsiElement context) {
        if (element instanceof PsiType) {
            return (PsiType)element;
        }
        if (element instanceof PsiClass) {
            return PsiType.getJavaLangClass((PsiManager)context.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)context.getProject()));
        }
        if (element instanceof PsiMethod) {
            return PsiUtil.getSmartReturnType((PsiMethod)element);
        }
        if (element instanceof GrVariable) {
            if (PsiUtil.isLocalVariable(element)) {
                return TypeInferenceHelper.getInferredType(context, ((GrVariable)element).getName());
            }
            return ((GrVariable)element).getTypeGroovy();
        }
        if (element instanceof GrExpression) {
            return ((GrExpression)element).getType();
        }
        if (element instanceof PsiField) {
            return ((PsiField)element).getType();
        }
        return null;
    }
}

