/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.console.GroovyShellAction;
import org.jetbrains.plugins.groovy.console.GroovyShellActionBase;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;

public class GroovyCompletionConfidence
extends CompletionConfidence {
    private static final ElementPattern<PsiElement> CLOSURE_LBRACE = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("{")).withParent(GrClosableBlock.class);

    private static boolean isPossibleClosureParameter(GrReferenceExpression ref) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(CLOSURE_LBRACE)).accepts((Object)ref) || ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{","})).withParent((ElementPattern)PsiJavaPatterns.psiElement(GrVariable.class).withParent((ElementPattern)PsiJavaPatterns.psiElement(GrVariableDeclaration.class).afterLeaf(CLOSURE_LBRACE))))).accepts((Object)ref) || GroovyCompletionUtil.isInPossibleClosureParameter(ref);
    }

    @NotNull
    public ThreeState shouldFocusLookup(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldFocusLookup"));
        }
        PsiElement position = parameters.getPosition();
        PsiFile file = position.getContainingFile();
        if (file instanceof GroovyFile && GroovyScriptUtil.getScriptType((GroovyFile)file) != GroovyScriptUtil.DEFAULT_TYPE) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldFocusLookup"));
            }
            return threeState;
        }
        if (position.getParent() instanceof GrReferenceElement && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("(")).withParent(GrForStatement.class))).accepts((Object)position)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldFocusLookup"));
            }
            return threeState;
        }
        if (position.getParent() instanceof GrReferenceExpression) {
            GrReferenceExpression ref = (GrReferenceExpression)position.getParent();
            GrExpression qualifier = ref.getQualifierExpression();
            if (qualifier == null) {
                if (GroovyCompletionConfidence.isPossibleClosureParameter(ref)) {
                    ThreeState threeState = ThreeState.NO;
                    if (threeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldFocusLookup"));
                    }
                    return threeState;
                }
                if (parameters.getOriginalFile().getUserData(GroovyShellActionBase.GROOVY_SHELL_FILE) == Boolean.TRUE) {
                    ThreeState threeState = ThreeState.NO;
                    if (threeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldFocusLookup"));
                    }
                    return threeState;
                }
                GrExpression runtimeQualifier = org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil.getRuntimeQualifier(ref);
                if (runtimeQualifier != null && runtimeQualifier.getType() == null) {
                    ThreeState threeState = ThreeState.NO;
                    if (threeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldFocusLookup"));
                    }
                    return threeState;
                }
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldFocusLookup"));
                }
                return threeState;
            }
            if (qualifier.getType() == null) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldFocusLookup"));
                }
                return threeState;
            }
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldFocusLookup"));
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldFocusLookup"));
        }
        return threeState;
    }

    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull PsiElement contextElement, @NotNull PsiFile psiFile, int offset) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldSkipAutopopup"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldSkipAutopopup"));
        }
        if (CodeInsightSettings.getInstance().SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS && psiFile.getUserData(GroovyShellAction.GROOVY_SHELL_FILE) == Boolean.TRUE) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldSkipAutopopup"));
            }
            return threeState;
        }
        if (PsiImplUtil.isLeafElementOfType((PsiElement)contextElement, (TokenSet)TokenSets.STRING_LITERALS)) {
            PsiElement parent = contextElement.getParent();
            if (parent != null) {
                for (PsiReference reference : parent.getReferences()) {
                    if (reference.isSoft() || !reference.getRangeInElement().shiftRight(parent.getTextOffset()).containsOffset(offset)) continue;
                    ThreeState threeState = ThreeState.NO;
                    if (threeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldSkipAutopopup"));
                    }
                    return threeState;
                }
            }
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldSkipAutopopup"));
            }
            return threeState;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"def"})).accepts((Object)contextElement)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldSkipAutopopup"));
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldSkipAutopopup"));
        }
        return threeState;
    }
}

