/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.RemoveParenthesesFromMethodPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class RemoveParenthesesFromMethodCallIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        RemoveParenthesesFromMethodPredicate removeParenthesesFromMethodPredicate = new RemoveParenthesesFromMethodPredicate();
        if (removeParenthesesFromMethodPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/conversions/RemoveParenthesesFromMethodCallIntention", "getElementPredicate"));
        }
        return removeParenthesesFromMethodPredicate;
    }

    @Override
    protected boolean isStopElement(PsiElement element) {
        return super.isStopElement(element) || element instanceof GrStatementOwner;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/RemoveParenthesesFromMethodCallIntention", "processIntention"));
        }
        GrMethodCallExpression expression = (GrMethodCallExpression)element;
        StringBuilder newStatementText = new StringBuilder();
        newStatementText.append(expression.getInvokedExpression().getText()).append(' ');
        GrArgumentList argumentList = expression.getArgumentList();
        if (argumentList != null) {
            PsiElement leftParen = argumentList.getLeftParen();
            PsiElement rightParen = argumentList.getRightParen();
            if (leftParen != null) {
                leftParen.delete();
            }
            if (rightParen != null) {
                rightParen.delete();
            }
            newStatementText.append(argumentList.getText());
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(element.getProject());
        GrStatement newStatement = factory.createStatementFromText(newStatementText.toString());
        expression.replaceWithStatement(newStatement);
    }
}

