/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.util.Processor;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class LiteralConstructorSearcher {
    private final PsiMethod myConstructor;
    private final Processor<PsiReference> myConsumer;
    private final boolean myIncludeOverloads;

    public LiteralConstructorSearcher(PsiMethod constructor, Processor<PsiReference> consumer, boolean includeOverloads) {
        this.myConstructor = constructor;
        this.myConsumer = consumer;
        this.myIncludeOverloads = includeOverloads;
    }

    public boolean processLiteral(GrListOrMap literal, boolean typedContext) {
        PsiReference reference = literal.getReference();
        if (reference instanceof LiteralConstructorReference) {
            if (this.isCorrectReference((LiteralConstructorReference)reference) && !this.myConsumer.process((Object)reference)) {
                return false;
            }
            if (typedContext) {
                for (GrExpression expression : ((LiteralConstructorReference)reference).getCallArguments()) {
                    if (!(expression instanceof GrListOrMap) || this.processLiteral((GrListOrMap)expression, false)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isCorrectReference(LiteralConstructorReference reference) {
        if (reference.isReferenceTo((PsiElement)this.myConstructor)) {
            return true;
        }
        if (!this.myIncludeOverloads) {
            return false;
        }
        PsiClassType constructedClassType = reference.getConstructedClassType();
        if (constructedClassType == null) {
            return false;
        }
        PsiClass psiClass = constructedClassType.resolve();
        return this.myConstructor.getManager().areElementsEquivalent((PsiElement)this.myConstructor.getContainingClass(), (PsiElement)psiClass);
    }
}

