/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SimpleConfigurable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.debugger.GroovyHotSwapConfigurableUi;
import org.jetbrains.plugins.groovy.debugger.GroovySteppingConfigurableUi;

public class GroovyDebuggerSettings
extends XDebuggerSettings<GroovyDebuggerSettings>
implements Getter<GroovyDebuggerSettings> {
    public Boolean DEBUG_DISABLE_SPECIFIC_GROOVY_METHODS = true;
    public boolean ENABLE_GROOVY_HOTSWAP = Registry.is((String)"enable.groovy.hotswap");

    public GroovyDebuggerSettings() {
        super("groovy_debugger");
    }

    @NotNull
    public Collection<? extends Configurable> createConfigurables(@NotNull DebuggerSettingsCategory category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "org/jetbrains/plugins/groovy/debugger/GroovyDebuggerSettings", "createConfigurables"));
        }
        switch (category) {
            case STEPPING: {
                List<SimpleConfigurable> list = Collections.singletonList(SimpleConfigurable.create((String)"reference.idesettings.debugger.groovy", (String)GroovyBundle.message("groovy.debug.caption", new Object[0]), (String)"reference.idesettings.debugger.groovy", GroovySteppingConfigurableUi.class, (Getter)this));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/debugger/GroovyDebuggerSettings", "createConfigurables"));
                }
                return list;
            }
            case HOTSWAP: {
                List<SimpleConfigurable> list = Collections.singletonList(SimpleConfigurable.create((String)"reference.idesettings.debugger.groovy", (String)GroovyBundle.message("groovy.debug.caption", new Object[0]), (String)"reference.idesettings.debugger.groovy", GroovyHotSwapConfigurableUi.class, (Getter)this));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/debugger/GroovyDebuggerSettings", "createConfigurables"));
                }
                return list;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/debugger/GroovyDebuggerSettings", "createConfigurables"));
        }
        return list;
    }

    public GroovyDebuggerSettings getState() {
        return this;
    }

    public void loadState(GroovyDebuggerSettings state) {
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }

    public static GroovyDebuggerSettings getInstance() {
        return (GroovyDebuggerSettings)GroovyDebuggerSettings.getInstance(GroovyDebuggerSettings.class);
    }

    public GroovyDebuggerSettings get() {
        return this;
    }
}

