/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathsList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.config.GroovyFacetUtil;
import org.jetbrains.plugins.groovy.console.GroovyShellRunner;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class GroovyConsoleRunner
extends GroovyShellRunner {
    @Override
    @NotNull
    public String getWorkingDirectory(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/console/GroovyConsoleRunner", "getWorkingDirectory"));
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        String string = contentRoots[0].getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyConsoleRunner", "getWorkingDirectory"));
        }
        return string;
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull Module module) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/console/GroovyConsoleRunner", "createJavaParameters"));
        }
        JavaParameters res = GroovyScriptRunConfiguration.createJavaParametersWithSdk(module);
        DefaultGroovyScriptRunner.configureGenericGroovyRunner(res, module, "groovy.ui.GroovyMain", !GroovyConsoleRunner.hasGroovyAll(module), true);
        PathsList list = GroovyScriptRunner.getClassPathFromRootModel(module, true, res, true, res.getClassPath());
        if (list != null) {
            res.getClassPath().addAll(list.getPathList());
        }
        res.getProgramParametersList().addAll(new String[]{"-p", GroovyScriptRunner.getPathInConf("console.txt")});
        res.setWorkingDirectory(this.getWorkingDirectory(module));
        JavaParameters javaParameters = res;
        if (javaParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyConsoleRunner", "createJavaParameters"));
        }
        return javaParameters;
    }

    @Override
    public boolean canRun(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/console/GroovyConsoleRunner", "canRun"));
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        return contentRoots.length > 0;
    }

    @Override
    @NotNull
    public String getTitle(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/console/GroovyConsoleRunner", "getTitle"));
        }
        String moduleGroovyHomePath = LibrariesUtil.getGroovyHomePath(module);
        boolean bundled = moduleGroovyHomePath == null || !GroovyConsoleRunner.hasGroovyAll(module);
        String homePathToUse = bundled ? GroovyFacetUtil.getBundledGroovyJar().getParentFile().getParent() : moduleGroovyHomePath;
        String version = GroovyConfigUtils.getInstance().getSDKVersion(homePathToUse);
        String string = version == "undefined" ? "" : " (" + (bundled ? "Bundled " : "") + "Groovy " + version + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyConsoleRunner", "getTitle"));
        }
        return string;
    }

    private static boolean hasGroovyAll(Module module) {
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        return (facade.findClass("org.apache.commons.cli.CommandLineParser", scope) != null || facade.findClass("groovyjarjarcommonscli.CommandLineParser", scope) != null) && facade.findClass("groovy.ui.GroovyMain", scope) != null;
    }

    @Override
    @NotNull
    public String transformUserInput(@NotNull String userInput) {
        if (userInput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userInput", "org/jetbrains/plugins/groovy/console/GroovyConsoleRunner", "transformUserInput"));
        }
        String string = StringUtil.replace((String)userInput, (String)"\n", (String)"###\\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyConsoleRunner", "transformUserInput"));
        }
        return string;
    }
}

