/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.spike;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.api.Action;
import org.gradle.groovy.scripts.internal.RestrictiveCodeVisitor;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferenceDetectingVisitor
extends RestrictiveCodeVisitor {
    protected static final String AST_NODE_REFERENCE_PATH_KEY = ReferenceDetectingVisitor.class.getName() + ".referenceKey";
    protected boolean referenceEncountered;
    protected LinkedList<String> referenceStack = Lists.newLinkedList();

    public ReferenceDetectingVisitor(SourceUnit sourceUnit, String message) {
        super(sourceUnit, message);
    }

    public void visitBlockStatement(BlockStatement block) {
        for (Statement statement : block.getStatements()) {
            statement.visit((GroovyCodeVisitor)this);
        }
    }

    public void visitExpressionStatement(ExpressionStatement statement) {
        statement.getExpression().visit((GroovyCodeVisitor)this);
    }

    private <T extends Expression> void extractReferencePath(T expression, Action<T> action) {
        boolean topLevel = this.referenceStack.isEmpty();
        action.execute(expression);
        if (topLevel) {
            if (this.referenceEncountered) {
                String path = CollectionUtils.join((String)".", this.referenceStack);
                expression.setNodeMetaData((Object)AST_NODE_REFERENCE_PATH_KEY, (Object)path);
                this.referenceEncountered = false;
            }
            this.referenceStack.clear();
        }
    }

    public void visitPropertyExpression(final PropertyExpression expression) {
        this.extractReferencePath(expression, new Action<PropertyExpression>(){

            public void execute(PropertyExpression propertyExpression) {
                ReferenceDetectingVisitor.this.referenceStack.push(expression.getPropertyAsString());
                expression.getObjectExpression().visit((GroovyCodeVisitor)ReferenceDetectingVisitor.this);
            }
        });
    }

    public void visitVariableExpression(VariableExpression expression) {
        this.extractReferencePath(expression, new Action<VariableExpression>(){

            public void execute(VariableExpression expression) {
                String name = expression.getName();
                if (name.equals("$")) {
                    ReferenceDetectingVisitor.this.referenceEncountered = true;
                } else {
                    String path = ReferenceDetectingVisitor.this.getReferenceAliasPath(name);
                    if (path != null) {
                        ReferenceDetectingVisitor.this.referenceStack.push(path);
                        ReferenceDetectingVisitor.this.referenceEncountered = true;
                    }
                }
            }
        });
    }

    protected abstract String getReferenceAliasPath(String var1);
}

