/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl2java.ast;

import java.util.ArrayList;
import java.util.List;
import org.jvnet.ws.wadl.Doc;
import org.jvnet.ws.wadl.Method;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl2java.ast.FaultNode;
import org.jvnet.ws.wadl2java.ast.RepresentationNode;
import org.jvnet.ws.wadl2java.ast.ResourceNode;
import org.jvnet.ws.wadl2java.ast.ResourceTypeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodNode {
    private ResourceNode parentResource;
    private ResourceTypeNode parentResourceType;
    private String name;
    private List<Param> queryParams;
    private List<Param> headerParams;
    private List<RepresentationNode> supportedInputs;
    private List<RepresentationNode> supportedOutputs;
    private List<FaultNode> faults;
    private Method method;

    public MethodNode(Method m, ResourceNode r) {
        this.method = m;
        this.name = m.getName();
        this.parentResource = r;
        this.parentResourceType = null;
        this.queryParams = new ArrayList<Param>();
        this.queryParams.addAll(this.parentResource.getQueryParams());
        this.headerParams = new ArrayList<Param>();
        this.headerParams.addAll(this.parentResource.getHeaderParams());
        this.supportedInputs = new ArrayList<RepresentationNode>();
        this.supportedOutputs = new ArrayList<RepresentationNode>();
        this.faults = new ArrayList<FaultNode>();
        r.getMethods().add(this);
    }

    public MethodNode(Method m, ResourceTypeNode r) {
        this.method = m;
        this.name = m.getName();
        this.parentResource = null;
        this.parentResourceType = r;
        this.queryParams = new ArrayList<Param>();
        this.queryParams.addAll(r.getQueryParams());
        this.headerParams = new ArrayList<Param>();
        this.headerParams.addAll(r.getHeaderParams());
        this.supportedInputs = new ArrayList<RepresentationNode>();
        this.supportedOutputs = new ArrayList<RepresentationNode>();
        this.faults = new ArrayList<FaultNode>();
        r.getMethods().add(this);
    }

    public String getName() {
        return this.name;
    }

    public List<Param> getQueryParameters() {
        return this.queryParams;
    }

    public List<Param> getHeaderParameters() {
        return this.headerParams;
    }

    public List<Param> getRequiredParameters() {
        ArrayList<Param> required = new ArrayList<Param>();
        for (Param p : this.getQueryParameters()) {
            if (!p.isRequired()) continue;
            required.add(p);
        }
        for (Param p : this.getHeaderParameters()) {
            if (!p.isRequired()) continue;
            required.add(p);
        }
        return required;
    }

    public List<Param> getOptionalParameters() {
        ArrayList<Param> optional = new ArrayList<Param>();
        for (Param p : this.getQueryParameters()) {
            if (p.isRequired()) continue;
            optional.add(p);
        }
        for (Param p : this.getHeaderParameters()) {
            if (p.isRequired()) continue;
            optional.add(p);
        }
        return optional;
    }

    public boolean hasOptionalParameters() {
        return this.getOptionalParameters().size() > 0;
    }

    public List<RepresentationNode> getSupportedInputs() {
        return this.supportedInputs;
    }

    public List<RepresentationNode> getSupportedOutputs() {
        return this.supportedOutputs;
    }

    public List<FaultNode> getFaults() {
        return this.faults;
    }

    public List<Doc> getDoc() {
        return this.method.getDoc();
    }
}

