/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.analysis;

import com.android.annotations.NonNull;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.Visitor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import gnu.trove.TLongHashSet;
import java.util.Collection;
import java.util.List;

public class TopologicalSort {
    /*
     * WARNING - void declaration
     */
    @NonNull
    public static ImmutableList<Instance> compute(@NonNull Iterable<? extends Instance> roots) {
        TopologicalSortVisitor visitor = new TopologicalSortVisitor();
        for (Instance instance : roots) {
            instance.accept(visitor);
        }
        ImmutableList<Instance> instances = visitor.getOrderedInstances();
        Snapshot.SENTINEL_ROOT.setTopologicalOrder(0);
        boolean bl = false;
        for (Instance node : instances) {
            void var3_5;
            node.setTopologicalOrder((int)(++var3_5));
        }
        return instances;
    }

    private static class TopologicalSortVisitor
    implements Visitor {
        private final TLongHashSet mVisited = new TLongHashSet();
        private final List<Instance> mPostorder = Lists.newArrayList();

        private TopologicalSortVisitor() {
        }

        @Override
        public boolean visitEnter(Instance instance) {
            return this.mVisited.add(instance.getId());
        }

        @Override
        public void visitLeave(Instance instance) {
            this.mPostorder.add(instance);
        }

        ImmutableList<Instance> getOrderedInstances() {
            return ImmutableList.copyOf((Collection)Lists.reverse(this.mPostorder));
        }
    }
}

