/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.svnkit.lowLevel;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.idea.svn.svnkit.lowLevel.ApplicationLevelNumberConnectionsGuard;
import org.jetbrains.idea.svn.svnkit.lowLevel.CachingSvnRepositoryPool;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;

public class ApplicationLevelNumberConnectionsGuardImpl
implements Disposable,
ApplicationLevelNumberConnectionsGuard {
    public static final int DELAY = 20000;
    private final Object myLock;
    private final Set<CachingSvnRepositoryPool> mySet = new HashSet();
    private int myCurrentlyActiveConnections = 0;
    private int myCurrentlyOpenedConnections = 0;
    private boolean myDisposed = false;
    private int myInstanceCount;
    private final ScheduledExecutorService myService = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> myFuture;
    private final Runnable myRecheck;
    private int myDelay = 20000;
    private int myCurrentlyOpenedCount;

    public ApplicationLevelNumberConnectionsGuardImpl() {
        this.myLock = new Object();
        this.myRecheck = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet pools = new HashSet();
                Object object = ApplicationLevelNumberConnectionsGuardImpl.this.myLock;
                synchronized (object) {
                    pools.addAll((Collection)ApplicationLevelNumberConnectionsGuardImpl.this.mySet);
                }
                for (CachingSvnRepositoryPool pool : pools) {
                    pool.check();
                }
            }
        };
    }

    public void setDelay(int delay) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myDelay = delay;
        this.myFuture.cancel(true);
        this.myFuture = this.myService.scheduleWithFixedDelay(this.myRecheck, this.myDelay, this.myDelay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentlyActiveConnections() {
        Object object = this.myLock;
        synchronized (object) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
            return this.myCurrentlyActiveConnections;
        }
    }

    public int getInstanceCount() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        return this.myInstanceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepositoryPool(CachingSvnRepositoryPool pool) {
        Object object = this.myLock;
        synchronized (object) {
            this.mySet.add(pool);
            ++this.myInstanceCount;
            if (this.myFuture == null) {
                this.myFuture = this.myService.scheduleWithFixedDelay(this.myRecheck, this.myDelay, this.myDelay, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepositoryPool(CachingSvnRepositoryPool pool) {
        Object object = this.myLock;
        synchronized (object) {
            this.mySet.remove(pool);
            --this.myInstanceCount;
            if (this.myInstanceCount == 0) {
                this.myFuture.cancel(true);
                this.myFuture = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionCreated() {
        Object object = this.myLock;
        synchronized (object) {
            ++this.myCurrentlyOpenedConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionDestroyed(int number) {
        Object object = this.myLock;
        synchronized (object) {
            this.myCurrentlyOpenedConnections -= number;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionOpened() {
        Object object = this.myLock;
        synchronized (object) {
            ++this.myCurrentlyActiveConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed() {
        Object object = this.myLock;
        synchronized (object) {
            --this.myCurrentlyActiveConnections;
            this.myLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForTotalNumberOfConnectionsOk() throws SVNException {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCurrentlyActiveConnections >= 100) {
                this.waitForFreeConnections();
            }
        }
        HashSet copy = new HashSet();
        Object object2 = this.myLock;
        synchronized (object2) {
            if (this.myCurrentlyOpenedConnections >= 100) {
                copy.addAll(this.mySet);
            }
        }
        for (CachingSvnRepositoryPool pool : copy) {
            pool.closeInactive();
        }
        object2 = this.myLock;
        synchronized (object2) {
            this.waitForFreeConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForFreeConnections() throws SVNException {
        Object object = this.myLock;
        synchronized (object) {
            while (this.myCurrentlyActiveConnections >= 100 && !this.myDisposed) {
                ProgressIndicator indicator;
                try {
                    this.myLock.wait(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if ((indicator = ProgressManager.getInstance().getProgressIndicator()) == null || !indicator.isCanceled()) continue;
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CANCELLED));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldKeepConnectionLocally() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCurrentlyActiveConnections > 100 || this.myCurrentlyOpenedConnections > 100) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            this.myDisposed = true;
            this.myLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentlyOpenedCount() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCurrentlyOpenedCount;
        }
    }
}

