/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.integrate.ChangeListsMergerFactory;
import org.jetbrains.idea.svn.integrate.LocalChangesPromptTask;
import org.jetbrains.idea.svn.integrate.MergeAllWithBranchCopyPointTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.MergeTask;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.tmatesoft.svn.core.SVNURL;

public abstract class BaseMergeTask
extends TaskDescriptor {
    private static final Logger LOG = Logger.getInstance(BaseMergeTask.class);
    @NotNull
    protected final MergeContext myMergeContext;
    @NotNull
    protected final QuickMergeInteraction myInteraction;

    public BaseMergeTask(@NotNull MergeContext mergeContext, @NotNull QuickMergeInteraction interaction, String name, @NotNull Where where) {
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "<init>"));
        }
        if (interaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interaction", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "<init>"));
        }
        if (where == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "where", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "<init>"));
        }
        super(name, where);
        this.myMergeContext = mergeContext;
        this.myInteraction = interaction;
    }

    @NotNull
    protected List<TaskDescriptor> getMergeAllTasks() {
        ArrayList result = ContainerUtil.newArrayList();
        result.add(new LocalChangesPromptTask(this.myMergeContext, this.myInteraction, true, null, null));
        MergeAllWithBranchCopyPointTask mergeAllExecutor = new MergeAllWithBranchCopyPointTask(this.myMergeContext, this.myInteraction);
        result.add(this.myMergeContext.getVcs().getSvnBranchPointsCalculator().getFirstCopyPointTask(this.myMergeContext.getWcInfo().getRepositoryRoot(), this.myMergeContext.getSourceUrl(), this.myMergeContext.getWcInfo().getRootUrl(), mergeAllExecutor));
        result.add(mergeAllExecutor);
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "getMergeAllTasks"));
        }
        return arrayList;
    }

    protected void runChangeListsMerge(@NotNull ContinuationContext context, @NotNull List<CommittedChangeList> lists, @NotNull SvnBranchPointsCalculator.WrapperInvertor copyPoint, @NotNull String title) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "runChangeListsMerge"));
        }
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "runChangeListsMerge"));
        }
        if (copyPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyPoint", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "runChangeListsMerge"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "runChangeListsMerge"));
        }
        context.next(new TaskDescriptor[]{new LocalChangesPromptTask(this.myMergeContext, this.myInteraction, false, lists, copyPoint), new MergeTask(this.myMergeContext, this.myInteraction, new ChangeListsMergerFactory(lists, false, false, true), title)});
    }

    @Nullable
    protected SVNURL parseSourceUrl(@NotNull ContinuationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "parseSourceUrl"));
        }
        SVNURL result = null;
        try {
            result = SvnUtil.createUrl(this.myMergeContext.getSourceUrl());
        }
        catch (SvnBindException e) {
            this.finishWithError(context, e.getMessage(), true);
        }
        return result;
    }

    protected void finishWithError(@NotNull ContinuationContext context, final @NotNull String message, final boolean isError) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "finishWithError"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "finishWithError"));
        }
        LOG.info((isError ? "Error: " : "Info: ") + message);
        context.next(new TaskDescriptor[]{new TaskDescriptor(message, Where.AWT){

            public void run(ContinuationContext context) {
                BaseMergeTask.this.myInteraction.showErrors(message, isError);
                context.cancelEverything();
            }
        }});
    }

    protected void finishWithError(@NotNull ContinuationContext context, final String message, final @Nullable List<VcsException> exceptions) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "finishWithError"));
        }
        BaseMergeTask.log(message, exceptions);
        context.cancelEverything();
        context.next(new TaskDescriptor[]{new TaskDescriptor(message, Where.AWT){

            public void run(ContinuationContext context) {
                BaseMergeTask.this.myInteraction.showErrors(message, exceptions);
            }
        }});
    }

    private static void log(String message, @Nullable List<VcsException> exceptions) {
        if (exceptions != null) {
            for (VcsException exception : exceptions) {
                LOG.info(message, (Throwable)exception);
            }
        }
    }
}

