/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class SvnCopyPathTracker {
    private static final Logger LOG = Logger.getInstance(SvnCopyPathTracker.class);
    @NotNull
    private String myCurrentPath;
    private String myRepositoryRoot;
    private boolean myHadChanged;

    public SvnCopyPathTracker(@NotNull String repositoryUrl, @NotNull String relativeUrl) {
        if (repositoryUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryUrl", "org/jetbrains/idea/svn/history/SvnCopyPathTracker", "<init>"));
        }
        if (relativeUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeUrl", "org/jetbrains/idea/svn/history/SvnCopyPathTracker", "<init>"));
        }
        this.myRepositoryRoot = repositoryUrl;
        this.myCurrentPath = relativeUrl;
    }

    public void accept(@NotNull LogEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/idea/svn/history/SvnCopyPathTracker", "accept"));
        }
        Map<String, LogEntryPath> changedPaths = entry.getChangedPaths();
        if (changedPaths == null) {
            return;
        }
        for (LogEntryPath o : changedPaths.values()) {
            LogEntryPath entryPath = o;
            if (entryPath == null || 'A' != entryPath.getType() || entryPath.getCopyPath() == null) continue;
            if (this.myCurrentPath.equals(entryPath.getPath())) {
                this.myHadChanged = true;
                this.myCurrentPath = entryPath.getCopyPath();
                return;
            }
            if (!SVNPathUtil.isAncestor((String)entryPath.getPath(), (String)this.myCurrentPath)) continue;
            String relativePath = SVNPathUtil.getRelativePath((String)entryPath.getPath(), (String)this.myCurrentPath);
            this.myCurrentPath = SVNPathUtil.append((String)entryPath.getCopyPath(), (String)relativePath);
            this.myHadChanged = true;
            return;
        }
    }

    @Nullable
    public FilePath getFilePath(SvnVcs vcs) {
        String absolutePath;
        if (!this.myHadChanged) {
            return null;
        }
        SvnFileUrlMapping svnFileUrlMapping = vcs.getSvnFileUrlMapping();
        String localPath = svnFileUrlMapping.getLocalPath(absolutePath = SVNPathUtil.append((String)this.myRepositoryRoot, (String)this.myCurrentPath));
        if (localPath == null) {
            LOG.info("Cannot find local path for url: " + absolutePath);
            return null;
        }
        return new FilePathImpl(new File(localPath), false);
    }
}

