/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.BaseNodeDescription;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.tmatesoft.svn.core.SVNLogEntryPath;

public class LogEntryPath
extends BaseNodeDescription {
    private final String myPath;
    private final char myType;
    private final String myCopyPath;
    private final long myCopyRevision;

    @NotNull
    public static Builder create(@NotNull SVNLogEntryPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/history/LogEntryPath", "create"));
        }
        Builder builder = new Builder().setPath(path.getPath()).setType(path.getType()).setCopyFromPath(path.getCopyPath()).setCopyFromRevision(path.getCopyRevision()).setKind(NodeKind.from(path.getKind()));
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntryPath", "create"));
        }
        return builder;
    }

    public LogEntryPath(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/idea/svn/history/LogEntryPath", "<init>"));
        }
        super(builder.kind);
        this.myPath = builder.path;
        this.myType = CommandUtil.getStatusChar(builder.action);
        this.myCopyPath = builder.copyFromPath;
        this.myCopyRevision = builder.copyFromRevision;
    }

    public String getCopyPath() {
        return this.myCopyPath;
    }

    public long getCopyRevision() {
        return this.myCopyRevision;
    }

    public String getPath() {
        return this.myPath;
    }

    public char getType() {
        return this.myType;
    }

    @NotNull
    public NodeKind getKind() {
        NodeKind nodeKind = this.myKind;
        if (nodeKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntryPath", "getKind"));
        }
        return nodeKind;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(name="logentrypath")
    public static class Builder {
        @XmlAttribute(name="kind", required=true)
        private NodeKind kind;
        @XmlAttribute(name="action")
        private String action;
        @XmlAttribute(name="copyfrom-path")
        private String copyFromPath;
        @XmlAttribute(name="copyfrom-rev")
        private long copyFromRevision;
        @XmlValue
        private String path;

        public String getPath() {
            return this.path;
        }

        @NotNull
        public Builder setKind(@NotNull NodeKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/idea/svn/history/LogEntryPath$Builder", "setKind"));
            }
            this.kind = kind;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntryPath$Builder", "setKind"));
            }
            return builder;
        }

        @NotNull
        public Builder setType(char type) {
            this.action = String.valueOf(type);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntryPath$Builder", "setType"));
            }
            return builder;
        }

        @NotNull
        public Builder setCopyFromPath(String copyFromPath) {
            this.copyFromPath = copyFromPath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntryPath$Builder", "setCopyFromPath"));
            }
            return builder;
        }

        @NotNull
        public Builder setCopyFromRevision(long copyFromRevision) {
            this.copyFromRevision = copyFromRevision;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntryPath$Builder", "setCopyFromRevision"));
            }
            return builder;
        }

        @NotNull
        public Builder setPath(String path) {
            this.path = path;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntryPath$Builder", "setPath"));
            }
            return builder;
        }

        @NotNull
        public LogEntryPath build() {
            LogEntryPath logEntryPath = new LogEntryPath(this);
            if (logEntryPath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntryPath$Builder", "build"));
            }
            return logEntryPath;
        }
    }
}

