/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import com.intellij.util.NotNullFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.SvnRepositoryCache;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class SyntheticWorker {
    private final SvnRepositoryCache myCache = SvnRepositoryCache.getInstance();
    private final SVNURL myUrl;

    public SyntheticWorker(SVNURL url) {
        this.myUrl = url;
    }

    public void removeSelf() {
        String parentUrl;
        try {
            parentUrl = this.myUrl.removePathTail().toString();
        }
        catch (SVNException e) {
            return;
        }
        List<DirectoryEntry> children = this.myCache.getChildren(parentUrl);
        if (children == null) {
            return;
        }
        Iterator<DirectoryEntry> iterator = children.iterator();
        while (iterator.hasNext()) {
            DirectoryEntry entry = iterator.next();
            if (!this.myUrl.equals((Object)entry.getUrl())) continue;
            iterator.remove();
        }
        this.myCache.put(parentUrl, children);
    }

    public void addSyntheticChildToSelf(SVNURL newUrl, SVNURL repositoryUrl, String name, boolean isDir) {
        String currentUrlAsString = this.myUrl.toString();
        List<DirectoryEntry> children = this.myCache.getChildren(currentUrlAsString);
        if (children == null) {
            return;
        }
        children.add(SyntheticWorker.createSyntheticEntry(newUrl, repositoryUrl, name, isDir));
        Collections.sort(children);
        this.myCache.put(currentUrlAsString, children);
    }

    public void copyTreeToSelf(RepositoryTreeNode node) {
        try {
            node.doOnSubtree(new Adder(node.getURL().removePathTail().toString().length(), this.myUrl));
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
    }

    public static void removeTreeOf(RepositoryTreeNode node) {
        node.doOnSubtree(new Remover());
    }

    public static DirectoryEntry createSyntheticEntry(SVNURL newUrl, SVNURL repositoryUrl, String name, boolean isDir) {
        return new DirectoryEntry(newUrl, repositoryUrl, name, NodeKind.from(isDir), CommitInfo.EMPTY, null);
    }

    private class Adder
    implements NotNullFunction<RepositoryTreeNode, Object> {
        private final int myOldPrefixLen;
        private final SVNURL myNewParentUrl;

        private Adder(int oldPrefixLen, SVNURL newParentUrl) {
            this.myOldPrefixLen = oldPrefixLen;
            this.myNewParentUrl = newParentUrl;
        }

        @NotNull
        public Object fun(RepositoryTreeNode repositoryTreeNode) {
            List<DirectoryEntry> children = SyntheticWorker.this.myCache.getChildren(repositoryTreeNode.getURL().toString());
            if (children == null) {
                Boolean bl = Boolean.FALSE;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/browserCache/SyntheticWorker$Adder", "fun"));
                }
                return bl;
            }
            ArrayList<DirectoryEntry> newChildren = new ArrayList<DirectoryEntry>(children.size());
            try {
                for (DirectoryEntry child : children) {
                    newChildren.add(SyntheticWorker.createSyntheticEntry(this.convertUrl(child.getUrl()), child.getRepositoryRoot(), child.getName(), child.isDirectory()));
                }
                SyntheticWorker.this.myCache.put(this.convertUrl(repositoryTreeNode.getURL()).toString(), newChildren);
            }
            catch (SVNException e) {
                // empty catch block
            }
            Boolean bl = Boolean.FALSE;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/browserCache/SyntheticWorker$Adder", "fun"));
            }
            return bl;
        }

        private SVNURL convertUrl(SVNURL currentUrl) throws SVNException {
            return this.myNewParentUrl.appendPath(currentUrl.toString().substring(this.myOldPrefixLen), true);
        }
    }

    private static class Remover
    implements NotNullFunction<RepositoryTreeNode, Object> {
        private final SvnRepositoryCache myCache = SvnRepositoryCache.getInstance();

        private Remover() {
        }

        @NotNull
        public Object fun(RepositoryTreeNode repositoryTreeNode) {
            this.myCache.remove(repositoryTreeNode.getURL().toString());
            Boolean bl = Boolean.FALSE;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/browserCache/SyntheticWorker$Remover", "fun"));
            }
            return bl;
        }
    }
}

