/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnProgressCanceller;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.AuthCallbackCase;
import org.jetbrains.idea.svn.commandLine.CertificateCallbackCase;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandParametersResolutionModule;
import org.jetbrains.idea.svn.commandLine.CommandRuntimeModule;
import org.jetbrains.idea.svn.commandLine.ProxyCallback;
import org.jetbrains.idea.svn.commandLine.ProxyModule;
import org.jetbrains.idea.svn.commandLine.SshTunnelRuntimeModule;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.commandLine.TerminalExecutor;
import org.jetbrains.idea.svn.commandLine.TerminalSshModule;
import org.jetbrains.idea.svn.commandLine.TerminalSslCertificateModule;
import org.jetbrains.idea.svn.commandLine.TerminalUserNamePasswordModule;
import org.jetbrains.idea.svn.commandLine.TwoWaySslCallback;
import org.jetbrains.idea.svn.commandLine.UsernamePasswordCallback;
import org.jetbrains.idea.svn.commandLine.WinTerminalExecutor;
import org.tmatesoft.svn.core.SVNURL;

public class CommandRuntime {
    private static final Logger LOG = Logger.getInstance(CommandRuntime.class);
    @NotNull
    private final AuthenticationService myAuthenticationService;
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final List<CommandRuntimeModule> myModules;
    private final String exePath;
    @NotNull
    private final String executableLocale;

    public CommandRuntime(@NotNull SvnVcs vcs, @NotNull AuthenticationService authenticationService) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "<init>"));
        }
        if (authenticationService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authenticationService", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "<init>"));
        }
        this.myVcs = vcs;
        this.myAuthenticationService = authenticationService;
        SvnApplicationSettings settings = SvnApplicationSettings.getInstance();
        this.exePath = settings.getCommandLinePath();
        this.executableLocale = Registry.stringValue((String)"svn.executable.locale");
        this.myModules = ContainerUtil.newArrayList();
        this.myModules.add(new CommandParametersResolutionModule(this));
        this.myModules.add(new ProxyModule(this));
        this.myModules.add(new SshTunnelRuntimeModule(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CommandExecutor runWithAuthenticationAttempt(@NotNull Command command) throws SvnBindException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "runWithAuthenticationAttempt"));
        }
        this.onStart(command);
        boolean repeat = true;
        CommandExecutor executor = null;
        while (repeat) {
            executor = this.newExecutor(command);
            executor.run();
            repeat = this.onAfterCommand(executor, command);
        }
        CommandExecutor commandExecutor = executor;
        CommandExecutor commandExecutor2 = commandExecutor;
        if (commandExecutor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "runWithAuthenticationAttempt"));
        }
        return commandExecutor2;
        finally {
            this.onFinish();
        }
    }

    @NotNull
    public CommandExecutor runLocal(@NotNull Command command, int timeout) throws SvnBindException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "runLocal"));
        }
        CommandExecutor executor = this.newExecutor(command);
        executor.run(timeout);
        this.onAfterCommand(executor, command);
        CommandExecutor commandExecutor = executor;
        if (commandExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "runLocal"));
        }
        return commandExecutor;
    }

    private void onStart(@NotNull Command command) throws SvnBindException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "onStart"));
        }
        command.setCanceller(new SvnProgressCanceller());
        for (CommandRuntimeModule module : this.myModules) {
            module.onStart(command);
        }
    }

    private boolean onAfterCommand(@NotNull CommandExecutor executor, @NotNull Command command) throws SvnBindException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "onAfterCommand"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "onAfterCommand"));
        }
        boolean repeat = false;
        Integer exitCode = executor.getExitCodeReference();
        if (exitCode == null || exitCode != 0) {
            CommandRuntime.logNullExitCode(executor, exitCode);
            this.cleanupManualDestroy(executor, command);
            repeat = !StringUtil.isEmpty((String)executor.getErrorOutput()) ? this.handleErrorText(executor, command) : CommandRuntime.handleErrorCode(executor);
        } else {
            CommandRuntime.handleSuccess(executor);
        }
        return repeat;
    }

    private static void handleSuccess(@NotNull CommandExecutor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "handleSuccess"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)executor.getErrorOutput())) {
            LOG.info("Detected warning - " + executor.getErrorOutput());
        }
    }

    private static boolean handleErrorCode(CommandExecutor executor) throws SvnBindException {
        Integer exitCode = executor.getExitCodeReference();
        if (exitCode != null) {
            LOG.info("Command - " + executor.getCommandText());
            LOG.info("Command output - " + executor.getOutput());
            throw new SvnBindException("Svn process exited with error code: " + exitCode);
        }
        return false;
    }

    private boolean handleErrorText(CommandExecutor executor, Command command) throws SvnBindException {
        String errText = executor.getErrorOutput().trim();
        AuthCallbackCase callback = this.createCallback(errText, command.getRepositoryUrl(), executor instanceof TerminalExecutor);
        if (!executor.checkCancelled() && callback != null && callback.getCredentials(errText)) {
            if (this.myAuthenticationService.getSpecialConfigDir() != null) {
                command.setConfigDir(this.myAuthenticationService.getSpecialConfigDir());
            }
            callback.updateParameters(command);
            return true;
        }
        throw new SvnBindException(errText);
    }

    private void cleanupManualDestroy(CommandExecutor executor, Command command) throws SvnBindException {
        if (executor.isManuallyDestroyed()) {
            this.cleanup(executor, command.getWorkingDirectory());
            String destroyReason = executor.getDestroyReason();
            if (!StringUtil.isEmpty((String)destroyReason)) {
                throw new SvnBindException(destroyReason);
            }
        }
    }

    private void onFinish() {
        this.myAuthenticationService.reset();
    }

    private static void logNullExitCode(@NotNull CommandExecutor executor, @Nullable Integer exitCode) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "logNullExitCode"));
        }
        if (exitCode == null) {
            LOG.info("Null exit code returned, but not errors detected " + executor.getCommandText());
        }
    }

    @Nullable
    private AuthCallbackCase createCallback(final @NotNull String errText, @Nullable SVNURL url, boolean isUnderTerminal) {
        if (errText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errText", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "createCallback"));
        }
        ArrayList authCases = ContainerUtil.newArrayList();
        if (isUnderTerminal) {
            authCases.add(new ProxyCallback(this.myAuthenticationService, url));
            authCases.add(new TwoWaySslCallback(this.myAuthenticationService, url));
        } else {
            authCases.add(new CertificateCallbackCase(this.myAuthenticationService, url));
            authCases.add(new ProxyCallback(this.myAuthenticationService, url));
            authCases.add(new TwoWaySslCallback(this.myAuthenticationService, url));
            authCases.add(new UsernamePasswordCallback(this.myAuthenticationService, url));
        }
        return (AuthCallbackCase)ContainerUtil.find((Iterable)authCases, (Condition)new Condition<AuthCallbackCase>(){

            public boolean value(AuthCallbackCase authCase) {
                return authCase.canHandle(errText);
            }
        });
    }

    private void cleanup(@NotNull CommandExecutor executor, @NotNull File workingDirectory) throws SvnBindException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "cleanup"));
        }
        if (workingDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDirectory", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "cleanup"));
        }
        if (executor.getCommandName().isWriteable()) {
            File wcRoot = SvnUtil.getWorkingCopyRootNew(workingDirectory);
            if (wcRoot != null) {
                Command cleanupCommand = new Command(SvnCommandName.cleanup);
                cleanupCommand.setWorkingDirectory(wcRoot);
                this.newExecutor(cleanupCommand).run();
            } else {
                LOG.info("Could not execute cleanup for command " + executor.getCommandText());
            }
        }
    }

    @NotNull
    private CommandExecutor newExecutor(@NotNull Command command) {
        CommandExecutor executor;
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "newExecutor"));
        }
        if (!this.myVcs.getSvnConfiguration().isRunUnderTerminal() || CommandRuntime.isLocal(command)) {
            command.putIfNotPresent("--non-interactive");
            executor = new CommandExecutor(this.exePath, this.executableLocale, command);
        } else {
            executor = this.newTerminalExecutor(command);
            ((TerminalExecutor)executor).addInteractiveListener(new TerminalSshModule(this, executor));
            ((TerminalExecutor)executor).addInteractiveListener(new TerminalSslCertificateModule(this, executor));
            ((TerminalExecutor)executor).addInteractiveListener(new TerminalUserNamePasswordModule(this, executor));
        }
        CommandExecutor commandExecutor = executor;
        if (commandExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "newExecutor"));
        }
        return commandExecutor;
    }

    @NotNull
    private TerminalExecutor newTerminalExecutor(@NotNull Command command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "newTerminalExecutor"));
        }
        TerminalExecutor terminalExecutor = SystemInfo.isWindows ? new WinTerminalExecutor(this.exePath, this.executableLocale, command) : new TerminalExecutor(this.exePath, this.executableLocale, command);
        if (terminalExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "newTerminalExecutor"));
        }
        return terminalExecutor;
    }

    public static boolean isLocal(@NotNull Command command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "isLocal"));
        }
        return SvnCommandName.version.equals((Object)command.getName()) || SvnCommandName.cleanup.equals((Object)command.getName()) || SvnCommandName.add.equals((Object)command.getName()) || SvnCommandName.delete.equals((Object)command.getName()) || SvnCommandName.revert.equals((Object)command.getName()) || SvnCommandName.resolve.equals((Object)command.getName()) || SvnCommandName.upgrade.equals((Object)command.getName()) || SvnCommandName.changelist.equals((Object)command.getName()) || command.isLocalInfo() || command.isLocalStatus() || command.isLocalProperty() || command.isLocalCat();
    }

    @NotNull
    public AuthenticationService getAuthenticationService() {
        AuthenticationService authenticationService = this.myAuthenticationService;
        if (authenticationService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "getAuthenticationService"));
        }
        return authenticationService;
    }

    @NotNull
    public SvnVcs getVcs() {
        SvnVcs svnVcs = this.myVcs;
        if (svnVcs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandRuntime", "getVcs"));
        }
        return svnVcs;
    }
}

