/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.util.HashMap;
import net.sourceforge.jnlp.util.logging.OutputController;

public class TimedHashMap<K, V> {
    HashMap<K, V> actualMap = new HashMap();
    HashMap<K, Long> timeStamps = new HashMap();
    Long expiry = 10000000000L;

    public V put(K key, V value) {
        this.timeStamps.put(key, System.nanoTime());
        return this.actualMap.put(key, value);
    }

    public V get(K key) {
        Long now = System.nanoTime();
        if (this.actualMap.containsKey(key)) {
            Long age = now - this.timeStamps.get(key);
            if (age <= this.expiry) {
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Returning proxy " + this.actualMap.get(key) + " from cache for " + key);
                this.timeStamps.put(key, System.nanoTime());
                return this.actualMap.get(key);
            }
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Proxy cache for " + key + " has expired (age=" + (double)age.longValue() * 1.0E-9 + " seconds)");
        }
        return null;
    }
}

