/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.util.logging.OutputController;

public class SecurityUtil {
    private static final char[] password = "changeit".toCharArray();

    public static String getTrustedCertsFilename() throws Exception {
        return KeyStores.getKeyStoreLocation(KeyStores.Level.USER, KeyStores.Type.CERTS);
    }

    public static char[] getTrustedCertsPassword() {
        return password;
    }

    public static String getCN(String principal) {
        int start = principal.indexOf("CN=");
        if (start == -1) {
            return principal;
        }
        StringBuilder commonName = new StringBuilder();
        boolean inQuotes = false;
        boolean escaped = false;
        char[] hexBits = null;
        block5: for (int i = start + 3; i < principal.length(); ++i) {
            char ch = principal.charAt(i);
            switch (ch) {
                case '\"': {
                    if (escaped) {
                        commonName.append(ch);
                        escaped = false;
                        continue block5;
                    }
                    inQuotes = !inQuotes;
                    continue block5;
                }
                case '\\': {
                    if (escaped) {
                        commonName.append(ch);
                        escaped = false;
                        continue block5;
                    }
                    escaped = true;
                    continue block5;
                }
                case '+': 
                case ',': 
                case ';': {
                    if (escaped || inQuotes) {
                        commonName.append(ch);
                        if (!escaped) continue block5;
                        escaped = false;
                        continue block5;
                    }
                    return commonName.toString();
                }
                default: {
                    if (escaped && SecurityUtil.isHexDigit(ch)) {
                        hexBits = new char[2];
                        hexBits[0] = ch;
                    } else if (hexBits != null) {
                        if (!SecurityUtil.isHexDigit(ch)) {
                            return "";
                        }
                        hexBits[1] = ch;
                        commonName.append((char)Integer.parseInt(new String(hexBits), 16));
                        hexBits = null;
                    } else {
                        commonName.append(ch);
                    }
                    escaped = false;
                }
            }
        }
        return commonName.toString();
    }

    private static boolean isHexDigit(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }

    public static boolean checkTrustedCertsFile() throws Exception {
        File certFile = new File(SecurityUtil.getTrustedCertsFilename());
        if (!certFile.isFile()) {
            File dir = certFile.getAbsoluteFile().getParentFile();
            boolean madeDir = false;
            if (!dir.isDirectory()) {
                madeDir = dir.mkdirs();
            }
            if (madeDir || dir.isDirectory()) {
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(null, password);
                FileOutputStream fos = new FileOutputStream(certFile);
                ks.store(fos, password);
                fos.close();
                return true;
            }
            return false;
        }
        return true;
    }

    public static KeyStore getUserKeyStore() throws Exception {
        KeyStore ks = null;
        FileInputStream fis = null;
        if (SecurityUtil.checkTrustedCertsFile()) {
            try {
                File file = new File(SecurityUtil.getTrustedCertsFilename());
                if (file.exists()) {
                    fis = new FileInputStream(file);
                    ks = KeyStore.getInstance("JKS");
                    ks.load(fis, password);
                }
            }
            catch (Exception e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
                throw e;
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getCacertsKeyStore() throws Exception {
        KeyStore caks = null;
        FileInputStream fis = null;
        try {
            File file = new File(System.getProperty("java.home") + "/lib/security/cacerts");
            if (file.exists()) {
                fis = new FileInputStream(file);
                caks = KeyStore.getInstance("JKS");
                caks.load(fis, null);
            }
        }
        catch (Exception e) {
            caks = null;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return caks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getSystemCertStore() throws Exception {
        KeyStore caks = null;
        FileInputStream fis = null;
        try {
            File file = new File(System.getProperty("javax.net.ssl.trustStore"));
            String type = System.getProperty("javax.net.ssl.trustStoreType");
            char[] password = System.getProperty("javax.net.ssl.trustStorePassword").toCharArray();
            if (file.exists()) {
                fis = new FileInputStream(file);
                caks = KeyStore.getInstance(type);
                caks.load(fis, password);
            }
        }
        catch (Exception e) {
            caks = null;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return caks;
    }
}

