/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.UIManager;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.Launcher;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.about.AboutDialog;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.viewer.CertificateViewer;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public final class Boot
implements PrivilegedAction<Void> {
    public static final String name = Boot.class.getPackage().getImplementationTitle();
    public static final String version = Boot.class.getPackage().getImplementationVersion();
    private static final String nameAndVersion = name + " " + version;
    private static final String miniLicense = "\n   netx - an open-source JNLP client.\n   Copyright (C) 2001-2003 Jon A. Maxwell (JAM)\n\n   // This library is free software; you can redistribute it and/or\n   modify it under the terms of the GNU Lesser General Public\n   License as published by the Free Software Foundation; either\n   version 2.1 of the License, or (at your option) any later version.\n\n   This library is distributed in the hope that it will be useful,\n   but WITHOUT ANY WARRANTY; without even the implied warranty of\n   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n   Lesser General Public License for more details.\n\n   You should have received a copy of the GNU Lesser General Public\n   License along with this library; if not, write to the Free Software\n   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n\n";
    private static final String itwInfoMessage = "" + nameAndVersion + "\n\n*  " + Translator.R("BAboutITW") + "\n*  " + Translator.R("BFileInfoAuthors") + "\n*  " + Translator.R("BFileInfoNews") + "\n*  " + Translator.R("BFileInfoCopying");
    private static final String helpMessage = "\nUsage:   " + Translator.R("BOUsage") + "\n" + "         " + Translator.R("BOUsage2") + "\n" + "\n" + "control-options:" + "\n" + "  -about                " + Translator.R("BOAbout") + "\n" + "  -viewer               " + Translator.R("BOViewer") + "\n" + "\n" + "run-options:" + "\n" + "  -version              " + Translator.R("BOVersion") + "\n" + "  -arg arg              " + Translator.R("BOArg") + "\n" + "  -param name=value     " + Translator.R("BOParam") + "\n" + "  -property name=value  " + Translator.R("BOProperty") + "\n" + "  -update seconds       " + Translator.R("BOUpdate") + "\n" + "  -license              " + Translator.R("BOLicense") + "\n" + "  -verbose              " + Translator.R("BOVerbose") + "\n" + "  -nosecurity           " + Translator.R("BONosecurity") + "\n" + "  -noupdate             " + Translator.R("BONoupdate") + "\n" + "  -headless             " + Translator.R("BOHeadless") + "\n" + "  -strict               " + Translator.R("BOStrict") + "\n" + "  -xml                  " + Translator.R("BOXml") + "\n" + "  -allowredirect        " + Translator.R("BOredirect") + "\n" + "  -Xnofork              " + Translator.R("BXnofork") + "\n" + "  -Xclearcache          " + Translator.R("BXclearcache") + "\n" + "  -Xignoreheaders       " + Translator.R("BXignoreheaders") + "\n" + "  -help                 " + Translator.R("BOHelp") + "\n";
    private static final String doubleArgs = "-basedir -jnlp -arg -param -property -update";
    private static String[] args;

    public static void main(String[] argsIn) {
        String[] properties;
        args = argsIn;
        if (AppContext.getAppContext() == null) {
            SunToolkit.createNewAppContext();
        }
        if (null != Boot.getOption("-headless")) {
            JNLPRuntime.setHeadless(true);
        }
        if ((properties = Boot.getOptions("-property")) != null) {
            for (String prop : properties) {
                try {
                    PropertyDesc propDesc = PropertyDesc.fromString(prop, "Unlocalised error for parsing the property. It must be in fomrat key=value. It is: " + prop);
                    JNLPRuntime.getConfiguration().setProperty(propDesc.getKey(), propDesc.getValue());
                }
                catch (LaunchException ex) {
                    OutputController.getLogger().log(ex);
                }
            }
        }
        DeploymentConfiguration.move14AndOlderFilesTo15StructureCatched();
        if (null != Boot.getOption("-viewer")) {
            try {
                CertificateViewer.main(null);
                JNLPRuntime.exit(0);
            }
            catch (Exception e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            }
        }
        if (null != Boot.getOption("-version")) {
            OutputController.getLogger().printOutLn(nameAndVersion);
            JNLPRuntime.exit(0);
        }
        if (null != Boot.getOption("-license")) {
            OutputController.getLogger().printOutLn(miniLicense);
            JNLPRuntime.exit(0);
        }
        if (null != Boot.getOption("-help")) {
            OutputController.getLogger().printOutLn(helpMessage);
            JNLPRuntime.exit(0);
        }
        if (null != Boot.getOption("-about")) {
            OutputController.getLogger().printOutLn(itwInfoMessage);
            if (null != Boot.getOption("-headless")) {
                JNLPRuntime.exit(0);
            } else {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    OutputController.getLogger().log("Unable to set system look and feel");
                }
                OutputController.getLogger().printOutLn(Translator.R("BLaunchAbout"));
                AboutDialog.display();
                return;
            }
        }
        if (null != Boot.getOption("-verbose")) {
            JNLPRuntime.setDebug(true);
        }
        if (null != Boot.getOption("-update")) {
            int value = Integer.parseInt(Boot.getOption("-update"));
            JNLPRuntime.setDefaultUpdatePolicy(new UpdatePolicy((long)value * 1000L));
        }
        if (null != Boot.getOption("-noupdate")) {
            JNLPRuntime.setDefaultUpdatePolicy(UpdatePolicy.NEVER);
        }
        if (null != Boot.getOption("-Xnofork")) {
            JNLPRuntime.setForksAllowed(false);
        }
        if (null != Boot.getOption("-Xtrustall")) {
            JNLPRuntime.setTrustAll(true);
        }
        if (null != Boot.getOption("-Xtrustnone")) {
            JNLPRuntime.setTrustNone(true);
        }
        if (null != Boot.getOption("-Xignoreheaders")) {
            JNLPRuntime.setIgnoreHeaders(true);
        }
        if (null != Boot.getOption("-allowredirect")) {
            JNLPRuntime.setAllowRedirect(true);
        }
        JNLPRuntime.setInitialArgments(Arrays.asList(argsIn));
        AccessController.doPrivileged(new Boot());
    }

    @Override
    public Void run() {
        JNLPRuntime.setSecurityEnabled(null == Boot.getOption("-nosecurity"));
        JNLPRuntime.initialize(true);
        if (null != Boot.getOption("-Xclearcache")) {
            CacheUtil.clearCache();
            return null;
        }
        HashMap<String, String[]> extra = new HashMap<String, String[]>();
        extra.put("arguments", Boot.getOptions("-arg"));
        extra.put("parameters", Boot.getOptions("-param"));
        extra.put("properties", Boot.getOptions("-property"));
        ParserSettings settings = ParserSettings.setGlobalParserSettingsFromArgs(args);
        try {
            Launcher launcher = new Launcher(false);
            launcher.setParserSettings(settings);
            launcher.setInformationToMerge(extra);
            launcher.launch(Boot.getFileLocation());
        }
        catch (LaunchException launcher) {
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            Boot.fatalError(Translator.R("RUnexpected", ex.toString(), ex.getStackTrace()[0]));
        }
        return null;
    }

    private static void fatalError(String message) {
        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "netx: " + message);
        JNLPRuntime.exit(1);
    }

    private static URL getFileLocation() {
        String location = Boot.getJNLPFile();
        if (location == null) {
            OutputController.getLogger().printOutLn(helpMessage);
            JNLPRuntime.exit(1);
        }
        OutputController.getLogger().log(Translator.R("BFileLoc") + ": " + location);
        URL url = null;
        try {
            url = new File(location).exists() ? new File(location).toURL() : new URL(ServiceUtil.getBasicService().getCodeBase(), location);
        }
        catch (Exception e) {
            OutputController.getLogger().log(e);
            Boot.fatalError("Invalid jnlp file " + location);
        }
        return url;
    }

    private static String getJNLPFile() {
        if (args.length == 0) {
            OutputController.getLogger().printOutLn(helpMessage);
            JNLPRuntime.exit(0);
        } else {
            if (args.length == 1) {
                return args[args.length - 1];
            }
            String lastArg = args[args.length - 1];
            String secondLastArg = args[args.length - 2];
            if (doubleArgs.indexOf(secondLastArg) == -1) {
                return lastArg;
            }
            OutputController.getLogger().printOutLn(helpMessage);
            JNLPRuntime.exit(0);
        }
        return null;
    }

    private static String getOption(String option) {
        String[] result = Boot.getOptions(option);
        if (result.length == 0) {
            return null;
        }
        return result[0];
    }

    private static String[] getOptions(String option) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (option.equals(args[i])) {
                if (-1 == doubleArgs.indexOf(option)) {
                    result.add(option);
                } else if (i + 1 < args.length) {
                    result.add(args[i + 1]);
                }
            }
            if (!args[i].startsWith("-") || -1 == doubleArgs.indexOf(args[i])) continue;
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }
}

