/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.about;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.sourceforge.jnlp.about.HTMLPanel;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.ScreenFinder;

public class AboutDialog
extends JPanel
implements Runnable,
ActionListener {
    private static final String about_url = "/net/sourceforge/jnlp/resources/about.html";
    private static final String authors_url = "/net/sourceforge/jnlp/resources/AUTHORS.html";
    private static final String changelog_url = "/net/sourceforge/jnlp/resources/ChangeLog.html";
    private static final String copying_url = "/net/sourceforge/jnlp/resources/COPYING.html";
    private static final String news_url = "/net/sourceforge/jnlp/resources/NEWS.html";
    private JDialog frame;
    private JPanel contentPane;
    private HTMLPanel aboutPanel;
    private HTMLPanel authorsPanel;
    private HTMLPanel newsPanel;
    private HTMLPanel changelogPanel;
    private HTMLPanel copyingPanel;
    private JButton aboutButton;
    private JButton authorsButton;
    private JButton newsButton;
    private JButton changelogButton;
    private JButton copyingButton;

    public AboutDialog(boolean modal) {
        super(new GridBagLayout());
        this.frame = new JDialog((Frame)null, Translator.R("AboutDialogueTabAbout") + " IcedTea-Web", modal);
        this.frame.setContentPane(this);
        this.frame.setDefaultCloseOperation(2);
        URL res_about = this.getClass().getResource(about_url);
        URL res_authors = this.getClass().getResource(authors_url);
        URL res_news = this.getClass().getResource(news_url);
        URL res_changelog = this.getClass().getResource(changelog_url);
        URL res_copying = this.getClass().getResource(copying_url);
        this.aboutPanel = new HTMLPanel(res_about, Translator.R("AboutDialogueTabAbout"));
        this.authorsPanel = new HTMLPanel(res_authors, Translator.R("AboutDialogueTabAuthors"));
        this.newsPanel = new HTMLPanel(res_news, Translator.R("AboutDialogueTabNews"));
        this.changelogPanel = new HTMLPanel(res_changelog, Translator.R("AboutDialogueTabChangelog"));
        this.copyingPanel = new HTMLPanel(res_copying, Translator.R("AboutDialogueTabGPLv2"));
        this.aboutButton = new JButton(this.aboutPanel.getIdentifier());
        this.aboutButton.setActionCommand(this.aboutPanel.getIdentifier());
        this.aboutButton.addActionListener(this);
        this.authorsButton = new JButton(this.authorsPanel.getIdentifier());
        this.authorsButton.setActionCommand(this.authorsPanel.getIdentifier());
        this.authorsButton.addActionListener(this);
        this.newsButton = new JButton(this.newsPanel.getIdentifier());
        this.newsButton.setActionCommand(this.newsPanel.getIdentifier());
        this.newsButton.addActionListener(this);
        this.changelogButton = new JButton(this.changelogPanel.getIdentifier());
        this.changelogButton.setActionCommand(this.changelogPanel.getIdentifier());
        this.changelogButton.addActionListener(this);
        this.copyingButton = new JButton(this.copyingPanel.getIdentifier());
        this.copyingButton.setActionCommand(this.copyingPanel.getIdentifier());
        this.copyingButton.addActionListener(this);
        this.contentPane = this.aboutPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(((HTMLPanel)this.contentPane).getIdentifier())) {
            return;
        }
        if (action.equals(this.aboutPanel.getIdentifier())) {
            this.contentPane = this.aboutPanel;
        } else if (action.equals(this.authorsPanel.getIdentifier())) {
            this.contentPane = this.authorsPanel;
        } else if (action.equals(this.newsPanel.getIdentifier())) {
            this.contentPane = this.newsPanel;
        } else if (action.equals(this.changelogPanel.getIdentifier())) {
            this.contentPane = this.changelogPanel;
        } else if (action.equals(this.copyingPanel.getIdentifier())) {
            this.contentPane = this.copyingPanel;
        }
        this.layoutWindow();
    }

    private void layoutWindow() {
        this.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.contentPane, gbc);
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.ipady = 16;
        this.add((Component)this.aboutButton, gbc);
        gbc.gridx = 1;
        this.add((Component)this.authorsButton, gbc);
        gbc.gridx = 2;
        this.add((Component)this.newsButton, gbc);
        gbc.gridx = 3;
        this.add((Component)this.changelogButton, gbc);
        gbc.gridx = 4;
        this.add((Component)this.copyingButton, gbc);
        Dimension contentSize = new Dimension(640, 480);
        this.contentPane.setMinimumSize(contentSize);
        this.contentPane.setPreferredSize(contentSize);
        this.contentPane.setBorder(new EmptyBorder(0, 0, 8, 0));
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.frame.pack();
    }

    @Override
    public void run() {
        this.layoutWindow();
        ScreenFinder.centerWindowsToCurrentScreen(this.frame);
        this.frame.setVisible(true);
    }

    public static void display() {
        AboutDialog.display(false);
    }

    public static void display(boolean modal) {
        SwingUtilities.invokeLater(new AboutDialog(modal));
    }
}

