/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;

public class ExtensionDesc {
    private String name;
    private Version version;
    private URL location;
    private JNLPFile file;
    private Map<String, String> extToPart = new HashMap<String, String>();
    private List<String> eagerExtParts = new ArrayList<String>();

    public ExtensionDesc(String name, Version version, URL location) {
        this.name = name;
        this.version = version;
        this.location = location;
    }

    protected void addPart(String extPart, String part, boolean lazy) {
        this.extToPart.put(extPart, part);
        if (!lazy || part == null || part.length() == 0) {
            this.eagerExtParts.add(extPart);
        }
    }

    public String[] getExtensionParts(String thisPart) {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public URL getLocation() {
        return this.location;
    }

    public void resolve() throws ParseException, IOException {
        if (this.file == null) {
            this.file = new JNLPFile(this.location);
            OutputController.getLogger().log("Resolve: " + this.file.getInformation().getTitle());
            if (!this.file.isComponent() && !this.file.isInstaller()) {
                throw new ParseException(Translator.R("JInvalidExtensionDescriptor", this.name, this.location));
            }
        }
    }

    public JNLPFile getJNLPFile() {
        return this.file;
    }
}

