#!/bin/sh
export PATH='/usr/obj/hs-uniplate-1.6.12/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: uniplate
version: 1.6.12
id: uniplate-1.6.12-50c3d644c789ce0ffb7798228041d991

license: BSD3
copyright: Neil Mitchell 2006-2013
maintainer: Neil Mitchell <ndmitchell@gmail.com>
stability:
homepage: http://community.haskell.org/~ndm/uniplate/
package-url:
synopsis: Help writing simple, concise and fast generic operations.
description: Uniplate is library for writing simple and concise generic operations.
             Uniplate has similar goals to the original Scrap Your Boilerplate work,
             but is substantially simpler and faster. The Uniplate manual is available at
             <http://community.haskell.org/~ndm/darcs/uniplate/uniplate.htm>.
             .
             To get started with Uniplate you should import one of the three following
             modules:
             .
             * "Data.Generics.Uniplate.Data" - to quickly start writing generic functions.
             Most users should start by importing this module.
             .
             * "Data.Generics.Uniplate.Direct" - a replacement for "Data.Generics.Uniplate.Data"
             with substantially higher performance (around 5 times), but requires writing
             instance declarations.
             .
             * "Data.Generics.Uniplate.Operations" - definitions of all the operations defined
             by Uniplate. Both the above two modules re-export this module.
             .
             In addition, some users may want to make use of the following modules:
             .
             * "Data.Generics.Uniplate.Zipper" - a zipper built on top of Uniplate instances.
             .
             * "Data.Generics.SYB" - users transitioning from the Scrap Your Boilerplate library.
             .
             * "Data.Generics.Compos" - users transitioning from the Compos library.
             .
             * "Data.Generics.Uniplate.DataOnly" - users making use of both @Data@ and @Direct@
             to avoid getting instance conflicts.
category: Generics
author: Neil Mitchell <ndmitchell@gmail.com>
pkgpath: devel/hs-uniplate
exposed: True
exposed-modules: Data.Generics.Str Data.Generics.Compos
                 Data.Generics.SYB Data.Generics.Uniplate.Data
                 Data.Generics.Uniplate.Data.Instances
                 Data.Generics.Uniplate.DataOnly Data.Generics.Uniplate.Direct
                 Data.Generics.Uniplate.Operations Data.Generics.Uniplate.Typeable
                 Data.Generics.Uniplate.Zipper Data.Generics.Uniplate
                 Data.Generics.UniplateOn Data.Generics.UniplateStr
                 Data.Generics.UniplateStrOn Data.Generics.Biplate
                 Data.Generics.PlateDirect Data.Generics.PlateTypeable
                 Data.Generics.PlateData
hidden-modules: Data.Generics.Uniplate.Internal.Data
                Data.Generics.Uniplate.Internal.DataOnlyOperations
                Data.Generics.Uniplate.Internal.Utils
trusted: False
import-dirs: /usr/local/lib/ghc/uniplate-1.6.12
library-dirs: /usr/local/lib/ghc/uniplate-1.6.12
hs-libraries: HSuniplate-1.6.12
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         containers-0.5.5.1-d4bd887fb97aa3a46cbadc13709b7653
         hashable-1.2.2.0-6aae2a5ae00dba4cc06a8e388409e9ed
         syb-0.4.1-acd16ebc619c31f5db97bcd1e4196777
         unordered-containers-0.2.4.0-2fd558fbd599b4e4c335e82ebd45f621
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-uniplate-1.6.12/html/uniplate.haddock
haddock-html: /usr/local/share/doc/hs-uniplate-1.6.12/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
