#!/bin/sh
export PATH='/usr/obj/hs-skein-1.0.9.2/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: skein
version: 1.0.9.2
id: skein-1.0.9.2-3afc40612f1b486b5548f6e6d2cd1019

license: BSD3
copyright:
maintainer: Felipe Lessa <felipe.lessa@gmail.com>
stability:
homepage: https://github.com/meteficha/skein
package-url:
synopsis: Skein, a family of cryptographic hash functions.  Includes Skein-MAC as well.
description: Skein (<http://www.skein-hash.info/>) is a family of fast
             secure cryptographic hash functions designed by Niels
             Ferguson, Stefan Lucks, Bruce Schneier, Doug Whiting, Mihir
             Bellare, Tadayoshi Kohno, Jon Callas and Jesse Walker.
             .
             This package uses bindings to the optimized C implementation
             of Skein.  We provide a high-level interface (see module
             "Crypto.Skein") to some of the Skein use cases.  We also
             provide a low-level interface (see module
             "Crypto.Skein.Internal") should you need to use Skein in a
             different way.
             .
             Currently we have support for Skein as cryptographic hash
             function as Skein as a message authentication code
             (Skein-MAC).  For examples of how to use this package, see
             "Crypto.Skein" module documentation.
             .
             This package includes Skein v1.3. Versions of this package
             before 1.0.0 implemented Skein v1.1.
category: Cryptography
author: Felipe Lessa <felipe.lessa@gmail.com>, Doug Whiting
pkgpath: security/hs-skein
exposed: True
exposed-modules: Crypto.Skein Crypto.Skein.Internal
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/skein-1.0.9.2
library-dirs: /usr/local/lib/ghc/skein-1.0.9.2
hs-libraries: HSskein-1.0.9.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes: skein.h
depends: base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         bytestring-0.10.4.0-84f2b632cefc94e5dfeafb660607fcbd
         cereal-0.4.1.0-9d42a4c31bc1d35f6a410f5e79e67215
         crypto-api-0.13.2-bcd8d1b88ec2398781ed0f4d7c219c08
         tagged-0.7.3-4aece88b76fce3c636457239733a4dfa
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-skein-1.0.9.2/html/skein.haddock
haddock-html: /usr/local/share/doc/hs-skein-1.0.9.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
