#!/bin/sh
export PATH='/usr/obj/hs-semigroupoids-3.0.3/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: semigroupoids
version: 3.0.3
id: semigroupoids-3.0.3-44347410f4d2e384682a86563d8d847b

license: BSD3
copyright: Copyright (C) 2011 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/semigroupoids
package-url:
synopsis: Haskell 98 semigroupoids: Category sans id
description: Provides a wide array of semigroupoids and operations for working with semigroupds.
             .
             A Semigroupoid is a Category without the requirement of identity arrows for every object in the category.
             .
             When working with comonads you often have the @\<*\>@ portion of an @Applicative@, but
             not the @pure@. This was captured in Uustalu and Vene'\''s \"Essence of Dataflow Programming\"
             in the form of the @ComonadZip@ class in the days before @Applicative@. Apply provides a weaker invariant, but for the comonads used for data flow programming (found in the streams package), this invariant is preserved. Applicative function composition forms a semigroupoid.
             .
             Similarly many structures are nearly a comonad, but not quite, for instance lists provide a reasonable '\''extend'\'' operation in the form of '\''tails'\'', but do not always contain a value.
             .
             .
             Ideally the following relationships would hold:
             .
             > Traversable <---- Foldable <--- Functor ------> Alt ---------> Plus           Semigroupoid
             >      |               |            |                              |                  |
             >      v               v            v                              v                  v
             > Traversable1 <--- Foldable1     Apply --------> Applicative -> Alternative      Category
             >                                   |               |              |                  |
             >                                   v               v              v                  v
             >                                 Bind ---------> Monad -------> MonadPlus          Arrow
             >
             .
             Apply, Bind, and Extend (not shown) give rise the Static, Kleisli and Cokleisli semigroupoids respectively.
             .
             This lets us remove many of the restrictions from various monad transformers
             as in many cases the binding operation or @\<*\>@ operation does not require them.
             .
             Finally, to work with these weaker structures it is beneficial to have containers
             that can provide stronger guarantees about their contents, so versions of '\''Traversable'\''
             and '\''Foldable'\'' that can be folded with just a '\''Semigroup'\'' are added.
category: Control, Comonads
author: Edward A. Kmett
pkgpath: devel/hs-semigroupoids
exposed: True
exposed-modules: Data.Functor.Alt Data.Functor.Apply
                 Data.Functor.Bind Data.Functor.Bind.Trans Data.Functor.Plus
                 Data.Functor.Extend Data.Semigroup.Foldable
                 Data.Semigroup.Traversable Data.Semigroupoid Data.Semigroupoid.Dual
                 Data.Semigroupoid.Static Data.Traversable.Instances
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/semigroupoids-3.0.3
library-dirs: /usr/local/lib/ghc/semigroupoids-3.0.3
hs-libraries: HSsemigroupoids-3.0.3
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         comonad-3.0.3-dcede33554f6ab048deaad7c2ee73d0b
         containers-0.5.5.1-d4bd887fb97aa3a46cbadc13709b7653
         contravariant-0.2.0.2-0875bda444a5ab2d4c6717c4353027e9
         semigroups-0.9.2-b16628344074b289e81002ba4e83a723
         transformers-0.3.0.0-6458c21515cab7c1cf21e53141557a1c
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-semigroupoids-3.0.3/html/semigroupoids.haddock
haddock-html: /usr/local/share/doc/hs-semigroupoids-3.0.3/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
