#!/bin/sh
export PATH='/usr/obj/hs-hexpat-0.20.7/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: hexpat
version: 0.20.7
id: hexpat-0.20.7-eaafd9b50a7b6bbb5feb593b2302b9b3

license: BSD3
copyright: (c) 2009 Doug Beardsley <mightybyte@gmail.com>,
           (c) 2009-2012 Stephen Blackheath <http://blacksapphire.com/antispam/>,
           (c) 2009 Gregory Collins,
           (c) 2008 Evan Martin <martine@danga.com>,
           (c) 2009 Matthew Pocock <matthew.pocock@ncl.ac.uk>,
           (c) 2007-2009 Galois Inc.,
           (c) 2010 Kevin Jardine,
           (c) 2012 Simon Hengel
maintainer: Stephen Blackheath <hexpat2.stephen@blacksapphire.com>
stability: beta
homepage: http://haskell.org/haskellwiki/Hexpat/
package-url:
synopsis: XML parser/formatter based on expat
description: This package provides a general purpose Haskell XML library using Expat to
             do its parsing (<http://expat.sourceforge.net/> - a fast stream-oriented XML
             parser written in C).  It is extensible to any string type, with @String@,
             @ByteString@ and @Text@ provided out of the box.
             .
             Basic usage: Parsing a tree (/Tree/), formatting a tree (/Format/).
             Other features: Helpers for processing XML trees (/Proc/), trees annotated with
             XML source location (/Annotated/), extended XML trees with comments,
             processing instructions, etc (/Extended/), XML cursors (/Cursor/),
             SAX-style parse (/SAX/), and access to the low-level interface in case speed
             is paramount (/Internal.IO/).
             .
             The design goals are speed, speed, speed, interface simplicity and modularity.
             .
             For introduction and examples, see the /Text.XML.Expat.Tree/ module. For benchmarks,
             <http://haskell.org/haskellwiki/Hexpat/>
             .
             If you want to do interactive I\/O, an obvious option is to use lazy parsing
             with one of the lazy I\/O functions such as hGetContents.  However, this can be
             problematic in some applications because it doesn'\''t handle I\/O errors properly
             and can give no guarantee of timely resource cleanup. Because of the generalized
             list, Hexpat is designed to allow for chunked I/O, but as of this writing I haven'\''t
             done a nice integration with enumerator and friends.
             .
             /IO/ is filed under /Internal/ because it'\''s low-level and most users won'\''t want
             it.  The other /Internal/ modules are re-exported by /Annotated/, /Tree/ and /Extended/,
             so you won'\''t need to import them directly.
             .
             Credits to Iavor Diatchki and the @xml@ (XML.Light) package for /Proc/ and /Cursor/.
             Thanks to the many contributors.
             .
             ChangeLog: 0.15 changes intended to fix a (rare) \"error: a C finalizer called back into Haskell.\"
             that seemed only to happen only on ghc6.12.X; 0.15.1 Fix broken Annotated parse;
             0.16 switch from mtl to transformers; 0.17 fix mapNodeContainer & rename some things.;
             0.18 rename defaultEncoding to overrideEncoding. 0.18.3 formatG and indent were demanding list
             items more than once (inefficient in chunked processing); 0.19 add Extended.hs;
             0.19.1 fix a memory leak introduced in 0.19, delegate parsing to bound thread
             if unbound (see note above); 0.19.2 include expat source code so \'\''cabal install\'\'' just works
             on Linux, Mac and Windows (thanks Jacob Stanley); 0.19.3 fix misconfiguration of expat
             which broke entity parsing; 0.19.4 bump version constraint for text; 0.19.5 bump text
             to < 0.12 and fix text-0.10.0.1 breakage; 0.19.6 dependency breakage with List;
             0.19.7 ghc-7.2.1 compatibility; 0.19.8 fix space leak on lazy parse under ghc-7.2.1;
             0.19.9 fix formatting of > character + improve performance; 0.19.10 ghc-7.4.x compatibility;
             0.20.1 fix an unfortunate crash when used in parallel processing and greatly improve
             performance; 0.20.2 make parseSaxG lazier; 0.20.3 minor build issues; 0.20.4 remove
             dependency on extensible-exceptions; 0.20.5 bump text upper bound; 0.20.6 bump text again
             to include 1.1.x.x; 0.20.7 bump text again for 1.2.x.x.
category: XML
author: Stephen Blackheath [blackh] (the primary author),
        Doug Beardsley,
        Gregory Collins,
        Evan Martin (who started the project),
        Matthew Pocock [drdozer],
        Kevin Jardine,
        Jacob Stanley,
        Simon Hengel
pkgpath: textproc/hs-hexpat
exposed: True
exposed-modules: Text.XML.Expat.Annotated Text.XML.Expat.Cursor
                 Text.XML.Expat.Extended Text.XML.Expat.Format Text.XML.Expat.Proc
                 Text.XML.Expat.SAX Text.XML.Expat.Tree
                 Text.XML.Expat.Internal.DocumentClass Text.XML.Expat.Internal.IO
                 Text.XML.Expat.Internal.Namespaced
                 Text.XML.Expat.Internal.NodeClass Text.XML.Expat.Internal.Qualified
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/hexpat-0.20.7
library-dirs: /usr/local/lib/ghc/hexpat-0.20.7
hs-libraries: HShexpat-0.20.7
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: List-0.4.2-dafc255a564636161a8d4da1335fc0eb
         base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         bytestring-0.10.4.0-84f2b632cefc94e5dfeafb660607fcbd
         containers-0.5.5.1-d4bd887fb97aa3a46cbadc13709b7653
         deepseq-1.3.0.2-63a1ab91b7017a28bb5d04cb1b5d2d02
         text-1.1.0.0-72236c81391c0a9a303f37559690d8fe
         transformers-0.3.0.0-6458c21515cab7c1cf21e53141557a1c
         utf8-string-0.3.8-33d6cbdc649f1dd0048718c4b65b149b
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hexpat-0.20.7/html/hexpat.haddock
haddock-html: /usr/local/share/doc/hs-hexpat-0.20.7/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
