#!/bin/sh
export PATH='/usr/obj/hs-hedis-0.6.9/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: hedis
version: 0.6.9
id: hedis-0.6.9-33636bc02886d51665ba16aa37fd18c1

license: BSD3
copyright: Copyright (c) 2011 Falko Peters
maintainer: falko.peters@gmail.com
stability:
homepage: https://github.com/informatikr/hedis
package-url:
synopsis: Client library for the Redis datastore: supports full command set,
          pipelining.
description: Redis is an open source, advanced key-value store. It is often referred to
             as a data structure server since keys can contain strings, hashes, lists,
             sets and sorted sets. This library is a Haskell client for the Redis
             datastore. Compared to other Haskell client libraries it has some
             advantages:
             .
             [Complete Redis 2.6 command set:] All Redis commands
             (<http://redis.io/commands>) are available as haskell functions, except
             for the MONITOR and SYNC commands. Additionally, a low-level API is
             exposed that  makes it easy for the library user to implement further
             commands, such as new commands from an experimental Redis version.
             .
             [Automatic Optimal Pipelining:] Commands are pipelined
             (<http://redis.io/topics/pipelining>) as much as possible without any
             work by the user. See
             <http://informatikr.com/2012/redis-pipelining.html> for a
             technical explanation of automatic optimal pipelining.
             .
             [Enforced Pub\/Sub semantics:] When subscribed to the Redis Pub\/Sub server
             (<http://redis.io/topics/pubsub>), clients are not allowed to issue
             commands other than subscribing to or unsubscribing from channels. This
             library uses the type system to enforce the correct behavior.
             .
             [Connect via TCP or Unix Domain Socket:] TCP sockets are the default way to
             connect to a Redis server. For connections to a server on the same
             machine, Unix domain sockets offer higher performance than the standard
             TCP connection.
             .
             For detailed documentation, see the "Database.Redis" module.
             .
category: Database
author: Falko Peters
pkgpath: databases/hs-hedis
exposed: True
exposed-modules: Database.Redis
hidden-modules: Database.Redis.Core
                Database.Redis.ProtocolPipelining Database.Redis.Protocol
                Database.Redis.PubSub Database.Redis.Transactions
                Database.Redis.Types Database.Redis.Commands
                Database.Redis.ManualCommands
trusted: False
import-dirs: /usr/local/lib/ghc/hedis-0.6.9
library-dirs: /usr/local/lib/ghc/hedis-0.6.9
hs-libraries: HShedis-0.6.9
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: BoundedChan-1.0.1.0-7c13b077f753e63f351542607ae82b1a
         attoparsec-0.11.3.4-38aec4777d52d2286c472e3abb229554
         base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         bytestring-0.10.4.0-84f2b632cefc94e5dfeafb660607fcbd
         bytestring-lexing-0.5.0.2-e0ddfab5ce5b1112fbe50421dbc4f7c3
         mtl-2.1.3.1-96f1a7910a7553352339ed05fb61c269
         network-2.4.2.3-878f8bfcc369ed62265df39b168036b0
         resource-pool-0.2.1.1-78d895d0cd7a7e4744b7ec272c9afdd6
         time-1.4.2-311aa8e77a6af87dc3d662d572df62ec
         vector-0.10.9.1-1010d9fb05d5cbdd0bbbccafb8c8b174
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hedis-0.6.9/html/hedis.haddock
haddock-html: /usr/local/share/doc/hs-hedis-0.6.9/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
