#!/bin/sh
export PATH='/usr/obj/hs-hashed-storage-0.5.11/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: hashed-storage
version: 0.5.11
id: hashed-storage-0.5.11-7e0d82807dfbc1f287ee832916f9898d

license: BSD3
copyright: 2009 Petr Rockai <me@mornfall.net>
maintainer: Petr Rockai <me@mornfall.net>
stability:
homepage:
package-url:
synopsis: Hashed file storage support code.
description: Support code for reading and manipulating hashed file storage
             (where each file and directory is associated with a
             cryptographic hash, for corruption-resistant storage and fast
             comparisons).
             .
             The supported storage formats include darcs hashed pristine, a
             plain filesystem tree and an indexed plain tree (where the index
             maintains hashes of the plain files and directories).
category: System
author: Petr Rockai <me@mornfall.net>
pkgpath: devel/hs-hashed-storage
exposed: True
exposed-modules: Storage.Hashed Storage.Hashed.AnchoredPath
                 Storage.Hashed.Index Storage.Hashed.Monad Storage.Hashed.Tree
                 Storage.Hashed.Hash Storage.Hashed.Packed Storage.Hashed.Plain
                 Storage.Hashed.Darcs
hidden-modules: Bundled.Posix Bundled.SHA256 Storage.Hashed.Utils
trusted: False
import-dirs: /usr/local/lib/ghc/hashed-storage-0.5.11
library-dirs: /usr/local/lib/ghc/hashed-storage-0.5.11
hs-libraries: HShashed-storage-0.5.11
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         binary-0.7.1.0-c65c3b0b4e58d95c86bbb4173746e414
         bytestring-0.10.4.0-84f2b632cefc94e5dfeafb660607fcbd
         containers-0.5.5.1-d4bd887fb97aa3a46cbadc13709b7653
         dataenc-0.14.0.7-cc208cdbbf6d6638baf121bf4724c834
         directory-1.2.1.0-255ee2a4a618c74613f025ccc4ecc082
         extensible-exceptions-0.1.1.4-ff00541964e8b4f6fe7adae94cd5f3b4
         filepath-1.3.0.2-25a474a9272ae6260626ce0d70ad1cab
         mmap-0.5.8-e3694e95a2a1f57eeae0561fc9764411
         mtl-2.1.3.1-96f1a7910a7553352339ed05fb61c269
         zlib-0.5.4.1-1316d824fe5105ceae8d375318b681e9
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hashed-storage-0.5.11/html/hashed-storage.haddock
haddock-html: /usr/local/share/doc/hs-hashed-storage-0.5.11/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
