#!/bin/sh
export PATH='/usr/obj/hs-directory-tree-0.11.0/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: directory-tree
version: 0.11.0
id: directory-tree-0.11.0-42601ee133999c3b2605603822aa07a0

license: BSD3
copyright: (c) 2011, Brandon Simmons <brandon.m.simmons@gmail.com>
maintainer: Brandon Simmons <brandon.m.simmons@gmail.com>
stability:
homepage: http://brandon.si/code/directory-tree-module-released/
package-url:
synopsis: A simple directory-like tree datatype, with useful IO functions
description: A simple directory-like tree datatype, with useful IO functions and Foldable and Traversable instance
             .
             Provides a simple data structure mirroring a directory tree on the
             filesystem, as well as useful functions for reading and writing
             file and directory structures in the IO monad.
             .
             Importing the library and optional (useful) Foldable and Traverable libraries:
             .
             > import System.Directory.Tree
             > import qualified Data.Foldable as F
             > import qualified Data.Traversable as T
             .
             Write a hand-made directory tree of textfiles (strings) to the disk.
             Simulates creating a new user Tux'\''s home directory on a unix machine:
             .
             > writeDirectory$ "/home" :/ Dir "Tux" [File "README" "Welcome!"]
             .
             "read" a directory by opening all the files at a filepath with readFile,
             returning an '\''AnchoredDirTree String'\'' (d2). Then check for any IO failures:
             .
             > do (base :/ d2) <- readDirectory "../parent_dir/dir2/"
             >    let failed = anyFailed d2
             >    if failed then ...
             .
             Use Foldable instance function to concat a directory '\''dir'\'' of text files into a
             single file under the same directory:
             .
             > do (b :/ dt) <- readDirectory dir
             >    let f = F.concat dt
             >    return$ b :/ File "ALL_TEXT" f
             .
             Open all the files in the current directory as lazy bytestrings, ignoring
             the base path in Anchored wrapper:
             .
             > import qualified Data.ByteString.Lazy as B
             > do (_ :/ dTree) <- readDirectoryWith B.readFile "./"
             .
             This version also offers an experimental function `readDirectoryWithL` that does
             lazy directory IO, allowing you to treat the returned `DirTree` as if it were a
             normal lazily-generated data structure.
             .
             For example, the following does only the amount of IO necessary to list the file
             names of the children of the root directory, similar to "ls /":
             .
             > do d <- readDirectoryWithL readFile "/"
             >    mapM_ (putStrLn . name) $ contents $ free d
             .
             Any ideas or suggestions for improvements are most welcome :-)
             .
             /CHANGES/: from 0.10.1
             .
             - added records for AnchoredDirTree: '\''anchor'\'', '\''dirTree'\''
             .
             - '\''free'\'' deprecated in favor of '\''dirTree'\''
             .
             - added a new function '\''dropTo'\''
             .
             - implemented lenses compatible with "lens" package
             .
category: Data, System
author: Brandon Simmons
pkgpath: devel/hs-directory-tree
exposed: True
exposed-modules: System.Directory.Tree
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/directory-tree-0.11.0
library-dirs: /usr/local/lib/ghc/directory-tree-0.11.0
hs-libraries: HSdirectory-tree-0.11.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         directory-1.2.1.0-255ee2a4a618c74613f025ccc4ecc082
         filepath-1.3.0.2-25a474a9272ae6260626ce0d70ad1cab
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-directory-tree-0.11.0/html/directory-tree.haddock
haddock-html: /usr/local/share/doc/hs-directory-tree-0.11.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
