#!/bin/sh
export PATH='/usr/obj/hs-conduit-1.0.7.1/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: conduit
version: 1.0.7.1
id: conduit-1.0.7.1-c036caef9bed54ddcd3f358fcf93713e

license: MIT
copyright:
maintainer: michael@snoyman.com
stability:
homepage: http://github.com/snoyberg/conduit
package-url:
synopsis: Streaming data processing library.
description: @conduit@ is a solution to the streaming data problem, allowing for production, transformation, and consumption of streams of data in constant memory. It is an alternative to lazy I\/O which guarantees deterministic resource handling, and fits in the same general solution space as @enumerator@\/@iteratee@ and @pipes@. For a tutorial, please visit <https://haskell.fpcomplete.com/user/snoyberg/library-documentation/conduit-overview>.
             .
             Release history:
             .
             [1.0] Simplified the user-facing interface back to the Source, Sink, and Conduit types, with Producer and Consumer for generic code. Error messages have been simplified, and optional leftovers and upstream terminators have been removed from the external API. Some long-deprecated functions were finally removed.
             .
             [0.5] The internals of the package are now separated to the .Internal module, leaving only the higher-level interface in the advertised API. Internally, switched to a @Leftover@ constructor and slightly tweaked the finalization semantics.
             .
             [0.4] Inspired by the design of the pipes package: we now have a single unified type underlying @Source@, @Sink@, and @Conduit@. This type is named @Pipe@. There are type synonyms provided for the other three types. Additionally, @BufferedSource@ is no longer provided. Instead, the connect-and-resume operator, @$$+@, can be used for the same purpose.
             .
             [0.3] ResourceT has been greatly simplified, specialized for IO, and moved into a separate package. Instead of hard-coding ResourceT into the conduit datatypes, they can now live around any monad. The Conduit datatype has been enhanced to better allow generation of streaming output. The SourceResult, SinkResult, and ConduitResult datatypes have been removed entirely.
             .
             [0.2] Instead of storing state in mutable variables, we now use CPS. A @Source@ returns the next @Source@, and likewise for @Sink@s and @Conduit@s. Not only does this take better advantage of GHC\'\''s optimizations (about a 20% speedup), but it allows some operations to have a reduction in algorithmic complexity from exponential to linear. This also allowed us to remove the @Prepared@ set of types. Also, the @State@ functions (e.g., @sinkState@) use better constructors for return types, avoiding the need for a dummy state on completion.
             .
             [0.1] @BufferedSource@ is now an abstract type, and has a much more efficient internal representation. The result was a 41% speedup on microbenchmarks (note: do not expect speedups anywhere near that in real usage). In general, we are moving towards @BufferedSource@ being a specific tool used internally as needed, but using @Source@ for all external APIs.
             .
             [0.0] Initial release.
category: Data, Conduit
author: Michael Snoyman
pkgpath: devel/hs-conduit
exposed: True
exposed-modules: Data.Conduit Data.Conduit.Binary Data.Conduit.Text
                 Data.Conduit.List Data.Conduit.Lazy Data.Conduit.Internal
                 Data.Conduit.Util
hidden-modules: System.PosixFile
trusted: False
import-dirs: /usr/local/lib/ghc/conduit-1.0.7.1
library-dirs: /usr/local/lib/ghc/conduit-1.0.7.1
hs-libraries: HSconduit-1.0.7.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         bytestring-0.10.4.0-84f2b632cefc94e5dfeafb660607fcbd
         containers-0.5.5.1-d4bd887fb97aa3a46cbadc13709b7653
         directory-1.2.1.0-255ee2a4a618c74613f025ccc4ecc082
         lifted-base-0.2.0.5-bd183db465cb42aa58d400d62c406dfa
         mmorph-1.0.0-f0028473332137f20f253e36e349fcd5
         monad-control-0.3.2.3-00e9746047757fb9d75d5c7c5b946efb
         mtl-2.1.3.1-96f1a7910a7553352339ed05fb61c269
         resourcet-0.4.7.2-897f26390dd8b5885e83479a1662786a
         text-1.1.0.0-72236c81391c0a9a303f37559690d8fe
         transformers-0.3.0.0-6458c21515cab7c1cf21e53141557a1c
         transformers-base-0.4.1-37efec07d48ea648ba6fa660d35527d5
         void-0.6.1-7489160c5284d0f2a8bc3b636597bf26
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-conduit-1.0.7.1/html/conduit.haddock
haddock-html: /usr/local/share/doc/hs-conduit-1.0.7.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
