#!/bin/sh
export PATH='/usr/obj/hs-OpenGLRaw-1.5.0.0/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: OpenGLRaw
version: 1.5.0.0
id: OpenGLRaw-1.5.0.0-ecac437af724c8c90ed873a69fdf1787

license: BSD3
copyright:
maintainer: Sven Panne <svenpanne@gmail.com>, Jason Dagit <dagitj@gmail.com>
stability:
homepage: http://www.haskell.org/haskellwiki/Opengl
package-url:
synopsis: A raw binding for the OpenGL graphics system
description: OpenGLRaw is a raw Haskell binding for the OpenGL 3.2 graphics system and
             lots of OpenGL extensions. It is basically a 1:1 mapping of OpenGL'\''s C API,
             intended as a basis for a nicer interface. OpenGLRaw offers access to all
             necessary functions, tokens and types plus a general facility for loading
             extension entries. The module hierarchy closely mirrors the naming structure
             of the OpenGL extensions, making it easy to find the right module to import.
             All API entries are loaded dynamically, so no special C header files are
             needed for building this package. If an API entry is not found at runtime, a
             userError is thrown.
             .
             OpenGL is the industry'\''s most widely used and supported 2D and 3D graphics
             application programming interface (API), incorporating a broad set of
             rendering, texture mapping, special effects, and other powerful visualization
             functions. For more information about OpenGL and its various extensions,
             please see <http://www.opengl.org/>
             and <http://www.opengl.org/registry/>.
category: Graphics
author:
pkgpath: graphics/hs-OpenGLRaw
exposed: True
exposed-modules: Graphics.Rendering.OpenGL.Raw
                 Graphics.Rendering.OpenGL.Raw.APPLE
                 Graphics.Rendering.OpenGL.Raw.APPLE.FlushBufferRange
                 Graphics.Rendering.OpenGL.Raw.APPLE.VertexArrayObject
                 Graphics.Rendering.OpenGL.Raw.ARB
                 Graphics.Rendering.OpenGL.Raw.ARB.BlendFuncExtended
                 Graphics.Rendering.OpenGL.Raw.ARB.ColorBufferFloat
                 Graphics.Rendering.OpenGL.Raw.ARB.Compatibility
                 Graphics.Rendering.OpenGL.Raw.ARB.ComputeShader
                 Graphics.Rendering.OpenGL.Raw.ARB.CopyBuffer
                 Graphics.Rendering.OpenGL.Raw.ARB.CreateContextProfile
                 Graphics.Rendering.OpenGL.Raw.ARB.DepthBufferFloat
                 Graphics.Rendering.OpenGL.Raw.ARB.DepthClamp
                 Graphics.Rendering.OpenGL.Raw.ARB.DepthTexture
                 Graphics.Rendering.OpenGL.Raw.ARB.DrawBuffers
                 Graphics.Rendering.OpenGL.Raw.ARB.DrawBuffersBlend
                 Graphics.Rendering.OpenGL.Raw.ARB.DrawElementsBaseVertex
                 Graphics.Rendering.OpenGL.Raw.ARB.DrawIndirect
                 Graphics.Rendering.OpenGL.Raw.ARB.DrawInstanced
                 Graphics.Rendering.OpenGL.Raw.ARB.ES2Compatibility
                 Graphics.Rendering.OpenGL.Raw.ARB.ES3Compatibility
                 Graphics.Rendering.OpenGL.Raw.ARB.FragmentProgram
                 Graphics.Rendering.OpenGL.Raw.ARB.FragmentShader
                 Graphics.Rendering.OpenGL.Raw.ARB.FramebufferNoAttachments
                 Graphics.Rendering.OpenGL.Raw.ARB.FramebufferObject
                 Graphics.Rendering.OpenGL.Raw.ARB.FramebufferSRGB
                 Graphics.Rendering.OpenGL.Raw.ARB.GPUShader5
                 Graphics.Rendering.OpenGL.Raw.ARB.GPUShaderFP64
                 Graphics.Rendering.OpenGL.Raw.ARB.GeometryShader4
                 Graphics.Rendering.OpenGL.Raw.ARB.GetProgramBinary
                 Graphics.Rendering.OpenGL.Raw.ARB.HalfFloatPixel
                 Graphics.Rendering.OpenGL.Raw.ARB.HalfFloatVertex
                 Graphics.Rendering.OpenGL.Raw.ARB.InstancedArrays
                 Graphics.Rendering.OpenGL.Raw.ARB.MapBufferRange
                 Graphics.Rendering.OpenGL.Raw.ARB.MatrixPalette
                 Graphics.Rendering.OpenGL.Raw.ARB.Multisample
                 Graphics.Rendering.OpenGL.Raw.ARB.Multitexture
                 Graphics.Rendering.OpenGL.Raw.ARB.OcclusionQuery
                 Graphics.Rendering.OpenGL.Raw.ARB.OcclusionQuery2
                 Graphics.Rendering.OpenGL.Raw.ARB.PixelBufferObject
                 Graphics.Rendering.OpenGL.Raw.ARB.PointParameters
                 Graphics.Rendering.OpenGL.Raw.ARB.PointSprite
                 Graphics.Rendering.OpenGL.Raw.ARB.ProvokingVertex
                 Graphics.Rendering.OpenGL.Raw.ARB.QueryBufferObject
                 Graphics.Rendering.OpenGL.Raw.ARB.SampleShading
                 Graphics.Rendering.OpenGL.Raw.ARB.SamplerObjects
                 Graphics.Rendering.OpenGL.Raw.ARB.SeamlessCubeMap
                 Graphics.Rendering.OpenGL.Raw.ARB.SeparateShaderObjects
                 Graphics.Rendering.OpenGL.Raw.ARB.ShaderAtomicCounters
                 Graphics.Rendering.OpenGL.Raw.ARB.ShaderObjects
                 Graphics.Rendering.OpenGL.Raw.ARB.ShaderStorageBufferObject
                 Graphics.Rendering.OpenGL.Raw.ARB.ShaderSubroutine
                 Graphics.Rendering.OpenGL.Raw.ARB.ShadingLanguage100
                 Graphics.Rendering.OpenGL.Raw.ARB.ShadingLanguageInclude
                 Graphics.Rendering.OpenGL.Raw.ARB.Shadow
                 Graphics.Rendering.OpenGL.Raw.ARB.ShadowAmbient
                 Graphics.Rendering.OpenGL.Raw.ARB.Sync
                 Graphics.Rendering.OpenGL.Raw.ARB.TessellationShader
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureBorderClamp
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureBufferObject
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureCompression
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureCompressionBPTC
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureCompressionRGTC
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureCubeMap
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureCubeMapArray
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureEnvAdd
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureEnvCombine
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureEnvCrossbar
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureEnvDot3
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureFloat
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureGather
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureMirroredRepeat
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureMultisample
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureRG
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureRGB10A2UI
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureRectangle
                 Graphics.Rendering.OpenGL.Raw.ARB.TextureSwizzle
                 Graphics.Rendering.OpenGL.Raw.ARB.TimerQuery
                 Graphics.Rendering.OpenGL.Raw.ARB.TransformFeedback2
                 Graphics.Rendering.OpenGL.Raw.ARB.TransformFeedback3
                 Graphics.Rendering.OpenGL.Raw.ARB.TransposeMatrix
                 Graphics.Rendering.OpenGL.Raw.ARB.UniformBufferObject
                 Graphics.Rendering.OpenGL.Raw.ARB.VertexArrayObject
                 Graphics.Rendering.OpenGL.Raw.ARB.VertexAttrib64Bit
                 Graphics.Rendering.OpenGL.Raw.ARB.VertexBlend
                 Graphics.Rendering.OpenGL.Raw.ARB.VertexBufferObject
                 Graphics.Rendering.OpenGL.Raw.ARB.VertexProgram
                 Graphics.Rendering.OpenGL.Raw.ARB.VertexShader
                 Graphics.Rendering.OpenGL.Raw.ARB.VertexType2101010Rev
                 Graphics.Rendering.OpenGL.Raw.ARB.WindowPos
                 Graphics.Rendering.OpenGL.Raw.Core31
                 Graphics.Rendering.OpenGL.Raw.Core31.Types
                 Graphics.Rendering.OpenGL.Raw.Core32
                 Graphics.Rendering.OpenGL.Raw.EXT
                 Graphics.Rendering.OpenGL.Raw.EXT.ABGR
                 Graphics.Rendering.OpenGL.Raw.EXT.BGRA
                 Graphics.Rendering.OpenGL.Raw.EXT.BindableUniform
                 Graphics.Rendering.OpenGL.Raw.EXT.BlendColor
                 Graphics.Rendering.OpenGL.Raw.EXT.BlendEquationSeparate
                 Graphics.Rendering.OpenGL.Raw.EXT.BlendFuncSeparate
                 Graphics.Rendering.OpenGL.Raw.EXT.BlendMinmax
                 Graphics.Rendering.OpenGL.Raw.EXT.BlendSubtract
                 Graphics.Rendering.OpenGL.Raw.EXT.CMYKA
                 Graphics.Rendering.OpenGL.Raw.EXT.ClipVolumeHint
                 Graphics.Rendering.OpenGL.Raw.EXT.ColorSubtable
                 Graphics.Rendering.OpenGL.Raw.EXT.CompiledVertexArray
                 Graphics.Rendering.OpenGL.Raw.EXT.Convolution
                 Graphics.Rendering.OpenGL.Raw.EXT.CoordinateFrame
                 Graphics.Rendering.OpenGL.Raw.EXT.CopyTexture
                 Graphics.Rendering.OpenGL.Raw.EXT.CullVertex
                 Graphics.Rendering.OpenGL.Raw.EXT.DepthBoundsTest
                 Graphics.Rendering.OpenGL.Raw.EXT.DirectStateAccess
                 Graphics.Rendering.OpenGL.Raw.EXT.DrawBuffers2
                 Graphics.Rendering.OpenGL.Raw.EXT.DrawRangeElements
                 Graphics.Rendering.OpenGL.Raw.EXT.FogCoord
                 Graphics.Rendering.OpenGL.Raw.EXT.FourTwoTwoPixels
                 Graphics.Rendering.OpenGL.Raw.EXT.FragmentLighting
                 Graphics.Rendering.OpenGL.Raw.EXT.FramebufferBlit
                 Graphics.Rendering.OpenGL.Raw.EXT.FramebufferMultisample
                 Graphics.Rendering.OpenGL.Raw.EXT.FramebufferObject
                 Graphics.Rendering.OpenGL.Raw.EXT.FramebufferSRGB
                 Graphics.Rendering.OpenGL.Raw.EXT.GPUProgramParameters
                 Graphics.Rendering.OpenGL.Raw.EXT.GPUShader4
                 Graphics.Rendering.OpenGL.Raw.EXT.GeometryShader4
                 Graphics.Rendering.OpenGL.Raw.EXT.Histogram
                 Graphics.Rendering.OpenGL.Raw.EXT.IndexArrayFormats
                 Graphics.Rendering.OpenGL.Raw.EXT.IndexFunc
                 Graphics.Rendering.OpenGL.Raw.EXT.IndexMaterial
                 Graphics.Rendering.OpenGL.Raw.EXT.LightTexture
                 Graphics.Rendering.OpenGL.Raw.EXT.MultiDrawArrays
                 Graphics.Rendering.OpenGL.Raw.EXT.Multisample
                 Graphics.Rendering.OpenGL.Raw.EXT.PackedDepthStencil
                 Graphics.Rendering.OpenGL.Raw.EXT.PackedFloat
                 Graphics.Rendering.OpenGL.Raw.EXT.PackedPixels
                 Graphics.Rendering.OpenGL.Raw.EXT.PalettedTexture
                 Graphics.Rendering.OpenGL.Raw.EXT.PixelTransform
                 Graphics.Rendering.OpenGL.Raw.EXT.PointParameters
                 Graphics.Rendering.OpenGL.Raw.EXT.PolygonOffset
                 Graphics.Rendering.OpenGL.Raw.EXT.ProvokingVertex
                 Graphics.Rendering.OpenGL.Raw.EXT.RescaleNormal
                 Graphics.Rendering.OpenGL.Raw.EXT.SceneMarker
                 Graphics.Rendering.OpenGL.Raw.EXT.SecondaryColor
                 Graphics.Rendering.OpenGL.Raw.EXT.SeparateSpecularColor
                 Graphics.Rendering.OpenGL.Raw.EXT.SharedTexturePalette
                 Graphics.Rendering.OpenGL.Raw.EXT.StencilClearTag
                 Graphics.Rendering.OpenGL.Raw.EXT.StencilTwoSide
                 Graphics.Rendering.OpenGL.Raw.EXT.StencilWrap
                 Graphics.Rendering.OpenGL.Raw.EXT.Subtexture
                 Graphics.Rendering.OpenGL.Raw.EXT.Texture
                 Graphics.Rendering.OpenGL.Raw.EXT.Texture3D
                 Graphics.Rendering.OpenGL.Raw.EXT.TextureArray
                 Graphics.Rendering.OpenGL.Raw.EXT.TextureCompressionDXT1
                 Graphics.Rendering.OpenGL.Raw.EXT.TextureCompressionLATC
                 Graphics.Rendering.OpenGL.Raw.EXT.TextureCompressionRGTC
                 Graphics.Rendering.OpenGL.Raw.EXT.TextureCompressionS3TC
                 Graphics.Rendering.OpenGL.Raw.EXT.TextureEnvAdd
                 Graphics.Rendering.OpenGL.Raw.EXT.TextureEnvCombine
                 Graphics.Rendering.OpenGL.Raw.EXT.TextureEnvDot3
                 Graphics.Rendering.OpenGL.Raw.EXT.TextureFilterAnisotropic
                 Graphics.Rendering.OpenGL.Raw.EXT.TextureInteger
                 Graphics.Rendering.OpenGL.Raw.EXT.TextureLODBias
                 Graphics.Rendering.OpenGL.Raw.EXT.TextureMirrorClamp
                 Graphics.Rendering.OpenGL.Raw.EXT.TextureObject
                 Graphics.Rendering.OpenGL.Raw.EXT.TexturePerturbNormal
                 Graphics.Rendering.OpenGL.Raw.EXT.TextureSRGB
                 Graphics.Rendering.OpenGL.Raw.EXT.TextureSharedExponent
                 Graphics.Rendering.OpenGL.Raw.EXT.TextureSwizzle
                 Graphics.Rendering.OpenGL.Raw.EXT.TimerQuery
                 Graphics.Rendering.OpenGL.Raw.EXT.TransformFeedback
                 Graphics.Rendering.OpenGL.Raw.EXT.VertexArray
                 Graphics.Rendering.OpenGL.Raw.EXT.VertexShader
                 Graphics.Rendering.OpenGL.Raw.EXT.VertexWeighting
                 Graphics.Rendering.OpenGL.Raw.GetProcAddress
                 Graphics.Rendering.OpenGL.Raw.NV
                 Graphics.Rendering.OpenGL.Raw.NV.ConditionalRender
                 Graphics.Rendering.OpenGL.Raw.NV.CopyDepthToColor
                 Graphics.Rendering.OpenGL.Raw.NV.DepthBufferFloat
                 Graphics.Rendering.OpenGL.Raw.NV.DepthClamp
                 Graphics.Rendering.OpenGL.Raw.NV.ExplicitMultisample
                 Graphics.Rendering.OpenGL.Raw.NV.Fence
                 Graphics.Rendering.OpenGL.Raw.NV.FloatBuffer
                 Graphics.Rendering.OpenGL.Raw.NV.FogDistance
                 Graphics.Rendering.OpenGL.Raw.NV.FragmentProgram
                 Graphics.Rendering.OpenGL.Raw.NV.FragmentProgram2
                 Graphics.Rendering.OpenGL.Raw.NV.FramebufferMultisampleCoverage
                 Graphics.Rendering.OpenGL.Raw.NV.GPUProgram4
                 Graphics.Rendering.OpenGL.Raw.NV.GeometryProgram4
                 Graphics.Rendering.OpenGL.Raw.NV.HalfFloat
                 Graphics.Rendering.OpenGL.Raw.NV.LightMaxExponent
                 Graphics.Rendering.OpenGL.Raw.NV.MultisampleFilterHint
                 Graphics.Rendering.OpenGL.Raw.NV.OcclusionQuery
                 Graphics.Rendering.OpenGL.Raw.NV.PackedDepthStencil
                 Graphics.Rendering.OpenGL.Raw.NV.ParameterBufferObject
                 Graphics.Rendering.OpenGL.Raw.NV.PathRendering
                 Graphics.Rendering.OpenGL.Raw.NV.PixelDataRange
                 Graphics.Rendering.OpenGL.Raw.NV.PointSprite
                 Graphics.Rendering.OpenGL.Raw.NV.PresentVideo
                 Graphics.Rendering.OpenGL.Raw.NV.PrimitiveRestart
                 Graphics.Rendering.OpenGL.Raw.NV.RegisterCombiners
                 Graphics.Rendering.OpenGL.Raw.NV.RegisterCombiners2
                 Graphics.Rendering.OpenGL.Raw.NV.TexgenEmboss
                 Graphics.Rendering.OpenGL.Raw.NV.TexgenReflection
                 Graphics.Rendering.OpenGL.Raw.NV.TextureCompressionVTC
                 Graphics.Rendering.OpenGL.Raw.NV.TextureEnvCombine4
                 Graphics.Rendering.OpenGL.Raw.NV.TextureExpandNormal
                 Graphics.Rendering.OpenGL.Raw.NV.TextureRectangle
                 Graphics.Rendering.OpenGL.Raw.NV.TextureShader
                 Graphics.Rendering.OpenGL.Raw.NV.TextureShader2
                 Graphics.Rendering.OpenGL.Raw.NV.TextureShader3
                 Graphics.Rendering.OpenGL.Raw.NV.TransformFeedback
                 Graphics.Rendering.OpenGL.Raw.NV.TransformFeedback2
                 Graphics.Rendering.OpenGL.Raw.NV.VertexArrayRange
                 Graphics.Rendering.OpenGL.Raw.NV.VertexArrayRange2
                 Graphics.Rendering.OpenGL.Raw.NV.VertexProgram
                 Graphics.Rendering.OpenGL.Raw.NV.VertexProgram2Option
                 Graphics.Rendering.OpenGL.Raw.NV.VertexProgram3
                 Graphics.Rendering.OpenGL.Raw.NV.VertexProgram4
                 Graphics.Rendering.OpenGL.Raw.Types
hidden-modules: Graphics.Rendering.OpenGL.Raw.ARB.Compatibility.Functions
                Graphics.Rendering.OpenGL.Raw.ARB.Compatibility.Tokens
                Graphics.Rendering.OpenGL.Raw.Core31.Functions
                Graphics.Rendering.OpenGL.Raw.Core31.Tokens
                Graphics.Rendering.OpenGL.Raw.Extensions
trusted: False
import-dirs: /usr/local/lib/ghc/OpenGLRaw-1.5.0.0
library-dirs: /usr/local/lib/ghc/OpenGLRaw-1.5.0.0 /usr/X11R6/lib
hs-libraries: HSOpenGLRaw-1.5.0.0
extra-libraries: GL
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         ghc-prim-0.3.1.0-a24f9c14c632d75b683d0f93283aea37
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-OpenGLRaw-1.5.0.0/html/OpenGLRaw.haddock
haddock-html: /usr/local/share/doc/hs-OpenGLRaw-1.5.0.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
