/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.ContinuationPending;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeContinuation;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.VMBridge;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;
import org.mozilla.javascript.xml.XMLLib;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    public static final int VERSION_UNKNOWN = -1;
    public static final int VERSION_DEFAULT = 0;
    public static final int VERSION_1_0 = 100;
    public static final int VERSION_1_1 = 110;
    public static final int VERSION_1_2 = 120;
    public static final int VERSION_1_3 = 130;
    public static final int VERSION_1_4 = 140;
    public static final int VERSION_1_5 = 150;
    public static final int VERSION_1_6 = 160;
    public static final int VERSION_1_7 = 170;
    public static final int FEATURE_NON_ECMA_GET_YEAR = 1;
    public static final int FEATURE_MEMBER_EXPR_AS_FUNCTION_NAME = 2;
    public static final int FEATURE_RESERVED_KEYWORD_AS_IDENTIFIER = 3;
    public static final int FEATURE_TO_STRING_AS_SOURCE = 4;
    public static final int FEATURE_PARENT_PROTO_PROPERTIES = 5;
    public static final int FEATURE_PARENT_PROTO_PROPRTIES = 5;
    public static final int FEATURE_E4X = 6;
    public static final int FEATURE_DYNAMIC_SCOPE = 7;
    public static final int FEATURE_STRICT_VARS = 8;
    public static final int FEATURE_STRICT_EVAL = 9;
    public static final int FEATURE_LOCATION_INFORMATION_IN_ERROR = 10;
    public static final int FEATURE_STRICT_MODE = 11;
    public static final int FEATURE_WARNING_AS_ERROR = 12;
    public static final int FEATURE_ENHANCED_JAVA_ACCESS = 13;
    public static final String languageVersionProperty = "language version";
    public static final String errorReporterProperty = "error reporter";
    public static final Object[] emptyArgs = ScriptRuntime.emptyArgs;
    private static Class<?> codegenClass = Kit.classOrNull("org.mozilla.javascript.optimizer.Codegen");
    private static Class<?> interpreterClass = Kit.classOrNull("org.mozilla.javascript.Interpreter");
    private static String implementationVersion;
    private final ContextFactory factory;
    private boolean sealed;
    private Object sealKey;
    Scriptable topCallScope;
    boolean isContinuationsTopCall;
    NativeCall currentActivationCall;
    XMLLib cachedXMLLib;
    ObjToIntMap iterating;
    Object interpreterSecurityDomain;
    int version;
    private SecurityController securityController;
    private ClassShutter classShutter;
    private ErrorReporter errorReporter;
    RegExpProxy regExpProxy;
    private Locale locale;
    private boolean generatingDebug;
    private boolean generatingDebugChanged;
    private boolean generatingSource = true;
    boolean compileFunctionsWithDynamicScopeFlag;
    boolean useDynamicScope;
    private int optimizationLevel;
    private int maximumInterpreterStackDepth;
    private WrapFactory wrapFactory;
    Debugger debugger;
    private Object debuggerData;
    private int enterCount;
    private Object propertyListeners;
    private Map<Object, Object> threadLocalMap;
    private ClassLoader applicationClassLoader;
    Set<String> activationNames;
    Object lastInterpreterFrame;
    ObjArray previousInterpreterInvocations;
    int instructionCount;
    int instructionThreshold;
    int scratchIndex;
    long scratchUint32;
    Scriptable scratchScriptable;
    public boolean generateObserverCount = false;

    public Context() {
        this(ContextFactory.getGlobal());
    }

    protected Context(ContextFactory contextFactory) {
        if (contextFactory == null) {
            throw new IllegalArgumentException("factory == null");
        }
        this.factory = contextFactory;
        this.setLanguageVersion(0);
        this.optimizationLevel = codegenClass != null ? 0 : -1;
        this.maximumInterpreterStackDepth = Integer.MAX_VALUE;
    }

    public static Context getCurrentContext() {
        Object object = VMBridge.instance.getThreadContextHelper();
        return VMBridge.instance.getContext(object);
    }

    public static Context enter() {
        return Context.enter(null);
    }

    public static Context enter(Context context) {
        return Context.enter(context, ContextFactory.getGlobal());
    }

    static final Context enter(Context context, ContextFactory contextFactory) {
        Object object = VMBridge.instance.getThreadContextHelper();
        Context context2 = VMBridge.instance.getContext(object);
        if (context2 != null) {
            context = context2;
        } else {
            if (context == null) {
                context = contextFactory.makeContext();
                if (context.enterCount != 0) {
                    throw new IllegalStateException("factory.makeContext() returned Context instance already associated with some thread");
                }
                contextFactory.onContextCreated(context);
                if (contextFactory.isSealed() && !context.isSealed()) {
                    context.seal(null);
                }
            } else if (context.enterCount != 0) {
                throw new IllegalStateException("can not use Context instance already associated with some thread");
            }
            VMBridge.instance.setContext(object, context);
        }
        ++context.enterCount;
        return context;
    }

    public static void exit() {
        Object object = VMBridge.instance.getThreadContextHelper();
        Context context = VMBridge.instance.getContext(object);
        if (context == null) {
            throw new IllegalStateException("Calling Context.exit without previous Context.enter");
        }
        if (context.enterCount < 1) {
            Kit.codeBug();
        }
        if (--context.enterCount == 0) {
            VMBridge.instance.setContext(object, null);
            context.factory.onContextReleased(context);
        }
    }

    public static Object call(ContextAction contextAction) {
        return Context.call(ContextFactory.getGlobal(), contextAction);
    }

    public static Object call(ContextFactory contextFactory, final Callable callable, final Scriptable scriptable, final Scriptable scriptable2, final Object[] objectArray) {
        if (contextFactory == null) {
            contextFactory = ContextFactory.getGlobal();
        }
        return Context.call(contextFactory, new ContextAction(){

            public Object run(Context context) {
                return callable.call(context, scriptable, scriptable2, objectArray);
            }
        });
    }

    static Object call(ContextFactory contextFactory, ContextAction contextAction) {
        Context context = Context.enter(null, contextFactory);
        try {
            Object object = contextAction.run(context);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    public static void addContextListener(ContextListener contextListener) {
        String string = "org.mozilla.javascript.tools.debugger.Main";
        if (string.equals(contextListener.getClass().getName())) {
            Class<?> clazz = contextListener.getClass();
            Class<?> clazz2 = Kit.classOrNull("org.mozilla.javascript.ContextFactory");
            Class[] classArray = new Class[]{clazz2};
            Object[] objectArray = new Object[]{ContextFactory.getGlobal()};
            try {
                Method method = clazz.getMethod("attachTo", classArray);
                method.invoke((Object)contextListener, objectArray);
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException();
                Kit.initCause(runtimeException, exception);
                throw runtimeException;
            }
            return;
        }
        ContextFactory.getGlobal().addListener(contextListener);
    }

    public static void removeContextListener(ContextListener contextListener) {
        ContextFactory.getGlobal().addListener(contextListener);
    }

    public final ContextFactory getFactory() {
        return this.factory;
    }

    public final boolean isSealed() {
        return this.sealed;
    }

    public final void seal(Object object) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.sealed = true;
        this.sealKey = object;
    }

    public final void unseal(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (this.sealKey != object) {
            throw new IllegalArgumentException();
        }
        if (!this.sealed) {
            throw new IllegalStateException();
        }
        this.sealed = false;
        this.sealKey = null;
    }

    static void onSealedMutation() {
        throw new IllegalStateException();
    }

    public final int getLanguageVersion() {
        return this.version;
    }

    public void setLanguageVersion(int n) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        Context.checkLanguageVersion(n);
        Object object = this.propertyListeners;
        if (object != null && n != this.version) {
            this.firePropertyChangeImpl(object, languageVersionProperty, new Integer(this.version), new Integer(n));
        }
        this.version = n;
    }

    public static boolean isValidLanguageVersion(int n) {
        switch (n) {
            case 0: 
            case 100: 
            case 110: 
            case 120: 
            case 130: 
            case 140: 
            case 150: 
            case 160: 
            case 170: {
                return true;
            }
        }
        return false;
    }

    public static void checkLanguageVersion(int n) {
        if (Context.isValidLanguageVersion(n)) {
            return;
        }
        throw new IllegalArgumentException("Bad language version: " + n);
    }

    public final String getImplementationVersion() {
        if (implementationVersion == null) {
            implementationVersion = ScriptRuntime.getMessage0("implementation.version");
        }
        return implementationVersion;
    }

    public final ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            return DefaultErrorReporter.instance;
        }
        return this.errorReporter;
    }

    public final ErrorReporter setErrorReporter(ErrorReporter errorReporter) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException();
        }
        ErrorReporter errorReporter2 = this.getErrorReporter();
        if (errorReporter == errorReporter2) {
            return errorReporter2;
        }
        Object object = this.propertyListeners;
        if (object != null) {
            this.firePropertyChangeImpl(object, errorReporterProperty, errorReporter2, errorReporter);
        }
        this.errorReporter = errorReporter;
        return errorReporter2;
    }

    public final Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public final Locale setLocale(Locale locale) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        Locale locale2 = this.locale;
        this.locale = locale;
        return locale2;
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.propertyListeners = Kit.addListener(this.propertyListeners, propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.propertyListeners = Kit.removeListener(this.propertyListeners, propertyChangeListener);
    }

    final void firePropertyChange(String string, Object object, Object object2) {
        Object object3 = this.propertyListeners;
        if (object3 != null) {
            this.firePropertyChangeImpl(object3, string, object, object2);
        }
    }

    private void firePropertyChangeImpl(Object object, String string, Object object2, Object object3) {
        Object object4;
        int n = 0;
        while ((object4 = Kit.getListener(object, n)) != null) {
            if (object4 instanceof PropertyChangeListener) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)object4;
                propertyChangeListener.propertyChange(new PropertyChangeEvent(this, string, object2, object3));
            }
            ++n;
        }
    }

    public static void reportWarning(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getContext();
        if (context.hasFeature(12)) {
            Context.reportError(string, string2, n, string3, n2);
        } else {
            context.getErrorReporter().warning(string, string2, n, string3, n2);
        }
    }

    public static void reportWarning(String string) {
        int[] nArray = new int[1];
        String string2 = Context.getSourcePositionFromStack(nArray);
        Context.reportWarning(string, string2, nArray[0], null, 0);
    }

    public static void reportWarning(String string, Throwable throwable) {
        int[] nArray = new int[1];
        String string2 = Context.getSourcePositionFromStack(nArray);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(string);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        Context.reportWarning(((Object)stringWriter).toString(), string2, nArray[0], null, 0);
    }

    public static void reportError(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getCurrentContext();
        if (context == null) {
            throw new EvaluatorException(string, string2, n, string3, n2);
        }
        context.getErrorReporter().error(string, string2, n, string3, n2);
    }

    public static void reportError(String string) {
        int[] nArray = new int[1];
        String string2 = Context.getSourcePositionFromStack(nArray);
        Context.reportError(string, string2, nArray[0], null, 0);
    }

    public static EvaluatorException reportRuntimeError(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getCurrentContext();
        if (context != null) {
            return context.getErrorReporter().runtimeError(string, string2, n, string3, n2);
        }
        throw new EvaluatorException(string, string2, n, string3, n2);
    }

    static EvaluatorException reportRuntimeError0(String string) {
        String string2 = ScriptRuntime.getMessage0(string);
        return Context.reportRuntimeError(string2);
    }

    static EvaluatorException reportRuntimeError1(String string, Object object) {
        String string2 = ScriptRuntime.getMessage1(string, object);
        return Context.reportRuntimeError(string2);
    }

    static EvaluatorException reportRuntimeError2(String string, Object object, Object object2) {
        String string2 = ScriptRuntime.getMessage2(string, object, object2);
        return Context.reportRuntimeError(string2);
    }

    static EvaluatorException reportRuntimeError3(String string, Object object, Object object2, Object object3) {
        String string2 = ScriptRuntime.getMessage3(string, object, object2, object3);
        return Context.reportRuntimeError(string2);
    }

    static EvaluatorException reportRuntimeError4(String string, Object object, Object object2, Object object3, Object object4) {
        String string2 = ScriptRuntime.getMessage4(string, object, object2, object3, object4);
        return Context.reportRuntimeError(string2);
    }

    public static EvaluatorException reportRuntimeError(String string) {
        int[] nArray = new int[1];
        String string2 = Context.getSourcePositionFromStack(nArray);
        return Context.reportRuntimeError(string, string2, nArray[0], null, 0);
    }

    public final ScriptableObject initStandardObjects() {
        return this.initStandardObjects(null, false);
    }

    public final Scriptable initStandardObjects(ScriptableObject scriptableObject) {
        return this.initStandardObjects(scriptableObject, false);
    }

    public ScriptableObject initStandardObjects(ScriptableObject scriptableObject, boolean bl) {
        return ScriptRuntime.initStandardObjects(this, scriptableObject, bl);
    }

    public static Object getUndefinedValue() {
        return Undefined.instance;
    }

    public final Object evaluateString(Scriptable scriptable, String string, String string2, int n, Object object) {
        Script script = this.compileString(string, string2, n, object);
        if (script != null) {
            return script.exec(this, scriptable);
        }
        return null;
    }

    public final Object evaluateReader(Scriptable scriptable, Reader reader, String string, int n, Object object) throws IOException {
        Script script = this.compileReader(scriptable, reader, string, n, object);
        if (script != null) {
            return script.exec(this, scriptable);
        }
        return null;
    }

    public Object executeScriptWithContinuations(Script script, Scriptable scriptable) throws ContinuationPending {
        if (!(script instanceof InterpretedFunction) || !((InterpretedFunction)script).isScript()) {
            throw new IllegalArgumentException("Script argument was not a script or was not created by interpreted mode ");
        }
        return this.callFunctionWithContinuations((InterpretedFunction)script, scriptable, ScriptRuntime.emptyArgs);
    }

    public Object callFunctionWithContinuations(Callable callable, Scriptable scriptable, Object[] objectArray) throws ContinuationPending {
        if (!(callable instanceof InterpretedFunction)) {
            throw new IllegalArgumentException("Function argument was not created by interpreted mode ");
        }
        if (ScriptRuntime.hasTopCall(this)) {
            throw new IllegalStateException("Cannot have any pending top calls when executing a script with continuations");
        }
        this.isContinuationsTopCall = true;
        return ScriptRuntime.doTopCall(callable, this, scriptable, scriptable, objectArray);
    }

    public ContinuationPending captureContinuation() {
        return new ContinuationPending(Interpreter.captureContinuation(this));
    }

    public Object resumeContinuation(Object object, Scriptable scriptable, Object object2) throws ContinuationPending {
        Object[] objectArray = new Object[]{object2};
        return Interpreter.restartContinuation((NativeContinuation)object, this, scriptable, objectArray);
    }

    public final boolean stringIsCompilableUnit(String string) {
        boolean bl = false;
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.initFromContext(this);
        compilerEnvirons.setGeneratingSource(false);
        Parser parser = new Parser(compilerEnvirons, DefaultErrorReporter.instance);
        try {
            parser.parse(string, null, 1);
        }
        catch (EvaluatorException evaluatorException) {
            bl = true;
        }
        return !bl || !parser.eof();
    }

    public final Script compileReader(Scriptable scriptable, Reader reader, String string, int n, Object object) throws IOException {
        return this.compileReader(reader, string, n, object);
    }

    public final Script compileReader(Reader reader, String string, int n, Object object) throws IOException {
        if (n < 0) {
            n = 0;
        }
        return (Script)this.compileImpl(null, reader, null, string, n, object, false, null, null);
    }

    public final Script compileString(String string, String string2, int n, Object object) {
        if (n < 0) {
            n = 0;
        }
        return this.compileString(string, null, null, string2, n, object);
    }

    final Script compileString(String string, Evaluator evaluator, ErrorReporter errorReporter, String string2, int n, Object object) {
        try {
            return (Script)this.compileImpl(null, null, string, string2, n, object, false, evaluator, errorReporter);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public final Function compileFunction(Scriptable scriptable, String string, String string2, int n, Object object) {
        return this.compileFunction(scriptable, string, null, null, string2, n, object);
    }

    final Function compileFunction(Scriptable scriptable, String string, Evaluator evaluator, ErrorReporter errorReporter, String string2, int n, Object object) {
        try {
            return (Function)this.compileImpl(scriptable, null, string, string2, n, object, true, evaluator, errorReporter);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public final String decompileScript(Script script, int n) {
        NativeFunction nativeFunction = (NativeFunction)((Object)script);
        return nativeFunction.decompile(n, 0);
    }

    public final String decompileFunction(Function function, int n) {
        if (function instanceof BaseFunction) {
            return ((BaseFunction)function).decompile(n, 0);
        }
        return "function " + function.getClassName() + "() {\n\t[native code]\n}\n";
    }

    public final String decompileFunctionBody(Function function, int n) {
        if (function instanceof BaseFunction) {
            BaseFunction baseFunction = (BaseFunction)function;
            return baseFunction.decompile(n, 1);
        }
        return "[native code]\n";
    }

    public final Scriptable newObject(Scriptable scriptable) {
        return this.newObject(scriptable, "Object", ScriptRuntime.emptyArgs);
    }

    public final Scriptable newObject(Scriptable scriptable, String string) {
        return this.newObject(scriptable, string, ScriptRuntime.emptyArgs);
    }

    public final Scriptable newObject(Scriptable scriptable, String string, Object[] objectArray) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Function function = ScriptRuntime.getExistingCtor(this, scriptable, string);
        if (objectArray == null) {
            objectArray = ScriptRuntime.emptyArgs;
        }
        return function.construct(this, scriptable, objectArray);
    }

    public final Scriptable newArray(Scriptable scriptable, int n) {
        NativeArray nativeArray = new NativeArray(n);
        ScriptRuntime.setObjectProtoAndParent(nativeArray, scriptable);
        return nativeArray;
    }

    public final Scriptable newArray(Scriptable scriptable, Object[] objectArray) {
        if (objectArray.getClass().getComponentType() != ScriptRuntime.ObjectClass) {
            throw new IllegalArgumentException();
        }
        NativeArray nativeArray = new NativeArray(objectArray);
        ScriptRuntime.setObjectProtoAndParent(nativeArray, scriptable);
        return nativeArray;
    }

    public final Object[] getElements(Scriptable scriptable) {
        return ScriptRuntime.getArrayElements(scriptable);
    }

    public static boolean toBoolean(Object object) {
        return ScriptRuntime.toBoolean(object);
    }

    public static double toNumber(Object object) {
        return ScriptRuntime.toNumber(object);
    }

    public static String toString(Object object) {
        return ScriptRuntime.toString(object);
    }

    public static Scriptable toObject(Object object, Scriptable scriptable) {
        return ScriptRuntime.toObject(scriptable, object);
    }

    public static Scriptable toObject(Object object, Scriptable scriptable, Class<?> clazz) {
        return ScriptRuntime.toObject(scriptable, object);
    }

    public static Object javaToJS(Object object, Scriptable scriptable) {
        if (object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Scriptable) {
            return object;
        }
        if (object instanceof Character) {
            return String.valueOf(((Character)object).charValue());
        }
        Context context = Context.getContext();
        return context.getWrapFactory().wrap(context, scriptable, object, null);
    }

    public static Object jsToJava(Object object, Class<?> clazz) throws EvaluatorException {
        return NativeJavaObject.coerceTypeImpl(clazz, object);
    }

    public static Object toType(Object object, Class<?> clazz) throws IllegalArgumentException {
        try {
            return Context.jsToJava(object, clazz);
        }
        catch (EvaluatorException evaluatorException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(evaluatorException.getMessage());
            Kit.initCause(illegalArgumentException, evaluatorException);
            throw illegalArgumentException;
        }
    }

    public static RuntimeException throwAsScriptRuntimeEx(Throwable throwable) {
        Context context;
        while (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable instanceof Error && ((context = Context.getContext()) == null || !context.hasFeature(13))) {
            throw (Error)throwable;
        }
        if (throwable instanceof RhinoException) {
            throw (RhinoException)throwable;
        }
        throw new WrappedException(throwable);
    }

    public final boolean isGeneratingDebug() {
        return this.generatingDebug;
    }

    public final void setGeneratingDebug(boolean bl) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.generatingDebugChanged = true;
        if (bl && this.getOptimizationLevel() > 0) {
            this.setOptimizationLevel(0);
        }
        this.generatingDebug = bl;
    }

    public final boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public final void setGeneratingSource(boolean bl) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.generatingSource = bl;
    }

    public final int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public final void setOptimizationLevel(int n) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (n == -2) {
            n = -1;
        }
        Context.checkOptimizationLevel(n);
        if (codegenClass == null) {
            n = -1;
        }
        this.optimizationLevel = n;
    }

    public static boolean isValidOptimizationLevel(int n) {
        return -1 <= n && n <= 9;
    }

    public static void checkOptimizationLevel(int n) {
        if (Context.isValidOptimizationLevel(n)) {
            return;
        }
        throw new IllegalArgumentException("Optimization level outside [-1..9]: " + n);
    }

    public final int getMaximumInterpreterStackDepth() {
        return this.maximumInterpreterStackDepth;
    }

    public final void setMaximumInterpreterStackDepth(int n) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.optimizationLevel != -1) {
            throw new IllegalStateException("Cannot set maximumInterpreterStackDepth when optimizationLevel != -1");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Cannot set maximumInterpreterStackDepth to less than 1");
        }
        this.maximumInterpreterStackDepth = n;
    }

    public final void setSecurityController(SecurityController securityController) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (securityController == null) {
            throw new IllegalArgumentException();
        }
        if (this.securityController != null) {
            throw new SecurityException("Can not overwrite existing SecurityController object");
        }
        if (SecurityController.hasGlobal()) {
            throw new SecurityException("Can not overwrite existing global SecurityController object");
        }
        this.securityController = securityController;
    }

    public final void setClassShutter(ClassShutter classShutter) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (classShutter == null) {
            throw new IllegalArgumentException();
        }
        if (this.classShutter != null) {
            throw new SecurityException("Cannot overwrite existing ClassShutter object");
        }
        this.classShutter = classShutter;
    }

    final ClassShutter getClassShutter() {
        return this.classShutter;
    }

    public final Object getThreadLocal(Object object) {
        if (this.threadLocalMap == null) {
            return null;
        }
        return this.threadLocalMap.get(object);
    }

    public final synchronized void putThreadLocal(Object object, Object object2) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.threadLocalMap == null) {
            this.threadLocalMap = new HashMap<Object, Object>();
        }
        this.threadLocalMap.put(object, object2);
    }

    public final void removeThreadLocal(Object object) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.threadLocalMap == null) {
            return;
        }
        this.threadLocalMap.remove(object);
    }

    public final boolean hasCompileFunctionsWithDynamicScope() {
        return this.compileFunctionsWithDynamicScopeFlag;
    }

    public final void setCompileFunctionsWithDynamicScope(boolean bl) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.compileFunctionsWithDynamicScopeFlag = bl;
    }

    public static void setCachingEnabled(boolean bl) {
    }

    public final void setWrapFactory(WrapFactory wrapFactory) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (wrapFactory == null) {
            throw new IllegalArgumentException();
        }
        this.wrapFactory = wrapFactory;
    }

    public final WrapFactory getWrapFactory() {
        if (this.wrapFactory == null) {
            this.wrapFactory = new WrapFactory();
        }
        return this.wrapFactory;
    }

    public final Debugger getDebugger() {
        return this.debugger;
    }

    public final Object getDebuggerContextData() {
        return this.debuggerData;
    }

    public final void setDebugger(Debugger debugger, Object object) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.debugger = debugger;
        this.debuggerData = object;
    }

    public static DebuggableScript getDebuggableView(Script script) {
        if (script instanceof NativeFunction) {
            return ((NativeFunction)((Object)script)).getDebuggableView();
        }
        return null;
    }

    public boolean hasFeature(int n) {
        ContextFactory contextFactory = this.getFactory();
        return contextFactory.hasFeature(this, n);
    }

    public XMLLib.Factory getE4xImplementationFactory() {
        return this.getFactory().getE4xImplementationFactory();
    }

    public final int getInstructionObserverThreshold() {
        return this.instructionThreshold;
    }

    public final void setInstructionObserverThreshold(int n) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.instructionThreshold = n;
        this.setGenerateObserverCount(n > 0);
    }

    public void setGenerateObserverCount(boolean bl) {
        this.generateObserverCount = bl;
    }

    protected void observeInstructionCount(int n) {
        ContextFactory contextFactory = this.getFactory();
        contextFactory.observeInstructionCount(this, n);
    }

    public GeneratedClassLoader createClassLoader(ClassLoader classLoader) {
        ContextFactory contextFactory = this.getFactory();
        return contextFactory.createClassLoader(classLoader);
    }

    public final ClassLoader getApplicationClassLoader() {
        if (this.applicationClassLoader == null) {
            ContextFactory contextFactory = this.getFactory();
            ClassLoader classLoader = contextFactory.getApplicationClassLoader();
            if (classLoader == null) {
                ClassLoader classLoader2 = VMBridge.instance.getCurrentThreadClassLoader();
                if (classLoader2 != null && Kit.testIfCanLoadRhinoClasses(classLoader2)) {
                    return classLoader2;
                }
                Class<?> clazz = contextFactory.getClass();
                classLoader = clazz != ScriptRuntime.ContextFactoryClass ? clazz.getClassLoader() : this.getClass().getClassLoader();
            }
            this.applicationClassLoader = classLoader;
        }
        return this.applicationClassLoader;
    }

    public final void setApplicationClassLoader(ClassLoader classLoader) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (classLoader == null) {
            this.applicationClassLoader = null;
            return;
        }
        if (!Kit.testIfCanLoadRhinoClasses(classLoader)) {
            throw new IllegalArgumentException("Loader can not resolve Rhino classes");
        }
        this.applicationClassLoader = classLoader;
    }

    static Context getContext() {
        Context context = Context.getCurrentContext();
        if (context == null) {
            throw new RuntimeException("No Context associated with current Thread");
        }
        return context;
    }

    private Object compileImpl(Scriptable scriptable, Reader reader, String string, String string2, int n, Object object, boolean bl, Evaluator evaluator, ErrorReporter errorReporter) throws IOException {
        Object object2;
        if (string2 == null) {
            string2 = "unnamed script";
        }
        if (object != null && this.getSecurityController() == null) {
            throw new IllegalArgumentException("securityDomain should be null if setSecurityController() was never called");
        }
        if (!(reader == null ^ string == null)) {
            Kit.codeBug();
        }
        if (!(scriptable == null ^ bl)) {
            Kit.codeBug();
        }
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.initFromContext(this);
        if (errorReporter == null) {
            errorReporter = compilerEnvirons.getErrorReporter();
        }
        if (this.debugger != null && reader != null) {
            string = Kit.readReader(reader);
            reader = null;
        }
        Parser parser = new Parser(compilerEnvirons, errorReporter);
        if (bl) {
            parser.calledByCompileFunction = true;
        }
        ScriptOrFnNode scriptOrFnNode = string != null ? parser.parse(string, string2, n) : parser.parse(reader, string2, n);
        if (bl && (scriptOrFnNode.getFunctionCount() != 1 || scriptOrFnNode.getFirstChild() == null || scriptOrFnNode.getFirstChild().getType() != 108)) {
            throw new IllegalArgumentException("compileFunction only accepts source with single JS function: " + string);
        }
        if (evaluator == null) {
            evaluator = this.createCompiler();
        }
        String string3 = parser.getEncodedSource();
        Object object3 = evaluator.compile(compilerEnvirons, scriptOrFnNode, string3, bl);
        if (this.debugger != null) {
            if (string == null) {
                Kit.codeBug();
            }
            if (object3 instanceof DebuggableScript) {
                object2 = (DebuggableScript)object3;
                Context.notifyDebugger_r(this, (DebuggableScript)object2, string);
            } else {
                throw new RuntimeException("NOT SUPPORTED");
            }
        }
        object2 = bl ? evaluator.createFunctionObject(this, scriptable, object3, object) : evaluator.createScriptObject(object3, object);
        return object2;
    }

    private static void notifyDebugger_r(Context context, DebuggableScript debuggableScript, String string) {
        context.debugger.handleCompilationDone(context, debuggableScript, string);
        int n = 0;
        while (n != debuggableScript.getFunctionCount()) {
            Context.notifyDebugger_r(context, debuggableScript.getFunction(n), string);
            ++n;
        }
    }

    private Evaluator createCompiler() {
        Evaluator evaluator = null;
        if (this.optimizationLevel >= 0 && codegenClass != null) {
            evaluator = (Evaluator)Kit.newInstanceOrNull(codegenClass);
        }
        if (evaluator == null) {
            evaluator = Context.createInterpreter();
        }
        return evaluator;
    }

    static Evaluator createInterpreter() {
        return (Evaluator)Kit.newInstanceOrNull(interpreterClass);
    }

    public static String getSourcePositionFromStack(int[] nArray) {
        Object object;
        Context context = Context.getCurrentContext();
        if (context == null) {
            return null;
        }
        if (context.lastInterpreterFrame != null && (object = Context.createInterpreter()) != null) {
            return object.getSourcePositionFromStack(context, nArray);
        }
        object = new CharArrayWriter();
        RuntimeException runtimeException = new RuntimeException();
        runtimeException.printStackTrace(new PrintWriter((Writer)object));
        String string = ((CharArrayWriter)object).toString();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < string.length()) {
            char c = string.charAt(n4);
            if (c == ':') {
                n3 = n4;
            } else if (c == '(') {
                n = n4;
            } else if (c == ')') {
                n2 = n4;
            } else if (c == '\n' && n != -1 && n2 != -1 && n3 != -1 && n < n3 && n3 < n2) {
                String string2 = string.substring(n + 1, n3);
                if (!string2.endsWith(".java")) {
                    String string3 = string.substring(n3 + 1, n2);
                    try {
                        nArray[0] = Integer.parseInt(string3);
                        if (nArray[0] < 0) {
                            nArray[0] = 0;
                        }
                        return string2;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                n3 = -1;
                n2 = -1;
                n = -1;
            }
            ++n4;
        }
        return null;
    }

    RegExpProxy getRegExpProxy() {
        Class<?> clazz;
        if (this.regExpProxy == null && (clazz = Kit.classOrNull("org.mozilla.javascript.regexp.RegExpImpl")) != null) {
            this.regExpProxy = (RegExpProxy)Kit.newInstanceOrNull(clazz);
        }
        return this.regExpProxy;
    }

    final boolean isVersionECMA1() {
        return this.version == 0 || this.version >= 130;
    }

    SecurityController getSecurityController() {
        SecurityController securityController = SecurityController.global();
        if (securityController != null) {
            return securityController;
        }
        return this.securityController;
    }

    public final boolean isGeneratingDebugChanged() {
        return this.generatingDebugChanged;
    }

    public void addActivationName(String string) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.activationNames == null) {
            this.activationNames = new HashSet<String>();
        }
        this.activationNames.add(string);
    }

    public final boolean isActivationNeeded(String string) {
        return this.activationNames != null && this.activationNames.contains(string);
    }

    public void removeActivationName(String string) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.activationNames != null) {
            this.activationNames.remove(string);
        }
    }
}

