/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.activation;

import gnu.java.rmi.activation.BidiTable;
import gnu.java.rmi.activation.DefaultActivationSystem;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.Activator;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class ActivationSystemTransient
extends DefaultActivationSystem
implements ActivationSystem,
ActivationMonitor,
Activator {
    protected final BidiTable groupDescs;
    protected final BidiTable descriptions;
    protected final transient Map groupInstantiators = new Hashtable();
    protected final transient Map activatedObjects = new HashMap();
    static long groupIncarnations = 0L;
    static ActivationSystem singleton;
    public static boolean debug;

    static {
        debug = false;
    }

    protected ActivationSystemTransient(BidiTable objectDescriptions, BidiTable groupDescriptiopns) {
        this.descriptions = objectDescriptions;
        this.groupDescs = groupDescriptiopns;
    }

    protected ActivationSystemTransient() {
        this(new BidiTable(), new BidiTable());
    }

    public static ActivationSystem getInstance() {
        if (singleton == null) {
            singleton = new ActivationSystemTransient();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public MarshalledObject activate(ActivationID id, boolean force) throws ActivationException, UnknownObjectException, RemoteException {
        ActivationDesc desc;
        if (!force) {
            Map map = this.activatedObjects;
            // MONITORENTER : map
            MarshalledObject object = (MarshalledObject)this.activatedObjects.get(id);
            if (object != null) {
                // MONITOREXIT : map
                return object;
            }
            // MONITOREXIT : map
        }
        if ((desc = (ActivationDesc)this.descriptions.get(id)) == null) {
            String string;
            if ("Activating unknown object  " + id == null) {
                string = "null";
                throw new UnknownObjectException(string);
            }
            string = id.toString();
            throw new UnknownObjectException(string);
        }
        ActivationInstantiator group = (ActivationInstantiator)this.groupInstantiators.get(desc.getGroupID());
        if (group == null) {
            ActivationGroupID gid = desc.getGroupID();
            ActivationGroupDesc adesc = (ActivationGroupDesc)this.groupDescs.get(gid);
            if (adesc == null) {
                throw new UnknownGroupException("Activating unknown group " + gid + " for " + id + " this " + this);
            }
            Class<ActivationSystemTransient> clazz = ActivationSystemTransient.class;
            // MONITORENTER : gnu.java.rmi.activation.ActivationSystemTransient.class
            // MONITOREXIT : clazz
            group = ActivationGroup.createGroup(gid, adesc, ++groupIncarnations);
            this.activeGroup(gid, group, groupIncarnations);
        }
        MarshalledObject<? extends Remote> object = group.newInstance(id, desc);
        Map map = this.activatedObjects;
        // MONITORENTER : map
        this.activatedObjects.put(id, object);
        // MONITOREXIT : map
        return object;
    }

    public ActivationMonitor activeGroup(ActivationGroupID id, ActivationInstantiator group, long incarnation) throws UnknownGroupException, ActivationException, RemoteException {
        this.groupInstantiators.put(id, group);
        return this;
    }

    public ActivationDesc getActivationDesc(ActivationID id) throws ActivationException, UnknownObjectException, RemoteException {
        ActivationDesc desc = (ActivationDesc)this.descriptions.get(id);
        if (desc == null) {
            throw new UnknownObjectException("No desc for " + id == null ? "null" : id.toString());
        }
        return desc;
    }

    public ActivationGroupDesc getActivationGroupDesc(ActivationGroupID groupId) throws ActivationException, UnknownGroupException, RemoteException {
        ActivationGroupDesc desc = (ActivationGroupDesc)this.groupDescs.get(groupId);
        if (desc == null) {
            throw new UnknownGroupException(groupId == null ? "null" : groupId.toString());
        }
        return desc;
    }

    public ActivationGroupID registerGroup(ActivationGroupDesc groupDesc) throws ActivationException, RemoteException {
        ActivationGroupID id = (ActivationGroupID)this.groupDescs.getKey(groupDesc);
        if (id == null) {
            id = new ActivationGroupID(this);
            this.groupDescs.put(id, groupDesc);
        }
        if (debug) {
            System.out.println("Register group " + id + ":" + groupDesc + " this " + this);
        }
        return id;
    }

    public ActivationID registerObject(ActivationDesc desc) throws ActivationException, UnknownGroupException, RemoteException {
        ActivationID id = (ActivationID)this.descriptions.getKey(desc);
        if (id == null) {
            id = new ActivationID(this);
            this.descriptions.put(id, desc);
        }
        if (debug) {
            System.out.println("Register object " + id + ":" + desc + " this " + this);
        }
        return id;
    }

    public ActivationDesc setActivationDesc(ActivationID id, ActivationDesc desc) throws ActivationException, UnknownObjectException, UnknownGroupException, RemoteException {
        ActivationDesc prev = this.getActivationDesc(id);
        this.descriptions.put(id, desc);
        return prev;
    }

    public ActivationGroupDesc setActivationGroupDesc(ActivationGroupID groupId, ActivationGroupDesc groupDesc) throws ActivationException, UnknownGroupException, RemoteException {
        ActivationGroupDesc prev = this.getActivationGroupDesc(groupId);
        this.groupDescs.put(groupId, groupDesc);
        return prev;
    }

    public void shutdown() throws RemoteException {
        this.descriptions.shutdown();
        this.groupDescs.shutdown();
    }

    public void unregisterGroup(ActivationGroupID groupId) throws ActivationException, UnknownGroupException, RemoteException {
        if (!this.groupDescs.containsKey(groupId)) {
            throw new UnknownGroupException("Unknown group " + groupId);
        }
        this.groupDescs.removeKey(groupId);
        this.groupInstantiators.remove(groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObject(ActivationID id) throws ActivationException, UnknownObjectException, RemoteException {
        if (!this.descriptions.containsKey(id)) {
            throw new UnknownObjectException("Unregistering unknown object");
        }
        this.descriptions.removeKey(id);
        Map map = this.activatedObjects;
        synchronized (map) {
            this.activatedObjects.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeObject(ActivationID id, MarshalledObject obj) throws UnknownObjectException, RemoteException {
        if (!this.descriptions.containsKey(id)) {
            throw new UnknownObjectException("Activating unknown object " + id + " this " + this);
        }
        try {
            Map map = this.activatedObjects;
            synchronized (map) {
                this.activatedObjects.put(id, obj.get());
            }
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            UnknownObjectException un = new UnknownObjectException("Cannot get Remote for MarshalledObject of " + id);
            un.detail = e;
            throw un;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inactiveGroup(ActivationGroupID groupId, long incarnation) throws UnknownGroupException, RemoteException {
        if (!this.groupInstantiators.containsKey(groupId)) {
            throw new UnknownGroupException("Inactivating unkwnon group");
        }
        this.groupInstantiators.remove(groupId);
        Map map = this.activatedObjects;
        synchronized (map) {
            for (ActivationID id : this.activatedObjects.keySet()) {
                ActivationDesc desc = (ActivationDesc)this.descriptions.get(id);
                if (!desc.getGroupID().equals(groupId)) continue;
                this.activatedObjects.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inactiveObject(ActivationID id) throws UnknownObjectException, RemoteException {
        if (!this.descriptions.containsKey(id)) {
            throw new UnknownObjectException("Inactivating unknown object");
        }
        Map map = this.activatedObjects;
        synchronized (map) {
            this.activatedObjects.remove(id);
        }
    }
}

