/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.CharViewBufferImpl;
import java.nio.DoubleBuffer;
import java.nio.DoubleViewBufferImpl;
import java.nio.FloatBuffer;
import java.nio.FloatViewBufferImpl;
import java.nio.IntBuffer;
import java.nio.IntViewBufferImpl;
import java.nio.LongBuffer;
import java.nio.LongViewBufferImpl;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import java.nio.ShortViewBufferImpl;

final class ByteBufferImpl
extends ByteBuffer {
    private final boolean readOnly;

    ByteBufferImpl(byte[] buffer, int offset, int capacity, int limit, int position, int mark, boolean readOnly) {
        super(capacity, limit, position, mark, null, buffer, offset);
        this.readOnly = readOnly;
    }

    public CharBuffer asCharBuffer() {
        return new CharViewBufferImpl(this, this.remaining() >> 1);
    }

    public ShortBuffer asShortBuffer() {
        return new ShortViewBufferImpl(this, this.remaining() >> 1);
    }

    public IntBuffer asIntBuffer() {
        return new IntViewBufferImpl(this, this.remaining() >> 2);
    }

    public LongBuffer asLongBuffer() {
        return new LongViewBufferImpl(this, this.remaining() >> 3);
    }

    public FloatBuffer asFloatBuffer() {
        return new FloatViewBufferImpl(this, this.remaining() >> 2);
    }

    public DoubleBuffer asDoubleBuffer() {
        return new DoubleViewBufferImpl(this, this.remaining() >> 3);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public ByteBuffer slice() {
        return new ByteBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public ByteBuffer duplicate() {
        return new ByteBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public ByteBuffer asReadOnlyBuffer() {
        return new ByteBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    void shiftDown(int dst_offset, int src_offset, int count) {
        System.arraycopy(this.backing_buffer, this.array_offset + src_offset, this.backing_buffer, this.array_offset + dst_offset, count);
    }

    public ByteBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int pos = this.position();
        int n = this.limit() - pos;
        if (n > 0) {
            this.shiftDown(0, pos, n);
        }
        this.position(n);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public byte get() {
        if (this.pos >= this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backing_buffer[this.pos++ + this.array_offset];
    }

    public ByteBuffer get(byte[] dst, int offset, int length) {
        ByteBufferImpl.checkArraySize(dst.length, offset, length);
        if (this.limit - this.pos < length) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.backing_buffer, this.pos + this.array_offset, dst, offset, length);
        this.pos += length;
        return this;
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        if (this.limit - this.pos < length) {
            throw new BufferOverflowException();
        }
        ByteBufferImpl.checkArraySize(src.length, offset, length);
        System.arraycopy(src, offset, this.backing_buffer, this.pos + this.array_offset, length);
        this.pos += length;
        return this;
    }

    public ByteBuffer put(byte value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        if (this.pos >= this.limit) {
            throw new BufferOverflowException();
        }
        this.backing_buffer[this.pos++ + this.array_offset] = value;
        return this;
    }

    public byte get(int index) {
        this.checkIndex(index);
        return this.backing_buffer[index + this.array_offset];
    }

    public ByteBuffer put(int index, byte value) {
        this.checkIfReadOnly();
        this.checkIndex(index);
        this.backing_buffer[index + this.array_offset] = value;
        return this;
    }

    public char getChar() {
        return ByteBufferHelper.getChar(this, this.order());
    }

    public ByteBuffer putChar(char value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        if (this.limit - this.pos < 2) {
            throw new BufferOverflowException();
        }
        if (this.endian == ByteOrder.LITTLE_ENDIAN) {
            this.backing_buffer[this.pos++ + this.array_offset] = (byte)(value & 0xFF);
            this.backing_buffer[this.pos++ + this.array_offset] = (byte)(value >> 8);
        } else {
            this.backing_buffer[this.pos++ + this.array_offset] = (byte)(value >> 8);
            this.backing_buffer[this.pos++ + this.array_offset] = (byte)(value & 0xFF);
        }
        return this;
    }

    public char getChar(int index) {
        return ByteBufferHelper.getChar(this, index, this.order());
    }

    public ByteBuffer putChar(int index, char value) {
        ByteBufferHelper.putChar(this, index, value, this.order());
        return this;
    }

    public short getShort() {
        return ByteBufferHelper.getShort(this, this.order());
    }

    public ByteBuffer putShort(short value) {
        ByteBufferHelper.putShort(this, value, this.order());
        return this;
    }

    public short getShort(int index) {
        return ByteBufferHelper.getShort(this, index, this.order());
    }

    public ByteBuffer putShort(int index, short value) {
        ByteBufferHelper.putShort(this, index, value, this.order());
        return this;
    }

    public int getInt() {
        return ByteBufferHelper.getInt(this, this.order());
    }

    public ByteBuffer putInt(int value) {
        ByteBufferHelper.putInt(this, value, this.order());
        return this;
    }

    public int getInt(int index) {
        return ByteBufferHelper.getInt(this, index, this.order());
    }

    public ByteBuffer putInt(int index, int value) {
        ByteBufferHelper.putInt(this, index, value, this.order());
        return this;
    }

    public long getLong() {
        return ByteBufferHelper.getLong(this, this.order());
    }

    public ByteBuffer putLong(long value) {
        ByteBufferHelper.putLong(this, value, this.order());
        return this;
    }

    public long getLong(int index) {
        return ByteBufferHelper.getLong(this, index, this.order());
    }

    public ByteBuffer putLong(int index, long value) {
        ByteBufferHelper.putLong(this, index, value, this.order());
        return this;
    }

    public float getFloat() {
        return ByteBufferHelper.getFloat(this, this.order());
    }

    public ByteBuffer putFloat(float value) {
        ByteBufferHelper.putFloat(this, value, this.order());
        return this;
    }

    public float getFloat(int index) {
        return ByteBufferHelper.getFloat(this, index, this.order());
    }

    public ByteBuffer putFloat(int index, float value) {
        ByteBufferHelper.putFloat(this, index, value, this.order());
        return this;
    }

    public double getDouble() {
        return ByteBufferHelper.getDouble(this, this.order());
    }

    public ByteBuffer putDouble(double value) {
        ByteBufferHelper.putDouble(this, value, this.order());
        return this;
    }

    public double getDouble(int index) {
        return ByteBufferHelper.getDouble(this, index, this.order());
    }

    public ByteBuffer putDouble(int index, double value) {
        ByteBufferHelper.putDouble(this, index, value, this.order());
        return this;
    }
}

