/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MergeTranslations {
    public static void main(String[] args) throws Exception {
        String[] sourceFiles;
        File targetDirectory;
        File sourceDirectory = new File(args[0]);
        if (!sourceDirectory.isDirectory()) {
            System.exit(1);
        }
        if (!(targetDirectory = new File(args[1])).isDirectory()) {
            System.exit(1);
        }
        final String localeKey = args.length > 2 ? args[2] : "";
        for (String name : sourceFiles = sourceDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("FreeColMessages_" + localeKey + ".*\\.properties");
            }
        })) {
            int c;
            System.out.println("Processing source file: " + name);
            File sourceFile = new File(sourceDirectory, name);
            Map<String, String> sourceProperties = MergeTranslations.readFile(sourceFile);
            File targetFile = new File(targetDirectory, name);
            if (targetFile.exists()) {
                Map<String, String> targetProperties = MergeTranslations.readFile(targetFile);
                ArrayList<Map.Entry<String, String>> missingProperties = new ArrayList<Map.Entry<String, String>>();
                for (Map.Entry<String, String> entry : sourceProperties.entrySet()) {
                    if (targetProperties.containsKey(entry.getKey())) continue;
                    missingProperties.add(entry);
                }
                if (missingProperties.isEmpty()) continue;
                FileWriter out = new FileWriter(targetFile, true);
                out.write("### Merged from trunk on " + DateFormat.getDateTimeInstance().format(new Date()) + " ###\n");
                for (Map.Entry entry : missingProperties) {
                    out.write((String)entry.getKey());
                    out.write("=");
                    out.write((String)entry.getValue());
                    out.write("\n");
                }
                out.close();
                continue;
            }
            System.out.println("Copying " + name + " from trunk.");
            FileReader in = new FileReader(sourceFile);
            FileWriter out = new FileWriter(targetFile);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
        }
    }

    private static Map<String, String> readFile(File file) {
        HashMap<String, String> result = new HashMap<String, String>();
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line = bufferedReader.readLine();
            while (line != null) {
                int index = line.indexOf(61);
                if (index >= 0) {
                    result.put(line.substring(0, index), line.substring(index + 1));
                }
                line = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

