/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.StringTemplate;

public class GenerateDocumentation {
    private static final File STRING_DIRECTORY = new File("data/strings");
    private static final File RULE_DIRECTORY = new File("data/rules/classic");
    private static final File DESTINATION_DIRECTORY = new File("doc");
    private static final Map<String, String> resources = new HashMap<String, String>();
    private static final String[] sourceFiles = STRING_DIRECTORY.list(new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.matches("FreeColMessages.*\\.properties");
        }
    });

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            Arrays.sort(args);
        }
        GenerateDocumentation.readResources();
        GenerateDocumentation.generateDocumentation(args);
    }

    private static void readResources() {
        System.out.println("Processing source file: resources.properties");
        File sourceFile = new File(RULE_DIRECTORY, "resources.properties");
        try (FileReader fileReader = new FileReader(sourceFile);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line = bufferedReader.readLine();
            while (line != null) {
                int index = line.indexOf(61);
                if (index >= 0) {
                    String key = line.substring(0, index).trim();
                    String value = line.substring(index + 1).trim();
                    resources.put(key, value);
                }
                line = bufferedReader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void generateTMX() {
        HashMap<String, HashMap<String, String>> translations = new HashMap<String, HashMap<String, String>>();
        for (String name : sourceFiles) {
            System.out.println("Processing source file: " + name);
            String languageCode = name.substring(15, name.length() - 11);
            if (languageCode.isEmpty()) {
                languageCode = "en";
            } else {
                if ('_' != languageCode.charAt(0)) continue;
                languageCode = languageCode.substring(1);
            }
            File sourceFile = new File(STRING_DIRECTORY, name);
            try (FileReader fileReader = new FileReader(sourceFile);
                 BufferedReader bufferedReader = new BufferedReader(fileReader);){
                String line = bufferedReader.readLine();
                while (line != null) {
                    int index = line.indexOf(61);
                    if (index >= 0) {
                        String key = line.substring(0, index).trim();
                        String value = line.substring(index + 1).trim().replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;");
                        HashMap<String, String> map = (HashMap<String, String>)translations.get(key);
                        if (map == null) {
                            map = new HashMap<String, String>();
                            translations.put(key, map);
                        }
                        map.put(languageCode, value);
                    }
                    line = bufferedReader.readLine();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        File destinationFile = new File(DESTINATION_DIRECTORY, "freecol.tmx");
        try (FileWriter out = new FileWriter(destinationFile);){
            out.write("<?xml version =\"1.0\" encoding=\"UTF-8\"?>\n");
            out.write("<tmx version=\"1.4b\">\n");
            out.write("<body>\n");
            for (Map.Entry tu : translations.entrySet()) {
                out.write("  <tu tuid=\"" + (String)tu.getKey() + "\">\n");
                for (Map.Entry tuv : ((Map)tu.getValue()).entrySet()) {
                    out.write("    <tuv xml:lang=\"" + (String)tuv.getKey() + "\">\n");
                    out.write("      <seg>" + (String)tuv.getValue() + "</seg>\n");
                    out.write("    </tuv>\n");
                }
                out.write("  </tu>\n");
            }
            out.write("</body>\n");
            out.write("</tmx>\n");
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateDocumentation(String[] languages) {
        for (String name : sourceFiles) {
            String languageCode = name.substring(15, name.length() - 11);
            if (languageCode.isEmpty()) {
                languageCode = "en";
            } else {
                if ('_' != languageCode.charAt(0)) continue;
                if ("qqq".equals(languageCode = languageCode.substring(1))) {
                    System.out.println("Skipping language code 'qqq'");
                    continue;
                }
            }
            if (languages.length != 0 && Arrays.binarySearch(languages, languageCode) < 0) continue;
            System.out.println("Generating localized documentation for language code " + languageCode);
            Messages.setMessageBundle(Messages.getLocale(languageCode));
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                StreamSource xsl = new StreamSource(new File("doc", "specification.xsl"));
                Transformer stylesheet = factory.newTransformer(xsl);
                StreamSource request = new StreamSource(new File(RULE_DIRECTORY, "specification.xml"));
                StreamResult response = new StreamResult(new File(DESTINATION_DIRECTORY, "specification_" + languageCode + ".html"));
                stylesheet.transform(request, response);
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getResource(String key) {
        return resources.get(key);
    }

    public static String localize(String template) {
        return Messages.message(template);
    }

    public static String localize(String template, String key, String number) {
        double num = Double.parseDouble(number);
        StringTemplate stringTemplate = StringTemplate.template(template).addAmount(key, num);
        return Messages.message(stringTemplate);
    }
}

